//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorydisplayedstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICellAccessoryDisplayedState(pub NSInteger);
impl UICellAccessoryDisplayedState {
    /// The accessory is always displayed.
    #[doc(alias = "UICellAccessoryDisplayedAlways")]
    pub const Always: Self = Self(0);
    /// The accessory is displayed only when the cell is editing.
    #[doc(alias = "UICellAccessoryDisplayedWhenEditing")]
    pub const WhenEditing: Self = Self(1);
    /// The accessory is displayed only when the cell is not editing.
    #[doc(alias = "UICellAccessoryDisplayedWhenNotEditing")]
    pub const WhenNotEditing: Self = Self(2);
}

unsafe impl Encode for UICellAccessoryDisplayedState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICellAccessoryDisplayedState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// A special constant that can be set to the `reservedLayoutWidth` property. This requests the
    /// system standard layout width.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorystandarddimension?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UICellAccessoryStandardDimension: CGFloat;
}

extern_class!(
    /// Abstract base class. Do not instantiate directly.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessory?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessory;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessory {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessory {}
);

unsafe impl CopyingHelper for UICellAccessory {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessory {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessory {}
);

impl UICellAccessory {
    extern_methods!(
        /// The state(s) for which the accessory should be displayed.
        #[unsafe(method(displayedState))]
        #[unsafe(method_family = none)]
        pub fn displayedState(&self) -> UICellAccessoryDisplayedState;

        /// Setter for [`displayedState`][Self::displayedState].
        #[unsafe(method(setDisplayedState:))]
        #[unsafe(method_family = none)]
        pub fn setDisplayedState(&self, displayed_state: UICellAccessoryDisplayedState);

        /// Hidden accessories take up space in the layout, but are not visible and do not provide any behaviors.
        /// Use this property to achieve a consistent layout across cells when some show the accessory and others do not.
        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);

        #[cfg(feature = "objc2-core-foundation")]
        /// The layout width that is reserved for the accessory, inside which the accessory will be centered.
        /// This is used to ensure horizontal alignment of different accessories in adjacent cells, even when
        /// the actual accessory view width varies slightly. A value of 0 means the actual width of the
        /// accessory will be used. Use UICellAccessoryStandardDimension to request the standard width.
        #[unsafe(method(reservedLayoutWidth))]
        #[unsafe(method_family = none)]
        pub fn reservedLayoutWidth(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`reservedLayoutWidth`][Self::reservedLayoutWidth].
        #[unsafe(method(setReservedLayoutWidth:))]
        #[unsafe(method_family = none)]
        pub fn setReservedLayoutWidth(&self, reserved_layout_width: CGFloat);

        #[cfg(feature = "UIColor")]
        /// The tint color to apply to the accessory. Default value is nil, which uses the system default.
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub fn tintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub fn setTintColor(&self, tint_color: Option<&UIColor>);

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessory {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A disclosure chevron that points in the trailing direction.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorydisclosureindicator?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryDisclosureIndicator;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryDisclosureIndicator {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryDisclosureIndicator {}
);

unsafe impl CopyingHelper for UICellAccessoryDisclosureIndicator {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryDisclosureIndicator {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryDisclosureIndicator {}
);

impl UICellAccessoryDisclosureIndicator {
    extern_methods!();
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryDisclosureIndicator {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryDisclosureIndicator {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A detail (info) button.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorydetail?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryDetail;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryDetail {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryDetail {}
);

unsafe impl CopyingHelper for UICellAccessoryDetail {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryDetail {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryDetail {}
);

impl UICellAccessoryDetail {
    extern_methods!(
        #[cfg(feature = "block2")]
        /// An optional handler to call when the detail accessory is tapped. If nil, taps on the accessory are ignored.
        #[unsafe(method(actionHandler))]
        #[unsafe(method_family = none)]
        pub fn actionHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`actionHandler`][Self::actionHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setActionHandler:))]
        #[unsafe(method_family = none)]
        pub fn setActionHandler(&self, action_handler: Option<&block2::DynBlock<dyn Fn()>>);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryDetail {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryDetail {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A checkmark with default green color.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorycheckmark?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryCheckmark;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryCheckmark {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryCheckmark {}
);

unsafe impl CopyingHelper for UICellAccessoryCheckmark {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryCheckmark {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryCheckmark {}
);

impl UICellAccessoryCheckmark {
    extern_methods!();
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryCheckmark {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryCheckmark {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A delete control (minus sign inside a circle) with default red color.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorydelete?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryDelete;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryDelete {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryDelete {}
);

unsafe impl CopyingHelper for UICellAccessoryDelete {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryDelete {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryDelete {}
);

impl UICellAccessoryDelete {
    extern_methods!(
        #[cfg(feature = "UIColor")]
        /// The background color to apply to the accessory. Default value is nil, which uses the system default.
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);

        #[cfg(feature = "block2")]
        /// An optional handler to call when the delete accessory is tapped. If nil, a tap will reveal any trailing swipe actions for the cell.
        #[unsafe(method(actionHandler))]
        #[unsafe(method_family = none)]
        pub fn actionHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`actionHandler`][Self::actionHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setActionHandler:))]
        #[unsafe(method_family = none)]
        pub fn setActionHandler(&self, action_handler: Option<&block2::DynBlock<dyn Fn()>>);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryDelete {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryDelete {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// An insert control (plus sign inside a circle) with default green color.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryinsert?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryInsert;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryInsert {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryInsert {}
);

unsafe impl CopyingHelper for UICellAccessoryInsert {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryInsert {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryInsert {}
);

impl UICellAccessoryInsert {
    extern_methods!(
        #[cfg(feature = "UIColor")]
        /// The background color to apply to the accessory. Default value is nil, which uses the system default.
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);

        #[cfg(feature = "block2")]
        /// An optional handler to call when the insert accessory is tapped. If nil, taps on the accessory are ignored.
        #[unsafe(method(actionHandler))]
        #[unsafe(method_family = none)]
        pub fn actionHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`actionHandler`][Self::actionHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setActionHandler:))]
        #[unsafe(method_family = none)]
        pub fn setActionHandler(&self, action_handler: Option<&block2::DynBlock<dyn Fn()>>);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryInsert {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryInsert {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A reorder control (three horizontal lines) with default gray color that automatically initiates interactive
    /// reordering on the collection view when dragged (if supported).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryreorder?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryReorder;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryReorder {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryReorder {}
);

unsafe impl CopyingHelper for UICellAccessoryReorder {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryReorder {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryReorder {}
);

impl UICellAccessoryReorder {
    extern_methods!(
        /// Whether a vertical separator is displayed before the accessory when it is placed after another accessory. Default is YES.
        #[unsafe(method(showsVerticalSeparator))]
        #[unsafe(method_family = none)]
        pub fn showsVerticalSeparator(&self) -> bool;

        /// Setter for [`showsVerticalSeparator`][Self::showsVerticalSeparator].
        #[unsafe(method(setShowsVerticalSeparator:))]
        #[unsafe(method_family = none)]
        pub fn setShowsVerticalSeparator(&self, shows_vertical_separator: bool);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryReorder {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryReorder {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A two-state control whose appearance follows the selection state of the cell (empty circle when deselected,
    /// filled circle with checkmark when selected).
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorymultiselect?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryMultiselect;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryMultiselect {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryMultiselect {}
);

unsafe impl CopyingHelper for UICellAccessoryMultiselect {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryMultiselect {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryMultiselect {}
);

impl UICellAccessoryMultiselect {
    extern_methods!(
        #[cfg(feature = "UIColor")]
        /// The background color to apply to the accessory. Default value is nil, which uses the system default.
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&UIColor>);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryMultiselect {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryMultiselect {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryoutlinedisclosurestyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICellAccessoryOutlineDisclosureStyle(pub NSInteger);
impl UICellAccessoryOutlineDisclosureStyle {
    /// The style will be automatically determined based on whether the cell is configured to be a section header or not.
    #[doc(alias = "UICellAccessoryOutlineDisclosureStyleAutomatic")]
    pub const Automatic: Self = Self(0);
    /// A style appropriate for a section header, where a tap anywhere in the header will toggle the expansion state
    /// of the item (the cell cannot be selected).
    #[doc(alias = "UICellAccessoryOutlineDisclosureStyleHeader")]
    pub const Header: Self = Self(1);
    /// A style appropriate for a cell which can be selected itself and also has nested children, where only taps on the
    /// outline disclosure will toggle the expansion state of the item; taps on the cell will select the item as normal.
    #[doc(alias = "UICellAccessoryOutlineDisclosureStyleCell")]
    pub const Cell: Self = Self(2);
}

unsafe impl Encode for UICellAccessoryOutlineDisclosureStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICellAccessoryOutlineDisclosureStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A rotating disclosure chevron for use with outlines, used to indicate and toggle the expanded/collapsed state of the item.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryoutlinedisclosure?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryOutlineDisclosure;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryOutlineDisclosure {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryOutlineDisclosure {}
);

unsafe impl CopyingHelper for UICellAccessoryOutlineDisclosure {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryOutlineDisclosure {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryOutlineDisclosure {}
);

impl UICellAccessoryOutlineDisclosure {
    extern_methods!(
        /// The style of the outline disclosure accessory. Default is automatic.
        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> UICellAccessoryOutlineDisclosureStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStyle(&self, style: UICellAccessoryOutlineDisclosureStyle);

        #[cfg(feature = "block2")]
        /// An optional handler to call when the outline disclosure accessory is tapped. If nil, the default behavior when using
        /// a NSDiffableDataSourceSectionSnapshot is to toggle the expand/collapse state of the item in the section snapshot.
        #[unsafe(method(actionHandler))]
        #[unsafe(method_family = none)]
        pub fn actionHandler(&self) -> *mut block2::DynBlock<dyn Fn()>;

        #[cfg(feature = "block2")]
        /// Setter for [`actionHandler`][Self::actionHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setActionHandler:))]
        #[unsafe(method_family = none)]
        pub fn setActionHandler(&self, action_handler: Option<&block2::DynBlock<dyn Fn()>>);
    );
}

/// Methods declared on superclass `UICellAccessory`.
impl UICellAccessoryOutlineDisclosure {
    extern_methods!(
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UICellAccessoryOutlineDisclosure {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// Up/down chevrons that indicate a tap anywhere in the cell presents a pop-up menu.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorypopupmenu?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryPopUpMenu;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryPopUpMenu {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryPopUpMenu {}
);

unsafe impl CopyingHelper for UICellAccessoryPopUpMenu {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryPopUpMenu {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryPopUpMenu {}
);

impl UICellAccessoryPopUpMenu {
    extern_methods!(
        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a new pop-up menu accessory using the provided menu.
        #[unsafe(method(initWithMenu:))]
        #[unsafe(method_family = init)]
        pub fn initWithMenu(this: Allocated<Self>, menu: &UIMenu) -> Retained<Self>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub fn menu(&self) -> Retained<UIMenu>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// An optional handler to call when the selected element in the menu changes.
        ///
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer.
        #[unsafe(method(selectedElementDidChangeHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn selectedElementDidChangeHandler(
            &self,
        ) -> *mut block2::DynBlock<dyn Fn(NonNull<UIMenu>)>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// Setter for [`selectedElementDidChangeHandler`][Self::selectedElementDidChangeHandler].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSelectedElementDidChangeHandler:))]
        #[unsafe(method_family = none)]
        pub fn setSelectedElementDidChangeHandler(
            &self,
            selected_element_did_change_handler: Option<&block2::DynBlock<dyn Fn(NonNull<UIMenu>)>>,
        );

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// A label displaying a short string of text, typically a small number such as a count for the associated item.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorylabel?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryLabel;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryLabel {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryLabel {}
);

unsafe impl CopyingHelper for UICellAccessoryLabel {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryLabel {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryLabel {}
);

impl UICellAccessoryLabel {
    extern_methods!(
        /// Creates a new label accessory using the provided text.
        #[unsafe(method(initWithText:))]
        #[unsafe(method_family = init)]
        pub fn initWithText(this: Allocated<Self>, text: &NSString) -> Retained<Self>;

        #[unsafe(method(text))]
        #[unsafe(method_family = none)]
        pub fn text(&self) -> Retained<NSString>;

        #[cfg(feature = "UIFont")]
        /// The font used for the label. Default is the preferred font for UIFontTextStyleBody.
        #[unsafe(method(font))]
        #[unsafe(method_family = none)]
        pub fn font(&self) -> Retained<UIFont>;

        #[cfg(feature = "UIFont")]
        /// Setter for [`font`][Self::font].
        #[unsafe(method(setFont:))]
        #[unsafe(method_family = none)]
        pub fn setFont(&self, font: &UIFont);

        /// Whether the label automatically adjusts its font based on the content size category. Default is YES.
        #[unsafe(method(adjustsFontForContentSizeCategory))]
        #[unsafe(method_family = none)]
        pub fn adjustsFontForContentSizeCategory(&self) -> bool;

        /// Setter for [`adjustsFontForContentSizeCategory`][Self::adjustsFontForContentSizeCategory].
        #[unsafe(method(setAdjustsFontForContentSizeCategory:))]
        #[unsafe(method_family = none)]
        pub fn setAdjustsFontForContentSizeCategory(
            &self,
            adjusts_font_for_content_size_category: bool,
        );

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryplacement?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICellAccessoryPlacement(pub NSInteger);
impl UICellAccessoryPlacement {
    /// Accessory placed on the leading edge.
    #[doc(alias = "UICellAccessoryPlacementLeading")]
    pub const Leading: Self = Self(0);
    /// Accessory placed on the trailing edge.
    #[doc(alias = "UICellAccessoryPlacementTrailing")]
    pub const Trailing: Self = Self(1);
}

unsafe impl Encode for UICellAccessoryPlacement {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICellAccessoryPlacement {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// Return an index to insert the accessory at, given an array of the existing accessories on the edge (in leading to trailing order).
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessoryposition?language=objc)
#[cfg(feature = "block2")]
pub type UICellAccessoryPosition =
    *mut block2::DynBlock<dyn Fn(NonNull<NSArray<UICellAccessory>>) -> NSUInteger>;

impl UICellAccessory {
    /// Positions the accessory before the accessory matching the class specified, or at the beginning if not found.
    ///
    /// # Safety
    ///
    /// - `accessory_class` probably has further requirements.
    /// - The returned block's argument must be a valid pointer.
    #[doc(alias = "UICellAccessoryPositionBeforeAccessoryOfClass")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn position_before_accessory_of_class(
        accessory_class: &AnyClass,
    ) -> UICellAccessoryPosition {
        extern "C-unwind" {
            fn UICellAccessoryPositionBeforeAccessoryOfClass(
                accessory_class: &AnyClass,
            ) -> UICellAccessoryPosition;
        }
        unsafe { UICellAccessoryPositionBeforeAccessoryOfClass(accessory_class) }
    }

    /// Positions the accessory after the accessory matching the class specified, or at the end if not found.
    ///
    /// # Safety
    ///
    /// - `accessory_class` probably has further requirements.
    /// - The returned block's argument must be a valid pointer.
    #[doc(alias = "UICellAccessoryPositionAfterAccessoryOfClass")]
    #[cfg(feature = "block2")]
    #[inline]
    pub unsafe fn position_after_accessory_of_class(
        accessory_class: &AnyClass,
    ) -> UICellAccessoryPosition {
        extern "C-unwind" {
            fn UICellAccessoryPositionAfterAccessoryOfClass(
                accessory_class: &AnyClass,
            ) -> UICellAccessoryPosition;
        }
        unsafe { UICellAccessoryPositionAfterAccessoryOfClass(accessory_class) }
    }
}

extern_class!(
    /// An accessory using a custom view.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uicellaccessorycustomview?language=objc)
    #[unsafe(super(UICellAccessory, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICellAccessoryCustomView;
);

extern_conformance!(
    unsafe impl NSCoding for UICellAccessoryCustomView {}
);

extern_conformance!(
    unsafe impl NSCopying for UICellAccessoryCustomView {}
);

unsafe impl CopyingHelper for UICellAccessoryCustomView {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICellAccessoryCustomView {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for UICellAccessoryCustomView {}
);

impl UICellAccessoryCustomView {
    extern_methods!(
        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Creates a new custom view accessory using the provided view and specified placement. The custom view must have translatesAutoresizingMaskIntoConstraints
        /// enabled, but may use auto layout constraints internally for layout of subviews and/or to indicate its preferred size.
        #[unsafe(method(initWithCustomView:placement:))]
        #[unsafe(method_family = init)]
        pub fn initWithCustomView_placement(
            this: Allocated<Self>,
            custom_view: &UIView,
            placement: UICellAccessoryPlacement,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[unsafe(method(customView))]
        #[unsafe(method_family = none)]
        pub fn customView(&self) -> Retained<UIView>;

        #[unsafe(method(placement))]
        #[unsafe(method_family = none)]
        pub fn placement(&self) -> UICellAccessoryPlacement;

        /// Whether the current frame size of the view is preserved (YES), or whether it is sized during layout of accessories (NO). Default is NO.
        #[unsafe(method(maintainsFixedSize))]
        #[unsafe(method_family = none)]
        pub fn maintainsFixedSize(&self) -> bool;

        /// Setter for [`maintainsFixedSize`][Self::maintainsFixedSize].
        #[unsafe(method(setMaintainsFixedSize:))]
        #[unsafe(method_family = none)]
        pub fn setMaintainsFixedSize(&self, maintains_fixed_size: bool);

        #[cfg(feature = "block2")]
        /// Allows customizing the relative position of the accessory amongst any other accessories displayed on the same edge.
        /// The default is to insert the accessory at a position closest to the inside of the cell.
        ///
        /// # Safety
        ///
        /// The returned block's argument must be a valid pointer.
        #[unsafe(method(position))]
        #[unsafe(method_family = none)]
        pub unsafe fn position(&self) -> UICellAccessoryPosition;

        #[cfg(feature = "block2")]
        /// Setter for [`position`][Self::position].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `position` must be a valid pointer.
        #[unsafe(method(setPosition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPosition(&self, position: UICellAccessoryPosition);

        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `UICellAccessory::position_before_accessory_of_class`"]
    pub fn UICellAccessoryPositionBeforeAccessoryOfClass(
        accessory_class: &AnyClass,
    ) -> UICellAccessoryPosition;
}

extern "C-unwind" {
    #[cfg(feature = "block2")]
    #[deprecated = "renamed to `UICellAccessory::position_after_accessory_of_class`"]
    pub fn UICellAccessoryPositionAfterAccessoryOfClass(
        accessory_class: &AnyClass,
    ) -> UICellAccessoryPosition;
}
