/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chttextcontrol.cc,v 1.6 2008/12/19 06:45:08 jdratlif Exp $

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif
 
#include <vector>

#include <wx/wxprec.h>

#ifndef WX_PRECOMP
   #include <wx/wx.h>
#endif

#include "exceptions/invalidchtfileexception.hh"
#include "tools/chtfilereader.hh"
#include "view/chtfiledroptarget.hh"
#include "view/chtframe.hh"
#include "view/chttextcontrol.hh"

using namespace wxCHTDecoder;

const wxFont *CHTTextControl::MONOSPACED_FONT = 0;

CHTTextControl::CHTTextControl(CHTFrame *parent) :
    wxTextCtrl(parent, -1, wxEmptyString, wxDefaultPosition,
        wxDefaultSize, wxTE_MULTILINE | wxTE_READONLY | wxTE_RICH) {
    this->parent = parent;
    SetDropTarget(new CHTFileDropTarget(this));

    if (!MONOSPACED_FONT) {
        MONOSPACED_FONT = new wxFont(12, wxFONTFAMILY_MODERN, 
            wxFONTSTYLE_NORMAL, wxFONTWEIGHT_NORMAL);
    }
}

bool CHTTextControl::readCHTFile(wxString &filename) {
    CHTFileReader &reader = CHTFileReader::getInstance();
        
    if (!CHTFileReader::isValidCHTFile(filename)) {
        wxMessageDialog dlg(this, wxT("Are you sure you want to open it?"), 
                            wxT("Potentially Invalid .CHT File..."),
                            (wxYES_NO | wxNO_DEFAULT | wxICON_QUESTION));
                                
        if (dlg.ShowModal() != wxID_YES) {
            return false;
        }
    }
    
    try {
        std::vector<CHTCode> &list = reader.readCHTFile(filename, true);
        wxString code;
            
        Clear();
        SetFont(*MONOSPACED_FONT);
            
        for (size_t i = 0; i < list.size(); i++) {
            code.Clear();
            code.Printf(wxT("%2d: %s\n"), (i + 1), 
                        list[i].toString().c_str());
            AppendText(code);
        }
                
        if (list.size() > 0) {
            parent->fileMenu->Enable(wxID_SAVE, true);
        }
    } catch (InvalidCHTFileException e) {
        return false;
    }
    
    return true;
}

