<?php

namespace MediaWiki\Extension\AbuseFilter\Parser;

/**
 * A class representing a whole AST generated by AFPTreeParser, holding AFPTreeNode's. This wrapper
 * could be expanded in the future. For now, it's mostly useful for typehints, and to have an
 * evalTree function in the evaluator.
 */
class AFPSyntaxTree {
	/**
	 * @var AFPTreeNode|null
	 */
	private $rootNode;

	/**
	 * @param AFPTreeNode|null $root
	 */
	public function __construct( ?AFPTreeNode $root = null ) {
		$this->rootNode = $root;
	}

	public function getRoot(): ?AFPTreeNode {
		return $this->rootNode;
	}
}
