<?php
/**
 * @license GPL-2.0-or-later
 * @file
 */

namespace MediaWiki\Tests\Unit\Permissions;

use MediaWiki\Permissions\RateLimitSubject;
use MediaWiki\User\UserIdentityValue;
use MediaWikiUnitTestCase;

/**
 * @group Permissions
 * @covers \MediaWiki\Permissions\RateLimitSubject
 */
class RateLimitSubjectTest extends MediaWikiUnitTestCase {

	public static function provideIp(): array {
		return [
			'null' => [ null, true ],
			'empty' => [ '', true ],
			'ipv4' => [ '10.0.0.1', true ],
			'ipv6' => [ '2001:db8:1::', true ],
		];
	}

	/**
	 * @dataProvider provideIp
	 */
	public function testConstructorAndGetters( $ip, $expected ) {
		$actor = new UserIdentityValue( 12, 'Test' );
		$flags = [ 'foo' => true, 'bar' => false ];

		$subject = new RateLimitSubject( $actor, $ip, $flags );
		$this->assertInstanceOf( RateLimitSubject::class, $subject );

		$this->assertSame( $actor, $subject->getUser(), 'The getUser method did not return the expected actor.' );
		$this->assertSame( $expected ? $ip : null, $subject->getIp(),
			'The getIp method did not return the expected IP.' );
		$this->assertTrue( $subject->is( 'foo' ), 'The is method did not return true for flag "foo".' );
		$this->assertFalse( $subject->is( 'bar' ), 'The is method did not return false for flag "bar".' );
		$this->assertFalse( $subject->is( 'baz' ),
			'The is method returned true for an undefined flag "baz", expected false.' );
	}

}
