/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.domain.taint;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TaintSink {
    public final String fqn;
    public final boolean takesInstance;
    public final Set<Integer> takesArgs;
    public final Set<String> takesGlobals;

    public TaintSink(String fqn, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        if (!takesInstance && takesArgs.isEmpty() && takesGlobals.isEmpty()) {
            throw new RuntimeException(String.format("Tainted sink for method %s must have taint somewhere!", fqn));
        }
        this.fqn = fqn;
        this.takesInstance = takesInstance;
        this.takesArgs = takesArgs;
        this.takesGlobals = takesGlobals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaintSink)) {
            return false;
        }
        TaintSink taintSink = (TaintSink)o;
        return this.takesInstance == taintSink.takesInstance && Objects.equals(this.fqn, taintSink.fqn) && Objects.equals(this.takesArgs, taintSink.takesArgs) && Objects.equals(this.takesGlobals, taintSink.takesGlobals);
    }

    public int hashCode() {
        return Objects.hash(this.fqn, this.takesInstance, this.takesArgs, this.takesGlobals);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[TaintSink] ").append(this.fqn);
        if (this.takesInstance) {
            result.append(", takes instance");
        }
        if (!this.takesArgs.isEmpty()) {
            result.append(", takes args (").append(this.takesArgs.stream().map(Objects::toString).sorted().collect(Collectors.joining(", "))).append(")");
        }
        if (!this.takesGlobals.isEmpty()) {
            result.append(", takes globals (").append(this.takesGlobals.stream().sorted().collect(Collectors.joining(", "))).append(")");
        }
        return result.toString();
    }
}

