/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.MemberVisitor;

public class MemberAccessFilter
implements MemberVisitor {
    private static final int ACCESS_MASK = 7;
    private final int requiredSetAccessFlags;
    private final int requiredUnsetAccessFlags;
    private final int requiredOneSetAccessFlags;
    private final MemberVisitor acceptedMemberVisitor;
    private final MemberVisitor rejectedMemberVisitor;

    public MemberAccessFilter(int requiredSetAccessFlags, int requiredUnsetAccessFlags, MemberVisitor acceptedMemberVisitor) {
        this(requiredSetAccessFlags, requiredUnsetAccessFlags, acceptedMemberVisitor, null);
    }

    public MemberAccessFilter(int requiredSetAccessFlags, int requiredUnsetAccessFlags, MemberVisitor acceptedMemberVisitor, MemberVisitor rejectedMemberVisitor) {
        this.requiredSetAccessFlags = requiredSetAccessFlags & 0xFFFFFFF8;
        this.requiredUnsetAccessFlags = requiredUnsetAccessFlags;
        this.requiredOneSetAccessFlags = requiredSetAccessFlags & 7;
        this.acceptedMemberVisitor = acceptedMemberVisitor;
        this.rejectedMemberVisitor = rejectedMemberVisitor;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        MemberVisitor delegateVisitor = this.getDelegateVisitor(member.getAccessFlags());
        if (delegateVisitor != null) {
            member.accept(clazz, delegateVisitor);
        }
    }

    private MemberVisitor getDelegateVisitor(int accessFlags) {
        return this.accepted(accessFlags) ? this.acceptedMemberVisitor : this.rejectedMemberVisitor;
    }

    private boolean accepted(int accessFlags) {
        return (this.requiredSetAccessFlags & ~accessFlags) == 0 && (this.requiredUnsetAccessFlags & accessFlags) == 0 && (this.requiredOneSetAccessFlags == 0 || (this.requiredOneSetAccessFlags & accessFlags) != 0);
    }
}

