/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.ProgramClassOptimizationInfo;

public class OptimizationInfoClassFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public OptimizationInfoClassFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (ClassOptimizationInfo.getClassOptimizationInfo(programClass) instanceof ProgramClassOptimizationInfo) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (ClassOptimizationInfo.getClassOptimizationInfo(libraryClass) instanceof ProgramClassOptimizationInfo) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

