#!/bin/sh
#
# [ 1.5.03 | Gunter Wambaugh ]
# Script for building a binary slackware package (.tgz). 

# The package name.
PACKAGE=gtk-splitter

# The current version.
VERSION=2.2.1

# The architecture.
ARCH=i386

# The build/package version.
BUILD=1

# The current directory.
CWD=`pwd`

# Path to temporary storage.
if [ "$TMP" = "" ]
then
    TMP=/tmp
fi

# Generate a distribution tarball.
./configure
make dist

# Unpack the distribution tarball.
cd $TMP
tar -xzvf $CWD/$PACKAGE-$VERSION.tar.gz

# Compile.
cd $PACKAGE-$VERSION
CFLAGS="-O2 -march=i386 -mcpu=i686" \
./configure \
  --prefix=/usr
make

##### Set up the package. #####

# Copy the executable. 
mkdir -p --verbose $TMP/package-$PACKAGE/usr/bin
cp -f --verbose src/gtk-splitter $TMP/package-$PACKAGE/usr/bin/
chmod --verbose 755 $TMP/package-$PACKAGE/usr/bin/gtk-splitter
strip $TMP/package-$PACKAGE/usr/bin/gtk-splitter

# Copy the icon.
mkdir -p --verbose $TMP/package-$PACKAGE/usr/share/pixmaps
cp -f --verbose gtk-splitter.png $TMP/package-$PACKAGE/usr/share/pixmaps/
chmod --verbose 644 $TMP/package-$PACKAGE/usr/share/pixmaps/gtk-splitter.png

# Copy the desktop launcher.
mkdir -p --verbose $TMP/package-$PACKAGE/usr/share/gnome/apps/Utilities
cp -f --verbose gtk-splitter.desktop $TMP/package-$PACKAGE/usr/share/gnome/apps/Utilities/gtk-splitter.desktop
chmod --verbose 644 $TMP/package-$PACKAGE/usr/share/gnome/apps/Utilities/gtk-splitter.desktop

# Copy the GNU Documents.
mkdir -p --verbose $TMP/package-$PACKAGE/usr/doc/$PACKAGE-$VERSION
cp -f --verbose ChangeLog AUTHORS COPYING HOSTS INSTALL README TODO NEWS $TMP/package-$PACKAGE/usr/doc/$PACKAGE-$VERSION/
chmod --verbose 644 $TMP/package-$PACKAGE/usr/doc/$PACKAGE-$VERSION/*

# Copy the package description.
mkdir -p --verbose $TMP/package-$PACKAGE/install
cat $CWD/slack-desc > $TMP/package-$PACKAGE/install/slack-desc

# Post install script.
echo "" > doinst.sh
echo "chown root:bin --verbose /usr/bin/gtk-splitter" >> $TMP/package-$PACKAGE/install/doinst.sh
echo "chown root:root --verbose /usr/share/pixmaps/gtk-splitter.png" >> $TMP/package-$PACKAGE/install/doinst.sh
echo "chown root:root --verbose /usr/share/gnome/apps/Utilities/gtk-splitter.desktop" >> $TMP/package-$PACKAGE/install/doinst.sh
echo "chown root:root --verbose /usr/doc/$PACKAGE-$VERSION/*" >> $TMP/package-$PACKAGE/install/doinst.sh
chmod --verbose 755 $TMP/package-$PACKAGE/install/doinst.sh

##### End of package setup. #####

# Build the package:
cd $TMP/package-$PACKAGE
/sbin/makepkg -l y -c n $TMP/$PACKAGE-$VERSION-$ARCH-$BUILD.tgz

# Put the package in this directory.
mv -f --verbose $TMP/$PACKAGE-$VERSION-$ARCH-$BUILD.tgz $CWD

# Remove the build environment.
rm -fr --verbose $TMP/$PACKAGE-$VERSION
rm -fr --verbose $TMP/package-$PACKAGE
rm -f --verbose $CWD/$PACKAGE-$VERSION.tar.gz

echo
echo "********************************************************************"
echo "If you have just built a package for an architecture that was not"
echo "already available, then please email it to me <techgunter@yahoo.com>"
echo "and I will post it on the project web site."
