/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import net.kyori.adventure.text.serializer.legacytext3.LegacyText3ComponentSerializer;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KickedFromServerEvent
implements ResultedEvent<ServerKickResult> {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable net.kyori.adventure.text.Component originalReason;
    private final boolean duringServerConnect;
    private ServerKickResult result;

    @Deprecated
    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, Component fancyReason) {
        this(player, server, originalReason, duringServerConnect, (ServerKickResult)Notify.create(fancyReason));
    }

    @Deprecated
    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, ServerKickResult result) {
        this(player, server, originalReason == null ? null : LegacyText3ComponentSerializer.get().deserialize(originalReason), duringServerConnect, result);
    }

    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable net.kyori.adventure.text.Component originalReason, boolean duringServerConnect, ServerKickResult result) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.server = Preconditions.checkNotNull(server, "server");
        this.originalReason = originalReason;
        this.duringServerConnect = duringServerConnect;
        this.result = Preconditions.checkNotNull(result, "result");
    }

    @Override
    public ServerKickResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull ServerKickResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public Player getPlayer() {
        return this.player;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    @Deprecated
    public Optional<Component> getOriginalReason() {
        return Optional.ofNullable(this.originalReason).map(LegacyText3ComponentSerializer.get()::serialize);
    }

    public Optional<net.kyori.adventure.text.Component> getServerKickReason() {
        return Optional.ofNullable(this.originalReason);
    }

    public boolean kickedDuringServerConnect() {
        return this.duringServerConnect;
    }

    @Deprecated
    public boolean kickedDuringLogin() {
        return this.duringServerConnect;
    }

    public static final class Notify
    implements ServerKickResult {
        private final net.kyori.adventure.text.Component message;

        private Notify(net.kyori.adventure.text.Component message) {
            this.message = Preconditions.checkNotNull(message, "message");
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        @Deprecated
        public Component getMessage() {
            return LegacyText3ComponentSerializer.get().serialize(this.message);
        }

        public net.kyori.adventure.text.Component getMessageComponent() {
            return this.message;
        }

        @Deprecated
        public static Notify create(Component message) {
            return new Notify(LegacyText3ComponentSerializer.get().deserialize(message));
        }

        public static Notify create(net.kyori.adventure.text.Component message) {
            return new Notify(message);
        }
    }

    public static final class RedirectPlayer
    implements ServerKickResult {
        private final net.kyori.adventure.text.Component message;
        private final RegisteredServer server;

        private RedirectPlayer(RegisteredServer server, @Nullable net.kyori.adventure.text.Component message) {
            this.server = Preconditions.checkNotNull(server, "server");
            this.message = message;
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public RegisteredServer getServer() {
            return this.server;
        }

        @Deprecated
        public Component getMessage() {
            return LegacyText3ComponentSerializer.get().serialize(this.message);
        }

        public @Nullable net.kyori.adventure.text.Component getMessageComponent() {
            return this.message;
        }

        @Deprecated
        public static RedirectPlayer create(RegisteredServer server, Component message) {
            if (message == null) {
                return new RedirectPlayer(server, null);
            }
            return new RedirectPlayer(server, LegacyText3ComponentSerializer.get().deserialize(message));
        }

        public static RedirectPlayer create(RegisteredServer server, net.kyori.adventure.text.Component message) {
            return new RedirectPlayer(server, message);
        }

        public static ServerKickResult create(RegisteredServer server) {
            return new RedirectPlayer(server, null);
        }
    }

    public static final class DisconnectPlayer
    implements ServerKickResult {
        private final net.kyori.adventure.text.Component component;

        private DisconnectPlayer(net.kyori.adventure.text.Component component) {
            this.component = Preconditions.checkNotNull(component, "component");
        }

        @Override
        public boolean isAllowed() {
            return true;
        }

        @Deprecated
        public Component getReason() {
            return LegacyText3ComponentSerializer.get().serialize(this.component);
        }

        public net.kyori.adventure.text.Component getReasonComponent() {
            return this.component;
        }

        @Deprecated
        public static DisconnectPlayer create(Component reason) {
            return new DisconnectPlayer(LegacyText3ComponentSerializer.get().deserialize(reason));
        }

        public static DisconnectPlayer create(net.kyori.adventure.text.Component reason) {
            return new DisconnectPlayer(reason);
        }
    }

    public static interface ServerKickResult
    extends ResultedEvent.Result {
    }
}

