/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.player;

import com.velocitypowered.api.proxy.player.TabList;
import com.velocitypowered.api.util.GameProfile;
import java.util.Optional;
import net.kyori.adventure.text.serializer.legacytext3.LegacyText3ComponentSerializer;
import net.kyori.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface TabListEntry {
    public TabList getTabList();

    public GameProfile getProfile();

    @Deprecated
    public Optional<Component> getDisplayName();

    public Optional<net.kyori.adventure.text.Component> getDisplayNameComponent();

    @Deprecated
    public TabListEntry setDisplayName(Component var1);

    public TabListEntry setDisplayName(@Nullable net.kyori.adventure.text.Component var1);

    public int getLatency();

    public TabListEntry setLatency(int var1);

    public int getGameMode();

    public TabListEntry setGameMode(int var1);

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private @Nullable TabList tabList;
        private @Nullable GameProfile profile;
        private @Nullable net.kyori.adventure.text.Component displayName;
        private int latency = 0;
        private int gameMode = 0;

        private Builder() {
        }

        public Builder tabList(TabList tabList) {
            this.tabList = tabList;
            return this;
        }

        public Builder profile(GameProfile profile) {
            this.profile = profile;
            return this;
        }

        @Deprecated
        public Builder displayName(Component displayName) {
            return this.displayName(LegacyText3ComponentSerializer.get().deserialize(displayName));
        }

        public Builder displayName(@Nullable net.kyori.adventure.text.Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder latency(int latency) {
            this.latency = latency;
            return this;
        }

        public Builder gameMode(int gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public TabListEntry build() {
            if (this.tabList == null) {
                throw new IllegalStateException("The Tablist must be set when building a TabListEntry");
            }
            if (this.profile == null) {
                throw new IllegalStateException("The GameProfile must be set when building a TabListEntry");
            }
            return this.tabList.buildEntry(this.profile, this.displayName, this.latency, this.gameMode);
        }
    }
}

