/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.util.NettyPreconditions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;

public class MinecraftCompressDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final int VANILLA_MAXIMUM_UNCOMPRESSED_SIZE = 0x800000;
    private static final int HARD_MAXIMUM_UNCOMPRESSED_SIZE = 0x1000000;
    private static final int UNCOMPRESSED_CAP = Boolean.getBoolean("velocity.increased-compression-cap") ? 0x1000000 : 0x800000;
    private int threshold;
    private final VelocityCompressor compressor;

    public MinecraftCompressDecoder(int threshold, VelocityCompressor compressor) {
        this.threshold = threshold;
        this.compressor = compressor;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int claimedUncompressedSize = ProtocolUtils.readVarInt(in);
        if (claimedUncompressedSize == 0) {
            out.add(in.retainedSlice());
            return;
        }
        NettyPreconditions.checkFrame(claimedUncompressedSize >= this.threshold, "Uncompressed size %s is less than threshold %s", (Object)claimedUncompressedSize, (Object)this.threshold);
        NettyPreconditions.checkFrame(claimedUncompressedSize <= UNCOMPRESSED_CAP, "Uncompressed size %s exceeds hard threshold of %s", (Object)claimedUncompressedSize, (Object)UNCOMPRESSED_CAP);
        ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible(ctx.alloc(), this.compressor, in);
        ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer(ctx.alloc(), this.compressor, claimedUncompressedSize);
        try {
            this.compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
            out.add(uncompressed);
        }
        catch (Exception e) {
            uncompressed.release();
            throw e;
        }
        finally {
            compatibleIn.release();
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

