/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerLogin
implements MinecraftPacket {
    private static final QuietDecoderException EMPTY_USERNAME = new QuietDecoderException("Empty username!");
    private @Nullable String username;

    public ServerLogin() {
    }

    public ServerLogin(String username) {
        this.username = Preconditions.checkNotNull(username, "username");
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException("No username found!");
        }
        return this.username;
    }

    public String toString() {
        return "ServerLogin{username='" + this.username + '\'' + '}';
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.username = ProtocolUtils.readString(buf, 16);
        if (this.username.isEmpty()) {
            throw EMPTY_USERNAME;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.username == null) {
            throw new IllegalStateException("No username found!");
        }
        ProtocolUtils.writeString(buf, this.username);
    }

    @Override
    public int expectedMaxLength(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        return 65;
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

