/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.objectmapping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultObjectMapperFactory
implements ObjectMapperFactory {
    private static final ObjectMapperFactory INSTANCE = new DefaultObjectMapperFactory();
    private final LoadingCache<TypeToken<?>, ObjectMapper<?>> mapperCache = CacheBuilder.newBuilder().weakKeys().maximumSize(500L).build(new CacheLoader<TypeToken<?>, ObjectMapper<?>>(){

        @Override
        public ObjectMapper<?> load(TypeToken<?> key) throws Exception {
            return new ObjectMapper(key);
        }
    });

    public static @NonNull ObjectMapperFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull Class<T> type) throws ObjectMappingException {
        return this.getMapper(TypeToken.of(type));
    }

    @Override
    public <T> @NonNull ObjectMapper<T> getMapper(@NonNull TypeToken<T> type) throws ObjectMappingException {
        Objects.requireNonNull(type, "type");
        try {
            return this.mapperCache.get(type);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ObjectMappingException) {
                throw (ObjectMappingException)e.getCause();
            }
            throw new ObjectMappingException(e);
        }
    }

    public String toString() {
        return "DefaultObjectMapperFactory{}";
    }
}

