// Code generated by bpf2go; DO NOT EDIT.
//go:build arm64

package kfilefields

import (
	"bytes"
	_ "embed"
	"fmt"
	"io"

	"github.com/cilium/ebpf"
)

// loadFilefields returns the embedded CollectionSpec for filefields.
func loadFilefields() (*ebpf.CollectionSpec, error) {
	reader := bytes.NewReader(_FilefieldsBytes)
	spec, err := ebpf.LoadCollectionSpecFromReader(reader)
	if err != nil {
		return nil, fmt.Errorf("can't load filefields: %w", err)
	}

	return spec, err
}

// loadFilefieldsObjects loads filefields and converts it into a struct.
//
// The following types are suitable as obj argument:
//
//	*filefieldsObjects
//	*filefieldsPrograms
//	*filefieldsMaps
//
// See ebpf.CollectionSpec.LoadAndAssign documentation for details.
func loadFilefieldsObjects(obj interface{}, opts *ebpf.CollectionOptions) error {
	spec, err := loadFilefields()
	if err != nil {
		return err
	}

	return spec.LoadAndAssign(obj, opts)
}

// filefieldsSpecs contains maps and programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type filefieldsSpecs struct {
	filefieldsProgramSpecs
	filefieldsMapSpecs
	filefieldsVariableSpecs
}

// filefieldsProgramSpecs contains programs before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type filefieldsProgramSpecs struct {
	IgFgetX   *ebpf.ProgramSpec `ebpf:"ig_fget_x"`
	IgScmSndE *ebpf.ProgramSpec `ebpf:"ig_scm_snd_e"`
}

// filefieldsMapSpecs contains maps before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type filefieldsMapSpecs struct {
	IgFileFields *ebpf.MapSpec `ebpf:"ig_file_fields"`
}

// filefieldsVariableSpecs contains global variables before they are loaded into the kernel.
//
// It can be passed ebpf.CollectionSpec.Assign.
type filefieldsVariableSpecs struct {
	SocketIno     *ebpf.VariableSpec `ebpf:"socket_ino"`
	TracerPidTgid *ebpf.VariableSpec `ebpf:"tracer_pid_tgid"`
}

// filefieldsObjects contains all objects after they have been loaded into the kernel.
//
// It can be passed to loadFilefieldsObjects or ebpf.CollectionSpec.LoadAndAssign.
type filefieldsObjects struct {
	filefieldsPrograms
	filefieldsMaps
	filefieldsVariables
}

func (o *filefieldsObjects) Close() error {
	return _FilefieldsClose(
		&o.filefieldsPrograms,
		&o.filefieldsMaps,
	)
}

// filefieldsMaps contains all maps after they have been loaded into the kernel.
//
// It can be passed to loadFilefieldsObjects or ebpf.CollectionSpec.LoadAndAssign.
type filefieldsMaps struct {
	IgFileFields *ebpf.Map `ebpf:"ig_file_fields"`
}

func (m *filefieldsMaps) Close() error {
	return _FilefieldsClose(
		m.IgFileFields,
	)
}

// filefieldsVariables contains all global variables after they have been loaded into the kernel.
//
// It can be passed to loadFilefieldsObjects or ebpf.CollectionSpec.LoadAndAssign.
type filefieldsVariables struct {
	SocketIno     *ebpf.Variable `ebpf:"socket_ino"`
	TracerPidTgid *ebpf.Variable `ebpf:"tracer_pid_tgid"`
}

// filefieldsPrograms contains all programs after they have been loaded into the kernel.
//
// It can be passed to loadFilefieldsObjects or ebpf.CollectionSpec.LoadAndAssign.
type filefieldsPrograms struct {
	IgFgetX   *ebpf.Program `ebpf:"ig_fget_x"`
	IgScmSndE *ebpf.Program `ebpf:"ig_scm_snd_e"`
}

func (p *filefieldsPrograms) Close() error {
	return _FilefieldsClose(
		p.IgFgetX,
		p.IgScmSndE,
	)
}

func _FilefieldsClose(closers ...io.Closer) error {
	for _, closer := range closers {
		if err := closer.Close(); err != nil {
			return err
		}
	}
	return nil
}

// Do not access this directly.
//
//go:embed filefields_arm64_bpfel.o
var _FilefieldsBytes []byte
