SYD-OCI(1)

# NAME

*syd-oci* - OCI container runtime

# SYNOPSIS

*syd-oci* _[OPTIONS]_ _[COMMAND]_

# DESCRIPTION

syd-oci is an OCI container runtime implementation for _syd_(1).

All common subcommands are supported: create, start, state, kill,
delete, pause, resume, exec, run, list, ps, spec, events, features,
update. Checkpoint/restore support is planned in the near future. See
the respective youki issue,
https://github.com/youki-dev/youki/issues/142, for more information.

# INTEGRATION

syd-oci is a thin wrapper around _youki_(1) that integrates the _syd_(1)
sandbox into containers. It is compatible with _docker_(1) and
_podman_(1). To get syd-oci, you should build _syd_(1) with the *oci*
feature. To use syd-oci with _docker_(1) you have two options: Either
start _dockerd_(8) manually with the option
*--add-runtime=syd-oci=/bin/syd-oci*, and do for example
*docker run -it --runtime=syd-oci alpine* when starting containers,
or add the following snippet to your */etc/docker/daemon.json* file:

```
{
"runtimes": { "syd-oci": { "path": "/bin/syd-oci" } },
"default-runtime": "syd-oci"
}
```

You may need to adapt the path to syd-oci depending on your
installation.  To use with _podman_(1) is similar, just pass
*--runtime=/bin/syd-oci* as an option to *podman run*.

# CONFIGURATION

The configuration directory of syd-oci is one of the following:

- For system-wide containers: */etc/syd/oci*
- For rootless containers, one of the following:
    - *${XDG_CONFIG_HOME}/syd/oci* where XDG_CONFIG_HOME is usually *~/.config*.
    - *${HOME}/.syd/oci* if XDG_CONFIG_HOME is not set.

syd-oci attempts to configure the _syd_(1) sandbox in the following order,
and parses the first file or profile it locates and stops processing, the
environment variable *SYD_OCI_NO_CONFIG* may be set to skip to the final step:

- If hostname and domainname is defined for the container, try to load
  *${SYD_CONFIG_DIR}/${hostname}.${domainname}.syd-3*.
- If domainname is defined for the container, try to load
  *${SYD_CONFIG_DIR}/${domainname}.syd-3*.
- If hostname is defined for the container, try to load
  *${SYD_CONFIG_DIR}/${hostname}.syd-3*.
- Try to load *${SYD_CONFIG_DIR}/default.syd-3*
- Load the builtin *oci* profile.
  This profile is designed to be combined with _pandora_(1) and learning mode.
  See *syd-cat -p oci* for the list of rules.

SYD_CONFIG_DIR in the items above refer to the configuration directory.
Refer to _syd_(5) for the syntax of _syd_(1) configuration files and
_syd_(2) for a list of configuration items _syd_(1) understands. A
_vim_(1) syntax highlighting file is also provided to easily edit
_syd_(1) configuration files. Use *syd-cat file.syd-3* to check a
_syd_(1) configuration file for syntax errors.

Finally, note that the *include* directives in the configuration files
are searched within the container image. This allows you to provide
additional image-based sandbox configuration. One possible use could be
to store cryptographic checksums of all executables and their dependent
dynamic libraries in an include file in the image and then use this with
Force Sandboxing for binary verification, see _syd_(7) for more
information on Force Sandboxing.

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _syd_(7), _pandora_(1), _docker_(1),
_dockerd_(8), _podman_(1), _youki_(1)

- *syd* homepage: https://sydbox.exherbo.org/
- *youki* homepage: https://containers.github.io/youki/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
