/*
 * Endpoint - Linux SBP2 Disk Target
 *
 * Copyright (C) 2003 Oracle.  All rights reserved.
 *
 * Author: Manish Singh <manish.singh@oracle.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have recieved a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 021110-1307, USA.
 */

#ifndef __UTIL_H__
#define __UTIL_H__


#include <glib.h>


GIOChannel *util_io_channel_new (gint          fd);

guint       util_run_first_add  (GMainContext *context,
				 GSourceFunc   function,
				 gpointer      data);
guint       util_timeout_add    (GMainContext *context,
				 guint         interval,
				 GSourceFunc   function,
				 gpointer      data);
guint       util_io_add_watch   (GMainContext *context,
				 GIOChannel   *channel,
				 GIOCondition  condition,
				 GIOFunc       function,
				 gpointer      data);

gboolean    util_source_remove  (GMainContext *context,
                                 guint         tag);


#endif /* __UTIL_H__ */
