#!/bin/bash -
# libguestfs
# Copyright (C) 2016-2025 Red Hat Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

source ../tests/functions.sh
set -e
set -x

skip_if_skipped
skip_unless_phony_guest windows.img

rm -f actual-windows.xml actual-windows.xml.bak

$VG virt-drivers --format=raw -a ../test-data/phony-guests/windows.img > actual-windows.xml

# We can't predict if hwdata is available, so we don't know if
# vendorname and devicename fields will be present.  If present,
# remove them before comparison.
mv actual-windows.xml actual-windows.xml.bak
sed -e "s/ vendorname='\([^']*\)'//g" \
    -e "s/ devicename='\([^']*\)'//g" \
    < actual-windows.xml.bak > actual-windows.xml

diff -ur -I "generated by" expected-windows.xml actual-windows.xml

rm actual-windows.xml actual-windows.xml.bak
