/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.context.FileOptions;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.files.AbstractExtractZipFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InstallExternalZipFileAction
extends AbstractExtractZipFileAction {
    private OverwriteMode overwriteMode = OverwriteMode.ALWAYS_ASK_EXCEPT_FOR_UPDATE;
    private boolean shared = false;
    private UninstallMode uninstallMode = UninstallMode.IF_CREATED;
    private boolean delay = false;
    private boolean triggerReboot = true;
    private transient FileInstaller fileInstaller;

    public boolean isDelay() {
        return this.delay;
    }

    public void setDelay(boolean bl) {
        this.delay = bl;
    }

    public boolean isTriggerReboot() {
        return this.triggerReboot;
    }

    public void setTriggerReboot(boolean bl) {
        this.triggerReboot = bl;
    }

    public OverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    public void setOverwriteMode(OverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isShared() {
        return this.shared;
    }

    public void setShared(boolean bl) {
        this.shared = bl;
    }

    public UninstallMode getUninstallMode() {
        return this.uninstallMode;
    }

    public void setUninstallMode(UninstallMode uninstallMode) {
        this.uninstallMode = uninstallMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(InstallerContext installerContext) throws UserCanceledException {
        this.fileInstaller = FileInstaller.getInstance();
        this.fileInstaller.resetCurrentRebootRequired();
        try {
            boolean bl = super.install(installerContext);
            return bl;
        }
        finally {
            if (this.isTriggerReboot() && this.isDelay() && this.fileInstaller.isCurrentRebootRequired()) {
                installerContext.triggerReboot(true);
            }
        }
    }

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        Logger.getInstance().error(this, "This action does not work in an uninstaller");
        return false;
    }

    protected void createFile(File file, ZipInputStream zipInputStream, ZipEntry zipEntry, long l, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        FileOptions fileOptions = new FileOptions(zipEntry.getTime(), this.getMode(), this.getOverwriteMode(), this.isShared(), this.isDelay(), this.getUninstallMode());
        this.fileInstaller.install(zipInputStream, file, fileOptions, progressAdapter, l, false);
    }

    protected void createDirectory(File file) throws IOException {
        this.fileInstaller.createDirectory(file, this.getUninstallMode());
    }
}

