/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.misc.AbstractPrivilegesAction;
import com.install4j.runtime.installer.InstallerVariables;

public class RequireInstallerPrivilegesAction
extends AbstractPrivilegesAction {
    private boolean failIfNotObtained = true;

    public boolean isFailIfNotObtained() {
        return this.failIfNotObtained;
    }

    public void setFailIfNotObtained(boolean bl) {
        this.failIfNotObtained = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        boolean bl = Boolean.TRUE.equals(InstallerVariables.getVariable("sys.adminRights"));
        if (!(!bl || Util.isAdminGroup() && Util.hasFullAdminRights())) {
            if (Util.isWindows()) {
                return this.handleFailure(this.startOnWindows(context), context);
            }
            if (Util.isMacOS()) {
                return this.handleFailure(this.startOnMac(context), context);
            }
            return this.handleFailure(false, context);
        }
        return true;
    }

    private boolean handleFailure(boolean bl, Context context) throws UserCanceledException {
        if (!bl && this.failIfNotObtained) {
            this.showFailureMessage(context);
        }
        return bl;
    }
}

