/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.controller;

import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ControllerCommand;

public class CommandSink {
    private ControllerCommand command;
    private ControllerCommand overrideCommand;
    private boolean allowOverride = false;
    private boolean finished = false;
    private Thread controllerThread;
    private Controller controller;

    public CommandSink(Controller controller) {
        this.controller = controller;
        this.controllerThread = Thread.currentThread();
    }

    public ControllerCommand getCommand() {
        return this.command;
    }

    public synchronized void returnToController(ControllerCommand controllerCommand) {
        if (controllerCommand == null) {
            throw new IllegalArgumentException();
        }
        if (this.command == null) {
            this.command = controllerCommand;
            if (!this.controllerThread.isAlive() && controllerCommand == ControllerCommand.CANCEL) {
                this.controller.rollback(this);
            } else {
                this.notifyAll();
            }
        } else if (this.allowOverride) {
            this.overrideCommand = controllerCommand;
        }
    }

    public synchronized void finished() {
        this.finished = true;
        this.notifyAll();
    }

    public synchronized void waitForFinish() {
        while (!this.finished && this.controllerThread.isAlive()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public ControllerCommand getOverriddenCommand() {
        return this.overrideCommand != null ? this.overrideCommand : this.command;
    }

    public synchronized void allowOverride() {
        this.allowOverride = true;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

