//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatortypeid?language=objc)
pub type CFAllocatorTypeID = c_ulonglong;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfcorefoundationversionnumber?language=objc)
    pub static kCFCoreFoundationVersionNumber: c_double;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfstring?language=objc)
#[repr(C)]
pub struct CFString {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFString"]
    unsafe impl CFString {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfmutablestring?language=objc)
#[repr(C)]
pub struct CFMutableString {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFString"]
    unsafe impl CFMutableString: CFString {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfpropertylist?language=objc)
pub type CFPropertyList = CFType;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcomparisonresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFComparisonResult(pub CFIndex);
impl CFComparisonResult {
    #[doc(alias = "kCFCompareLessThan")]
    pub const CompareLessThan: Self = Self(-1);
    #[doc(alias = "kCFCompareEqualTo")]
    pub const CompareEqualTo: Self = Self(0);
    #[doc(alias = "kCFCompareGreaterThan")]
    pub const CompareGreaterThan: Self = Self(1);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFComparisonResult {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFComparisonResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcomparatorfunction?language=objc)
pub type CFComparatorFunction = Option<
    unsafe extern "C-unwind" fn(*const c_void, *const c_void, *mut c_void) -> CFComparisonResult,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnotfound?language=objc)
pub static kCFNotFound: CFIndex = -1;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfrange?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFRange {
    pub location: CFIndex,
    pub length: CFIndex,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFRange {
    const ENCODING: Encoding = Encoding::Struct("?", &[<CFIndex>::ENCODING, <CFIndex>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFRange {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// TODO: pub fn CFRangeMake(loc: CFIndex,len: CFIndex,) -> CFRange;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfnull?language=objc)
#[repr(C)]
pub struct CFNull {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFNull"]
    unsafe impl CFNull {}
);

unsafe impl ConcreteType for CFNull {
    #[doc(alias = "CFNullGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFNullGetTypeID() -> CFTypeID;
        }
        unsafe { CFNullGetTypeID() }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfnull?language=objc)
    pub static kCFNull: Option<&'static CFNull>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocator?language=objc)
#[repr(C)]
pub struct CFAllocator {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFAllocator"]
    unsafe impl CFAllocator {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatordefault?language=objc)
    pub static kCFAllocatorDefault: Option<&'static CFAllocator>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatorsystemdefault?language=objc)
    pub static kCFAllocatorSystemDefault: Option<&'static CFAllocator>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatormalloc?language=objc)
    pub static kCFAllocatorMalloc: Option<&'static CFAllocator>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatormalloczone?language=objc)
    pub static kCFAllocatorMallocZone: Option<&'static CFAllocator>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatornull?language=objc)
    pub static kCFAllocatorNull: Option<&'static CFAllocator>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfallocatorusecontext?language=objc)
    pub static kCFAllocatorUseContext: Option<&'static CFAllocator>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorretaincallback?language=objc)
pub type CFAllocatorRetainCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const c_void>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorreleasecallback?language=objc)
pub type CFAllocatorReleaseCallBack = Option<unsafe extern "C-unwind" fn(*const c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorcopydescriptioncallback?language=objc)
pub type CFAllocatorCopyDescriptionCallBack =
    Option<unsafe extern "C-unwind" fn(*const c_void) -> *const CFString>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorallocatecallback?language=objc)
pub type CFAllocatorAllocateCallBack =
    Option<unsafe extern "C-unwind" fn(CFIndex, CFOptionFlags, *mut c_void) -> *mut c_void>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorreallocatecallback?language=objc)
pub type CFAllocatorReallocateCallBack = Option<
    unsafe extern "C-unwind" fn(*mut c_void, CFIndex, CFOptionFlags, *mut c_void) -> *mut c_void,
>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatordeallocatecallback?language=objc)
pub type CFAllocatorDeallocateCallBack =
    Option<unsafe extern "C-unwind" fn(*mut c_void, *mut c_void)>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorpreferredsizecallback?language=objc)
pub type CFAllocatorPreferredSizeCallBack =
    Option<unsafe extern "C-unwind" fn(CFIndex, CFOptionFlags, *mut c_void) -> CFIndex>;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfallocatorcontext?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CFAllocatorContext {
    pub version: CFIndex,
    pub info: *mut c_void,
    pub retain: CFAllocatorRetainCallBack,
    pub release: CFAllocatorReleaseCallBack,
    pub copyDescription: CFAllocatorCopyDescriptionCallBack,
    pub allocate: CFAllocatorAllocateCallBack,
    pub reallocate: CFAllocatorReallocateCallBack,
    pub deallocate: CFAllocatorDeallocateCallBack,
    pub preferredSize: CFAllocatorPreferredSizeCallBack,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFAllocatorContext {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <CFIndex>::ENCODING,
            <*mut c_void>::ENCODING,
            <CFAllocatorRetainCallBack>::ENCODING,
            <CFAllocatorReleaseCallBack>::ENCODING,
            <CFAllocatorCopyDescriptionCallBack>::ENCODING,
            <CFAllocatorAllocateCallBack>::ENCODING,
            <CFAllocatorReallocateCallBack>::ENCODING,
            <CFAllocatorDeallocateCallBack>::ENCODING,
            <CFAllocatorPreferredSizeCallBack>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFAllocatorContext {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl ConcreteType for CFAllocator {
    #[doc(alias = "CFAllocatorGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFAllocatorGetTypeID() -> CFTypeID;
        }
        unsafe { CFAllocatorGetTypeID() }
    }
}

extern "C-unwind" {
    pub fn CFAllocatorSetDefault(allocator: Option<&CFAllocator>);
}

#[inline]
pub unsafe extern "C-unwind" fn CFAllocatorGetDefault() -> Option<CFRetained<CFAllocator>> {
    extern "C-unwind" {
        fn CFAllocatorGetDefault() -> Option<NonNull<CFAllocator>>;
    }
    let ret = unsafe { CFAllocatorGetDefault() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFAllocatorCreate(
    allocator: Option<&CFAllocator>,
    context: *mut CFAllocatorContext,
) -> Option<CFRetained<CFAllocator>> {
    extern "C-unwind" {
        fn CFAllocatorCreate(
            allocator: Option<&CFAllocator>,
            context: *mut CFAllocatorContext,
        ) -> Option<NonNull<CFAllocator>>;
    }
    let ret = unsafe { CFAllocatorCreate(allocator, context) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CFAllocatorAllocateTyped(
        allocator: Option<&CFAllocator>,
        size: CFIndex,
        descriptor: CFAllocatorTypeID,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorReallocateTyped(
        allocator: Option<&CFAllocator>,
        ptr: *mut c_void,
        newsize: CFIndex,
        descriptor: CFAllocatorTypeID,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorAllocateBytes(
        allocator: Option<&CFAllocator>,
        size: CFIndex,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorReallocateBytes(
        allocator: Option<&CFAllocator>,
        ptr: *mut c_void,
        newsize: CFIndex,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorAllocate(
        allocator: Option<&CFAllocator>,
        size: CFIndex,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorReallocate(
        allocator: Option<&CFAllocator>,
        ptr: *mut c_void,
        newsize: CFIndex,
        hint: CFOptionFlags,
    ) -> *mut c_void;
}

extern "C-unwind" {
    pub fn CFAllocatorDeallocate(allocator: Option<&CFAllocator>, ptr: *mut c_void);
}

extern "C-unwind" {
    pub fn CFAllocatorGetPreferredSizeForSize(
        allocator: Option<&CFAllocator>,
        size: CFIndex,
        hint: CFOptionFlags,
    ) -> CFIndex;
}

extern "C-unwind" {
    pub fn CFAllocatorGetContext(allocator: Option<&CFAllocator>, context: *mut CFAllocatorContext);
}

#[inline]
pub extern "C-unwind" fn CFGetTypeID(cf: Option<&CFType>) -> CFTypeID {
    extern "C-unwind" {
        fn CFGetTypeID(cf: Option<&CFType>) -> CFTypeID;
    }
    unsafe { CFGetTypeID(cf) }
}

#[inline]
pub extern "C-unwind" fn CFCopyTypeIDDescription(
    type_id: CFTypeID,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFCopyTypeIDDescription(type_id: CFTypeID) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFCopyTypeIDDescription(type_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub extern "C-unwind" fn CFGetRetainCount(cf: Option<&CFType>) -> CFIndex {
    extern "C-unwind" {
        fn CFGetRetainCount(cf: Option<&CFType>) -> CFIndex;
    }
    unsafe { CFGetRetainCount(cf) }
}

#[inline]
pub extern "C-unwind" fn CFEqual(cf1: Option<&CFType>, cf2: Option<&CFType>) -> bool {
    extern "C-unwind" {
        fn CFEqual(cf1: Option<&CFType>, cf2: Option<&CFType>) -> Boolean;
    }
    let ret = unsafe { CFEqual(cf1, cf2) };
    ret != 0
}

#[inline]
pub extern "C-unwind" fn CFHash(cf: Option<&CFType>) -> CFHashCode {
    extern "C-unwind" {
        fn CFHash(cf: Option<&CFType>) -> CFHashCode;
    }
    unsafe { CFHash(cf) }
}

#[inline]
pub extern "C-unwind" fn CFCopyDescription(cf: Option<&CFType>) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFCopyDescription(cf: Option<&CFType>) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFCopyDescription(cf) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFGetAllocator(
    cf: Option<&CFType>,
) -> Option<CFRetained<CFAllocator>> {
    extern "C-unwind" {
        fn CFGetAllocator(cf: Option<&CFType>) -> Option<NonNull<CFAllocator>>;
    }
    let ret = unsafe { CFGetAllocator(cf) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}
