/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;

public class ArchiveEntriesValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        ArchiveEntriesValidator.checkModuleEntryNames(modules);
    }

    private static void checkModuleEntryNames(ImmutableList<BundleModule> modules) {
        if (BundleValidationUtils.isAssetOnlyBundle(modules)) {
            return;
        }
        BundleModule baseModule = BundleValidationUtils.expectBaseModule(modules);
        ImmutableSet<String> reservedResourcePaths = ImmutableSet.of(BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", "com_android_vending_archive_icon_opacity_layer")).toString(), BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", "com_android_vending_archive_icon_cloud_symbol")).toString(), BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", "com_android_vending_archive_application_icon")).toString(), BundleModule.DRAWABLE_RESOURCE_DIRECTORY.resolve(String.format("%s.xml", "com_android_vending_archive_application_round_icon")).toString(), BundleModule.RESOURCES_DIRECTORY.resolve(String.format("layout/%s.xml", "com_android_vending_archive_splash_screen_layout")).toString());
        ImmutableList nameConflictingEntries = baseModule.getEntries().stream().filter(entry -> reservedResourcePaths.contains(entry.getPath().toString())).map(entry -> "'" + entry.getPath() + "'").collect(ImmutableList.toImmutableList());
        if (!nameConflictingEntries.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Following entry(s) name(s) in base module are reserved and must be changed: " + Joiner.on(",").join(nameConflictingEntries)).build();
        }
    }
}

