/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.sort;

import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

class ModuleInSort {
    private final ModuleDescriptor module;
    private boolean isSorted = false;
    private List loopElements = new LinkedList();
    private boolean isLoopIntermediateElement = false;
    private ModuleInSort caller;

    public ModuleInSort(ModuleDescriptor moduleDescriptor) {
        this.module = moduleDescriptor;
    }

    public boolean isSorted() {
        if (this.isSorted) {
            Message.debug("Module descriptor already sorted : " + this.module.getModuleRevisionId().toString());
            return true;
        }
        return false;
    }

    public boolean isProcessed() {
        if (this.isSorted || this.isLoopIntermediateElement) {
            Message.debug("Module descriptor is processed : " + this.module.getModuleRevisionId().toString());
            return true;
        }
        return false;
    }

    public void setCaller(ModuleInSort moduleInSort) {
        this.caller = moduleInSort;
    }

    public void endOfCall() {
        this.caller = null;
    }

    public boolean checkLoop(ModuleInSort object, CircularDependencyStrategy circularDependencyStrategy) {
        if (this.caller != null) {
            LinkedList<ModuleRevisionId> linkedList = new LinkedList<ModuleRevisionId>();
            linkedList.add(this.module.getModuleRevisionId());
            while (object != this) {
                linkedList.add(object.module.getModuleRevisionId());
                object.isLoopIntermediateElement = true;
                this.loopElements.add(object);
                object = object.caller;
            }
            linkedList.add(this.module.getModuleRevisionId());
            LinkedList<ModuleRevisionId> linkedList2 = linkedList;
            object = linkedList2.toArray(new ModuleRevisionId[linkedList2.size()]);
            circularDependencyStrategy.handleCircularDependency((ModuleRevisionId[])object);
            return true;
        }
        return false;
    }

    public void addToSortedListIfRequired(List list) {
        if (!this.isLoopIntermediateElement) {
            this.addToSortList(list);
        }
    }

    private void addToSortList(List list) {
        for (ModuleInSort moduleInSort : this.loopElements) {
            moduleInSort.addToSortList(list);
        }
        if (!this.isSorted()) {
            list.add(this.module);
            this.isSorted = true;
        }
    }

    public String toString() {
        return this.module.getModuleRevisionId().toString();
    }

    public DependencyDescriptor[] getDependencies() {
        return this.module.getDependencies();
    }

    public boolean match(DependencyDescriptor dependencyDescriptor, VersionMatcher versionMatcher) {
        ModuleDescriptor moduleDescriptor = this.module;
        return moduleDescriptor.getResolvedModuleRevisionId().getRevision() == null || moduleDescriptor.getResolvedModuleRevisionId().getRevision().equals(Ivy.getWorkingRevision()) || versionMatcher.accept(dependencyDescriptor.getDependencyRevisionId(), moduleDescriptor);
    }

    public ModuleDescriptor getSortedModuleDescriptor() {
        return this.module;
    }
}

