/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2018  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**
 * Allow the app run properly without installation.
 * Allow the app to be relocated without recompiling.
 */
namespace Pasang {
    namespace Reloc {
        public string exe_name;
        public string data_dir;
        public string locale_dir;
        public string icons_dir;
        public string flash_dir;
        public string theme_root_dir;

        /**
         * Set *_dir variables relative to the location of "self".
         */
        public void init (string arg0) {
            exe_name = File.new_for_commandline_arg (arg0) .get_basename ();
            var prefix = find_self () .get_parent () .get_parent () .get_path ();
            data_dir = prefix + "/share";
            locale_dir = data_dir + "/locale";
            icons_dir = data_dir + "/icons";
            flash_dir = data_dir + "/" + Config.PACKAGE_TARNAME;
            theme_root_dir = data_dir + "/" + Config.PACKAGE_TARNAME + "/themes";
            set_xdg_data_dirs ();
            //stdout.printf ("prefix: %s\nlocale: %s\nicon:   %s\ntheme:  %s\n",
            //    prefix, locale_dir, icons_dir, theme_root_dir);
        }

        /**
         * Locate the actual executable file used to launch pasang emas.
         * Start from the symlink "/proc/self/exe" and follow the links
         * until the actual executable is found.
         *
         * Note: using argv[0] doesn't work inside an AppImage.
         */
        private File find_self () {
            var self_path = File.new_for_path ("/proc/self/exe") .get_path ();
            while (FileUtils.test (self_path, FileTest.IS_SYMLINK)) {
                try {
                    self_path = FileUtils.read_link (self_path);
                }
                catch (FileError e) {
                    stderr.printf ("Link error: %s\n", e.message);
                    break;
                }
            }
            return File.new_for_path (self_path);
        }

        /**
         * Set XDG_DATA_DIRS so that help files can be located by the system
         */
        private void set_xdg_data_dirs () {
            // If app is already installed in a recognized location, we are done.
            var data_home = Environment.get_home_dir () + "/.local/share";
            if (data_dir == "/usr/share" || data_dir == "/usr/local/share" || data_dir == data_home) {
                return;
            }
            // Otherwise, append data_dir to $XDG_DATA_DIRS
            var xdg_data_dirs = Environment.get_variable ("XDG_DATA_DIRS");
            if (xdg_data_dirs == null || xdg_data_dirs == "") {
                Environment.set_variable ("XDG_DATA_DIRS", data_dir + ":/usr/local/share/:/usr/share/", true);
            }
            else {
                Environment.set_variable ("XDG_DATA_DIRS", data_dir + ":" + xdg_data_dirs, true);
            }
            //stdout.printf ("---------%s\n", Environment.get_variable ("XDG_DATA_DIRS"));
        }
    }
}//namespace

// vim: tabstop=4: expandtab: textwidth=100: autoindent:
