// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package crt_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// EditCrtStoreOKCode is the HTTP code returned for type EditCrtStoreOK
const EditCrtStoreOKCode int = 200

/*
EditCrtStoreOK crt_store configuration updated

swagger:response editCrtStoreOK
*/
type EditCrtStoreOK struct {

	/*
	  In: Body
	*/
	Payload *models.CrtStore `json:"body,omitempty"`
}

// NewEditCrtStoreOK creates EditCrtStoreOK with default headers values
func NewEditCrtStoreOK() *EditCrtStoreOK {

	return &EditCrtStoreOK{}
}

// WithPayload adds the payload to the edit crt store o k response
func (o *EditCrtStoreOK) WithPayload(payload *models.CrtStore) *EditCrtStoreOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit crt store o k response
func (o *EditCrtStoreOK) SetPayload(payload *models.CrtStore) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditCrtStoreOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// EditCrtStoreAcceptedCode is the HTTP code returned for type EditCrtStoreAccepted
const EditCrtStoreAcceptedCode int = 202

/*
EditCrtStoreAccepted Configuration change accepted and reload requested

swagger:response editCrtStoreAccepted
*/
type EditCrtStoreAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.CrtStore `json:"body,omitempty"`
}

// NewEditCrtStoreAccepted creates EditCrtStoreAccepted with default headers values
func NewEditCrtStoreAccepted() *EditCrtStoreAccepted {

	return &EditCrtStoreAccepted{}
}

// WithReloadID adds the reloadId to the edit crt store accepted response
func (o *EditCrtStoreAccepted) WithReloadID(reloadID string) *EditCrtStoreAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the edit crt store accepted response
func (o *EditCrtStoreAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the edit crt store accepted response
func (o *EditCrtStoreAccepted) WithPayload(payload *models.CrtStore) *EditCrtStoreAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit crt store accepted response
func (o *EditCrtStoreAccepted) SetPayload(payload *models.CrtStore) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditCrtStoreAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// EditCrtStoreBadRequestCode is the HTTP code returned for type EditCrtStoreBadRequest
const EditCrtStoreBadRequestCode int = 400

/*
EditCrtStoreBadRequest Bad request

swagger:response editCrtStoreBadRequest
*/
type EditCrtStoreBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewEditCrtStoreBadRequest creates EditCrtStoreBadRequest with default headers values
func NewEditCrtStoreBadRequest() *EditCrtStoreBadRequest {

	return &EditCrtStoreBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the edit crt store bad request response
func (o *EditCrtStoreBadRequest) WithConfigurationVersion(configurationVersion string) *EditCrtStoreBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the edit crt store bad request response
func (o *EditCrtStoreBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the edit crt store bad request response
func (o *EditCrtStoreBadRequest) WithPayload(payload *models.Error) *EditCrtStoreBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit crt store bad request response
func (o *EditCrtStoreBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditCrtStoreBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// EditCrtStoreNotFoundCode is the HTTP code returned for type EditCrtStoreNotFound
const EditCrtStoreNotFoundCode int = 404

/*
EditCrtStoreNotFound The specified resource was not found

swagger:response editCrtStoreNotFound
*/
type EditCrtStoreNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewEditCrtStoreNotFound creates EditCrtStoreNotFound with default headers values
func NewEditCrtStoreNotFound() *EditCrtStoreNotFound {

	return &EditCrtStoreNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the edit crt store not found response
func (o *EditCrtStoreNotFound) WithConfigurationVersion(configurationVersion string) *EditCrtStoreNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the edit crt store not found response
func (o *EditCrtStoreNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the edit crt store not found response
func (o *EditCrtStoreNotFound) WithPayload(payload *models.Error) *EditCrtStoreNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit crt store not found response
func (o *EditCrtStoreNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditCrtStoreNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
EditCrtStoreDefault General Error

swagger:response editCrtStoreDefault
*/
type EditCrtStoreDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewEditCrtStoreDefault creates EditCrtStoreDefault with default headers values
func NewEditCrtStoreDefault(code int) *EditCrtStoreDefault {
	if code <= 0 {
		code = 500
	}

	return &EditCrtStoreDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the edit crt store default response
func (o *EditCrtStoreDefault) WithStatusCode(code int) *EditCrtStoreDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the edit crt store default response
func (o *EditCrtStoreDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the edit crt store default response
func (o *EditCrtStoreDefault) WithConfigurationVersion(configurationVersion string) *EditCrtStoreDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the edit crt store default response
func (o *EditCrtStoreDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the edit crt store default response
func (o *EditCrtStoreDefault) WithPayload(payload *models.Error) *EditCrtStoreDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the edit crt store default response
func (o *EditCrtStoreDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *EditCrtStoreDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
