// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package quic_initial_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetQUICInitialRuleDefaultsOKCode is the HTTP code returned for type GetQUICInitialRuleDefaultsOK
const GetQUICInitialRuleDefaultsOKCode int = 200

/*
GetQUICInitialRuleDefaultsOK Successful operation

swagger:response getQuicInitialRuleDefaultsOK
*/
type GetQUICInitialRuleDefaultsOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.QUICInitialRule `json:"body,omitempty"`
}

// NewGetQUICInitialRuleDefaultsOK creates GetQUICInitialRuleDefaultsOK with default headers values
func NewGetQUICInitialRuleDefaultsOK() *GetQUICInitialRuleDefaultsOK {

	return &GetQUICInitialRuleDefaultsOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Quic initial rule defaults o k response
func (o *GetQUICInitialRuleDefaultsOK) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleDefaultsOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Quic initial rule defaults o k response
func (o *GetQUICInitialRuleDefaultsOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Quic initial rule defaults o k response
func (o *GetQUICInitialRuleDefaultsOK) WithPayload(payload *models.QUICInitialRule) *GetQUICInitialRuleDefaultsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Quic initial rule defaults o k response
func (o *GetQUICInitialRuleDefaultsOK) SetPayload(payload *models.QUICInitialRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleDefaultsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetQUICInitialRuleDefaultsNotFoundCode is the HTTP code returned for type GetQUICInitialRuleDefaultsNotFound
const GetQUICInitialRuleDefaultsNotFoundCode int = 404

/*
GetQUICInitialRuleDefaultsNotFound The specified resource was not found

swagger:response getQuicInitialRuleDefaultsNotFound
*/
type GetQUICInitialRuleDefaultsNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetQUICInitialRuleDefaultsNotFound creates GetQUICInitialRuleDefaultsNotFound with default headers values
func NewGetQUICInitialRuleDefaultsNotFound() *GetQUICInitialRuleDefaultsNotFound {

	return &GetQUICInitialRuleDefaultsNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Quic initial rule defaults not found response
func (o *GetQUICInitialRuleDefaultsNotFound) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleDefaultsNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Quic initial rule defaults not found response
func (o *GetQUICInitialRuleDefaultsNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Quic initial rule defaults not found response
func (o *GetQUICInitialRuleDefaultsNotFound) WithPayload(payload *models.Error) *GetQUICInitialRuleDefaultsNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Quic initial rule defaults not found response
func (o *GetQUICInitialRuleDefaultsNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleDefaultsNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetQUICInitialRuleDefaultsDefault General Error

swagger:response getQuicInitialRuleDefaultsDefault
*/
type GetQUICInitialRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetQUICInitialRuleDefaultsDefault creates GetQUICInitialRuleDefaultsDefault with default headers values
func NewGetQUICInitialRuleDefaultsDefault(code int) *GetQUICInitialRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &GetQUICInitialRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) WithStatusCode(code int) *GetQUICInitialRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *GetQUICInitialRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) WithPayload(payload *models.Error) *GetQUICInitialRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get QUIC initial rule defaults default response
func (o *GetQUICInitialRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetQUICInitialRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
