package siterecovery

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ReplicationProtectedItemsClient is the client for the ReplicationProtectedItems methods of the Siterecovery service.
type ReplicationProtectedItemsClient struct {
	BaseClient
}

// NewReplicationProtectedItemsClient creates an instance of the ReplicationProtectedItemsClient client.
func NewReplicationProtectedItemsClient(subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return NewReplicationProtectedItemsClientWithBaseURI(DefaultBaseURI, subscriptionID, resourceGroupName, resourceName)
}

// NewReplicationProtectedItemsClientWithBaseURI creates an instance of the ReplicationProtectedItemsClient client.
func NewReplicationProtectedItemsClientWithBaseURI(baseURI string, subscriptionID string, resourceGroupName string, resourceName string) ReplicationProtectedItemsClient {
	return ReplicationProtectedItemsClient{NewWithBaseURI(baseURI, subscriptionID, resourceGroupName, resourceName)}
}

// ApplyRecoveryPoint the operation to change the recovery point of a failed over replication protected item.
// Parameters:
// fabricName - the ARM fabric name.
// protectionContainerName - the protection container name.
// replicatedProtectedItemName - the replicated protected item's name.
// applyRecoveryPointInput - the ApplyRecoveryPointInput.
func (client ReplicationProtectedItemsClient) ApplyRecoveryPoint(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, applyRecoveryPointInput ApplyRecoveryPointInput) (result ReplicationProtectedItemsApplyRecoveryPointFuture, err error) {
	req, err := client.ApplyRecoveryPointPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, applyRecoveryPointInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "ApplyRecoveryPoint", nil, "Failure preparing request")
		return
	}

	result, err = client.ApplyRecoveryPointSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "ApplyRecoveryPoint", result.Response(), "Failure sending request")
		return
	}

	return
}

// ApplyRecoveryPointPreparer prepares the ApplyRecoveryPoint request.
func (client ReplicationProtectedItemsClient) ApplyRecoveryPointPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, applyRecoveryPointInput ApplyRecoveryPointInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/applyRecoveryPoint", pathParameters),
		autorest.WithJSON(applyRecoveryPointInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ApplyRecoveryPointSender sends the ApplyRecoveryPoint request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) ApplyRecoveryPointSender(req *http.Request) (future ReplicationProtectedItemsApplyRecoveryPointFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ApplyRecoveryPointResponder handles the response to the ApplyRecoveryPoint request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) ApplyRecoveryPointResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Create the operation to create an ASR replication protected item (Enable replication).
// Parameters:
// fabricName - name of the fabric.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - a name for the replication protected item.
// input - enable Protection Input.
func (client ReplicationProtectedItemsClient) Create(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, input EnableProtectionInput) (result ReplicationProtectedItemsCreateFuture, err error) {
	req, err := client.CreatePreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, input)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client ReplicationProtectedItemsClient) CreatePreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, input EnableProtectionInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", pathParameters),
		autorest.WithJSON(input),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) CreateSender(req *http.Request) (future ReplicationProtectedItemsCreateFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) CreateResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete the operation to disable replication on a replication protected item. This will also remove the item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// disableProtectionInput - disable protection input.
func (client ReplicationProtectedItemsClient) Delete(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, disableProtectionInput DisableProtectionInput) (result ReplicationProtectedItemsDeleteFuture, err error) {
	req, err := client.DeletePreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, disableProtectionInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ReplicationProtectedItemsClient) DeletePreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, disableProtectionInput DisableProtectionInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/remove", pathParameters),
		autorest.WithJSON(disableProtectionInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) DeleteSender(req *http.Request) (future ReplicationProtectedItemsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// FailoverCommit operation to commit the failover of the replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
func (client ReplicationProtectedItemsClient) FailoverCommit(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (result ReplicationProtectedItemsFailoverCommitFuture, err error) {
	req, err := client.FailoverCommitPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "FailoverCommit", nil, "Failure preparing request")
		return
	}

	result, err = client.FailoverCommitSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "FailoverCommit", result.Response(), "Failure sending request")
		return
	}

	return
}

// FailoverCommitPreparer prepares the FailoverCommit request.
func (client ReplicationProtectedItemsClient) FailoverCommitPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/failoverCommit", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// FailoverCommitSender sends the FailoverCommit request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) FailoverCommitSender(req *http.Request) (future ReplicationProtectedItemsFailoverCommitFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// FailoverCommitResponder handles the response to the FailoverCommit request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) FailoverCommitResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets the details of an ASR replication protected item.
// Parameters:
// fabricName - fabric unique name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
func (client ReplicationProtectedItemsClient) Get(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (result ReplicationProtectedItem, err error) {
	req, err := client.GetPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReplicationProtectedItemsClient) GetPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) GetResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the list of ASR replication protected items in the vault.
// Parameters:
// skipToken - the pagination token. Possible values: "FabricId" or "FabricId_CloudId" or null
// filter - oData filter options.
func (client ReplicationProtectedItemsClient) List(ctx context.Context, skipToken string, filter string) (result ReplicationProtectedItemCollectionPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, skipToken, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.rpic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "List", resp, "Failure sending request")
		return
	}

	result.rpic, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ReplicationProtectedItemsClient) ListPreparer(ctx context.Context, skipToken string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", client.ResourceGroupName),
		"resourceName":      autorest.Encode("path", client.ResourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["skipToken"] = autorest.Encode("query", skipToken)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationProtectedItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) ListResponder(resp *http.Response) (result ReplicationProtectedItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ReplicationProtectedItemsClient) listNextResults(lastResults ReplicationProtectedItemCollection) (result ReplicationProtectedItemCollection, err error) {
	req, err := lastResults.replicationProtectedItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicationProtectedItemsClient) ListComplete(ctx context.Context, skipToken string, filter string) (result ReplicationProtectedItemCollectionIterator, err error) {
	result.page, err = client.List(ctx, skipToken, filter)
	return
}

// ListByReplicationProtectionContainers gets the list of ASR replication protected items in the protection container.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
func (client ReplicationProtectedItemsClient) ListByReplicationProtectionContainers(ctx context.Context, fabricName string, protectionContainerName string) (result ReplicationProtectedItemCollectionPage, err error) {
	result.fn = client.listByReplicationProtectionContainersNextResults
	req, err := client.ListByReplicationProtectionContainersPreparer(ctx, fabricName, protectionContainerName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "ListByReplicationProtectionContainers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByReplicationProtectionContainersSender(req)
	if err != nil {
		result.rpic.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "ListByReplicationProtectionContainers", resp, "Failure sending request")
		return
	}

	result.rpic, err = client.ListByReplicationProtectionContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "ListByReplicationProtectionContainers", resp, "Failure responding to request")
	}

	return
}

// ListByReplicationProtectionContainersPreparer prepares the ListByReplicationProtectionContainers request.
func (client ReplicationProtectedItemsClient) ListByReplicationProtectionContainersPreparer(ctx context.Context, fabricName string, protectionContainerName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":              autorest.Encode("path", fabricName),
		"protectionContainerName": autorest.Encode("path", protectionContainerName),
		"resourceGroupName":       autorest.Encode("path", client.ResourceGroupName),
		"resourceName":            autorest.Encode("path", client.ResourceName),
		"subscriptionId":          autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByReplicationProtectionContainersSender sends the ListByReplicationProtectionContainers request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) ListByReplicationProtectionContainersSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByReplicationProtectionContainersResponder handles the response to the ListByReplicationProtectionContainers request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) ListByReplicationProtectionContainersResponder(resp *http.Response) (result ReplicationProtectedItemCollection, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByReplicationProtectionContainersNextResults retrieves the next set of results, if any.
func (client ReplicationProtectedItemsClient) listByReplicationProtectionContainersNextResults(lastResults ReplicationProtectedItemCollection) (result ReplicationProtectedItemCollection, err error) {
	req, err := lastResults.replicationProtectedItemCollectionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listByReplicationProtectionContainersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByReplicationProtectionContainersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listByReplicationProtectionContainersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByReplicationProtectionContainersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "listByReplicationProtectionContainersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByReplicationProtectionContainersComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicationProtectedItemsClient) ListByReplicationProtectionContainersComplete(ctx context.Context, fabricName string, protectionContainerName string) (result ReplicationProtectedItemCollectionIterator, err error) {
	result.page, err = client.ListByReplicationProtectionContainers(ctx, fabricName, protectionContainerName)
	return
}

// PlannedFailover operation to initiate a planned failover of the replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// failoverInput - disable protection input.
func (client ReplicationProtectedItemsClient) PlannedFailover(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput PlannedFailoverInput) (result ReplicationProtectedItemsPlannedFailoverFuture, err error) {
	req, err := client.PlannedFailoverPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, failoverInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "PlannedFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.PlannedFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "PlannedFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// PlannedFailoverPreparer prepares the PlannedFailover request.
func (client ReplicationProtectedItemsClient) PlannedFailoverPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput PlannedFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/plannedFailover", pathParameters),
		autorest.WithJSON(failoverInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PlannedFailoverSender sends the PlannedFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) PlannedFailoverSender(req *http.Request) (future ReplicationProtectedItemsPlannedFailoverFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// PlannedFailoverResponder handles the response to the PlannedFailover request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) PlannedFailoverResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Purge the operation to delete or purge a replication protected item. This operation will force delete the
// replication protected item. Use the remove operation on replication protected item to perform a clean disable
// replication for the item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
func (client ReplicationProtectedItemsClient) Purge(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (result ReplicationProtectedItemsPurgeFuture, err error) {
	req, err := client.PurgePreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Purge", nil, "Failure preparing request")
		return
	}

	result, err = client.PurgeSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Purge", result.Response(), "Failure sending request")
		return
	}

	return
}

// PurgePreparer prepares the Purge request.
func (client ReplicationProtectedItemsClient) PurgePreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PurgeSender sends the Purge request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) PurgeSender(req *http.Request) (future ReplicationProtectedItemsPurgeFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// PurgeResponder handles the response to the Purge request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) PurgeResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// RepairReplication the operation to start resynchronize/repair replication for a replication protected item requiring
// resynchronization.
// Parameters:
// fabricName - the name of the fabric.
// protectionContainerName - the name of the container.
// replicatedProtectedItemName - the name of the replication protected item.
func (client ReplicationProtectedItemsClient) RepairReplication(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (result ReplicationProtectedItemsRepairReplicationFuture, err error) {
	req, err := client.RepairReplicationPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "RepairReplication", nil, "Failure preparing request")
		return
	}

	result, err = client.RepairReplicationSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "RepairReplication", result.Response(), "Failure sending request")
		return
	}

	return
}

// RepairReplicationPreparer prepares the RepairReplication request.
func (client ReplicationProtectedItemsClient) RepairReplicationPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/repairReplication", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// RepairReplicationSender sends the RepairReplication request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) RepairReplicationSender(req *http.Request) (future ReplicationProtectedItemsRepairReplicationFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// RepairReplicationResponder handles the response to the RepairReplication request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) RepairReplicationResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Reprotect operation to reprotect or reverse replicate a failed over replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// rrInput - disable protection input.
func (client ReplicationProtectedItemsClient) Reprotect(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, rrInput ReverseReplicationInput) (result ReplicationProtectedItemsReprotectFuture, err error) {
	req, err := client.ReprotectPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, rrInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Reprotect", nil, "Failure preparing request")
		return
	}

	result, err = client.ReprotectSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Reprotect", result.Response(), "Failure sending request")
		return
	}

	return
}

// ReprotectPreparer prepares the Reprotect request.
func (client ReplicationProtectedItemsClient) ReprotectPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, rrInput ReverseReplicationInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/reProtect", pathParameters),
		autorest.WithJSON(rrInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ReprotectSender sends the Reprotect request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) ReprotectSender(req *http.Request) (future ReplicationProtectedItemsReprotectFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// ReprotectResponder handles the response to the Reprotect request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) ReprotectResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestFailover operation to perform a test failover of the replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// failoverInput - test failover input.
func (client ReplicationProtectedItemsClient) TestFailover(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput TestFailoverInput) (result ReplicationProtectedItemsTestFailoverFuture, err error) {
	req, err := client.TestFailoverPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, failoverInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "TestFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.TestFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "TestFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestFailoverPreparer prepares the TestFailover request.
func (client ReplicationProtectedItemsClient) TestFailoverPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput TestFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailover", pathParameters),
		autorest.WithJSON(failoverInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestFailoverSender sends the TestFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) TestFailoverSender(req *http.Request) (future ReplicationProtectedItemsTestFailoverFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestFailoverResponder handles the response to the TestFailover request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) TestFailoverResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TestFailoverCleanup operation to clean up the test failover of a replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// cleanupInput - test failover cleanup input.
func (client ReplicationProtectedItemsClient) TestFailoverCleanup(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, cleanupInput TestFailoverCleanupInput) (result ReplicationProtectedItemsTestFailoverCleanupFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: cleanupInput,
			Constraints: []validation.Constraint{{Target: "cleanupInput.Properties", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("siterecovery.ReplicationProtectedItemsClient", "TestFailoverCleanup", err.Error())
	}

	req, err := client.TestFailoverCleanupPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, cleanupInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "TestFailoverCleanup", nil, "Failure preparing request")
		return
	}

	result, err = client.TestFailoverCleanupSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "TestFailoverCleanup", result.Response(), "Failure sending request")
		return
	}

	return
}

// TestFailoverCleanupPreparer prepares the TestFailoverCleanup request.
func (client ReplicationProtectedItemsClient) TestFailoverCleanupPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, cleanupInput TestFailoverCleanupInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/testFailoverCleanup", pathParameters),
		autorest.WithJSON(cleanupInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TestFailoverCleanupSender sends the TestFailoverCleanup request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) TestFailoverCleanupSender(req *http.Request) (future ReplicationProtectedItemsTestFailoverCleanupFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TestFailoverCleanupResponder handles the response to the TestFailoverCleanup request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) TestFailoverCleanupResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UnplannedFailover operation to initiate a failover of the replication protected item.
// Parameters:
// fabricName - unique fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// failoverInput - disable protection input.
func (client ReplicationProtectedItemsClient) UnplannedFailover(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput UnplannedFailoverInput) (result ReplicationProtectedItemsUnplannedFailoverFuture, err error) {
	req, err := client.UnplannedFailoverPreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, failoverInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "UnplannedFailover", nil, "Failure preparing request")
		return
	}

	result, err = client.UnplannedFailoverSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "UnplannedFailover", result.Response(), "Failure sending request")
		return
	}

	return
}

// UnplannedFailoverPreparer prepares the UnplannedFailover request.
func (client ReplicationProtectedItemsClient) UnplannedFailoverPreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, failoverInput UnplannedFailoverInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}/unplannedFailover", pathParameters),
		autorest.WithJSON(failoverInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UnplannedFailoverSender sends the UnplannedFailover request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) UnplannedFailoverSender(req *http.Request) (future ReplicationProtectedItemsUnplannedFailoverFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UnplannedFailoverResponder handles the response to the UnplannedFailover request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) UnplannedFailoverResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Update the operation to update the recovery settings of an ASR replication protected item.
// Parameters:
// fabricName - fabric name.
// protectionContainerName - protection container name.
// replicatedProtectedItemName - replication protected item name.
// updateProtectionInput - update protection input.
func (client ReplicationProtectedItemsClient) Update(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, updateProtectionInput UpdateReplicationProtectedItemInput) (result ReplicationProtectedItemsUpdateFuture, err error) {
	req, err := client.UpdatePreparer(ctx, fabricName, protectionContainerName, replicatedProtectedItemName, updateProtectionInput)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Update", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "Update", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdatePreparer prepares the Update request.
func (client ReplicationProtectedItemsClient) UpdatePreparer(ctx context.Context, fabricName string, protectionContainerName string, replicatedProtectedItemName string, updateProtectionInput UpdateReplicationProtectedItemInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                  autorest.Encode("path", fabricName),
		"protectionContainerName":     autorest.Encode("path", protectionContainerName),
		"replicatedProtectedItemName": autorest.Encode("path", replicatedProtectedItemName),
		"resourceGroupName":           autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                autorest.Encode("path", client.ResourceName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicatedProtectedItemName}", pathParameters),
		autorest.WithJSON(updateProtectionInput),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateSender sends the Update request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) UpdateSender(req *http.Request) (future ReplicationProtectedItemsUpdateFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateResponder handles the response to the Update request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) UpdateResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateMobilityService the operation to update(push update) the installed mobility service software on a replication
// protected item to the latest available version.
// Parameters:
// fabricName - the name of the fabric containing the protected item.
// protectionContainerName - the name of the container containing the protected item.
// replicationProtectedItemName - the name of the protected item on which the agent is to be updated.
// updateMobilityServiceRequest - request to update the mobility service on the protected item.
func (client ReplicationProtectedItemsClient) UpdateMobilityService(ctx context.Context, fabricName string, protectionContainerName string, replicationProtectedItemName string, updateMobilityServiceRequest UpdateMobilityServiceRequest) (result ReplicationProtectedItemsUpdateMobilityServiceFuture, err error) {
	req, err := client.UpdateMobilityServicePreparer(ctx, fabricName, protectionContainerName, replicationProtectedItemName, updateMobilityServiceRequest)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "UpdateMobilityService", nil, "Failure preparing request")
		return
	}

	result, err = client.UpdateMobilityServiceSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "siterecovery.ReplicationProtectedItemsClient", "UpdateMobilityService", result.Response(), "Failure sending request")
		return
	}

	return
}

// UpdateMobilityServicePreparer prepares the UpdateMobilityService request.
func (client ReplicationProtectedItemsClient) UpdateMobilityServicePreparer(ctx context.Context, fabricName string, protectionContainerName string, replicationProtectedItemName string, updateMobilityServiceRequest UpdateMobilityServiceRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"fabricName":                   autorest.Encode("path", fabricName),
		"protectionContainerName":      autorest.Encode("path", protectionContainerName),
		"replicationProtectedItemName": autorest.Encode("path", replicationProtectedItemName),
		"resourceGroupName":            autorest.Encode("path", client.ResourceGroupName),
		"resourceName":                 autorest.Encode("path", client.ResourceName),
		"subscriptionId":               autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-01-10"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{resourceName}/replicationFabrics/{fabricName}/replicationProtectionContainers/{protectionContainerName}/replicationProtectedItems/{replicationProtectedItemName}/updateMobilityService", pathParameters),
		autorest.WithJSON(updateMobilityServiceRequest),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateMobilityServiceSender sends the UpdateMobilityService request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicationProtectedItemsClient) UpdateMobilityServiceSender(req *http.Request) (future ReplicationProtectedItemsUpdateMobilityServiceFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// UpdateMobilityServiceResponder handles the response to the UpdateMobilityService request. The method always
// closes the http.Response Body.
func (client ReplicationProtectedItemsClient) UpdateMobilityServiceResponder(resp *http.Response) (result ReplicationProtectedItem, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
