/* smb_auth.c -- Standalone SMB auth uses pamsmbd server 
  
   Copyright (c) Dave Airlie 2000
   airlied@samba.org   

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


*/

#include "config.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>

#ifdef PAM_SMB_DAEMON
#include "pam_smb_queue.h"
#else
#include "valid.h"
#endif

#include <syslog.h>

#define safestrcpy(s1, s2, n) strncpy(s1, s2, n); ((char *)s1)[n-1] = 0

extern int queue_user(char *, char *, char *);

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

/* Define function phototypes */
#ifndef PAM_SMB_DAEMON
extern int smb_readpamconf(char *smb_server, char *smb_server2, char *smb_domain);
#endif

extern char *crypt(const char *key, const char *salt);	/* This should have 
							   been in unistd.h
							   but it is not */
                        
/* 
 * 
 * _pam_auth_smb() actually performs UNIX/shadow authentication and
 * then performs the NT Validation.
 *
 *	First, if shadow support is available, attempt to perform
 *	authentication using shadow passwords. If shadow is not
 *	available, or user does not have a shadow password, fallback
 *	onto a normal UNIX authentication
 *      If neither shadow nor normal succeed it will send the username
 *      and password to a local server, which will do the authentication.
 */

int main(int argc, char **argv)
{
        int retval;
	struct passwd *pw;
	const char *name;
	char *p, *pp;
	int w,loop;
	const char *salt;
	char domain[80];
	char ntname[40];
	int debug=0, use_first_pass=0;
	int unknown_user=0;
	int nolocal=0;
#ifndef PAM_SMB_DAEMON
	char server[80], server2[80];
#endif

	safestrcpy(domain, "MYDOMAIN", 80);

	/* Parse Command line options */
  
	for (loop=0; loop<argc; loop++)
	  {
	    if (!strcmp(argv[loop], "debug"))
	      debug=1;
	  }
	   
	/* get the user'name' */
	
	safestrcpy(ntname, name, 40);

	/* If nolocal is specified pam_smb does not try and do local
	   username/password authentication .. this is a command line option
	   to pam_smb_auth.so in /etc/pam.d/ */

	w=queue_user(ntname, p, domain);
	if (debug) {
	  syslog(LOG_AUTHPRIV | LOG_DEBUG, "pam_smb: got back %d username %s\n",w,  ntname);
	}
	if ((!w) && (strcmp(name, ntname)!=0))
        {
	  safestrcpy(name, ntname, 15); // where does 15 come from?
        }

	/* Users valid user for return value 0 is success
	   1 and 2 indicate Network and protocol failures and
	   3 is not logged on 
	   */

	switch (w)
	  {
	  case 0 : 
	    /*
	    if (debug) syslog(LOG_AUTHPRIV | LOG_DEBUG, "pam_smb: Correct NT username/password pair"); */
	    return 0;
	    break;
	  case 1 :
	  case 2 :
	    return 1; break;
	  case 3 :
	  default:
	    syslog(LOG_AUTHPRIV | LOG_NOTICE, "pam_smb: Incorrect NT password for username : %s", ntname);
	    return 2; break;
	  }

  	return 2;
}
