package i18n

import "testing"

func TestGetLanguageMatched(t *testing.T) {
	// exact match
	returned := GetLanguageMatched(map[string]string{"en": "test", "de": "test2"}, "en")
	if returned != "test" {
		t.Fatalf("Got: %s, want: %s", returned, "test")
	}

	// starts with language tag
	returned = GetLanguageMatched(map[string]string{"en-US-test": "test", "de": "test2"}, "en-US")
	if returned != "test" {
		t.Fatalf("Got: %s, want: %s", returned, "test")
	}

	// starts with en-
	returned = GetLanguageMatched(map[string]string{"en-UK": "test", "en": "test2"}, "en-US")
	if returned != "test" {
		t.Fatalf("Got: %s, want: %s", returned, "test")
	}

	// exact match for en
	returned = GetLanguageMatched(map[string]string{"de": "test", "en": "test2"}, "en-US")
	if returned != "test2" {
		t.Fatalf("Got: %s, want: %s", returned, "test2")
	}

	// We default to english
	returned = GetLanguageMatched(map[string]string{"es": "test", "en": "test2"}, "nl-NL")
	if returned != "test2" {
		t.Fatalf("Got: %s, want: %s", returned, "test2")
	}

	// We default to english with a - as well
	returned = GetLanguageMatched(map[string]string{"est": "test", "en-": "test2"}, "en-US")
	if returned != "test2" {
		t.Fatalf("Got: %s, want: %s", returned, "test2")
	}

	// None found just return one
	returned = GetLanguageMatched(map[string]string{"es": "test"}, "en-US")
	if returned != "test" {
		t.Fatalf("Got: %s, want: %s", returned, "test")
	}
}
