#
# @package Tools
#
# @copyright (c) 2009-2018 The University of Tennessee and The
#                          University of Tennessee Research Foundation.
#                          All rights reserved.
# @copyright (c) 2012-2019 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
#                          Univ. Bordeaux. All rights reserved.
#
# @project MORSE
#
# MORSE is a software package provided by:
#      Inria Bordeaux - Sud-Ouest,
#      Univ. of Tennessee,
#      King Abdullah Univesity of Science and Technology
#      Univ. of California Berkeley,
#      Univ. of Colorado Denver.
#
# @author Mark Gates
# @author Mathieu Faverge
#
# @date 2019-4-2
#
# This python script holds the blas/lapack dictionnaries for the substitutions
# of the precision generation tool codegen.py.
#
# ===========================================================================
# BLAS and LAPACK routines need both lower and uppercase, for example:
# in filenames:              zgetrf.cpp
# in magma_zlapack.h:        FORTRAN_NAME( zaxpy, ZAXAPY )
# in doxygen documentation:  ZGETRF computes ...
# BLAS also needs Titlecase: cublasZaxpy
# The easiest way to maintain this is to separate these lists here,
# and use them later with the above lower, upper, and title routines.

# ----------------------------------------
blas_mixed = [
    # BLAS and LAPACK, lowercase, alphabetic order
    # for mixed precision
    # double/single,         double-complex/single-complex
    #'12345678901234567890', '12345678901234567890')

    # ----- mixed "zc" routines
    ('dsposv',               'zcposv'              ),
    ('dsgesv',               'zcgesv'              ),
    ('dsgbsv',               'zcgbsv'              ),

    # ----- regular routines
    ('daxpy',                'zaxpy'               ),
    ('ddot',                 'zdotc'               ),
    ('dgeadd',               'zgeadd'              ),
    ('dgemm',                'zgemm'               ),
    ('dgeqrf',               'zgeqrf'              ),
    ('dgeqrs',               'zgeqrs'              ),
    ('dgesv',                'zgesv'               ),
    ('dgeswp',               'zgeswp'              ),
    ('dgetrf',               'zgetrf'              ),
    ('dgetrs',               'zgetrs'              ),
    ('dlacpy',               'zlacpy'              ),
    ('dlag2s',               'zlag2c'              ),
    ('dlagsy',               'zlaghe'              ),
    ('dlange',               'zlange'              ),
    ('dlansy',               'zlanhe'              ),
    ('dlansy',               'zlansy'              ),
    ('dlarnv',               'zlarnv'              ),
    ('dlaset',               'zlaset'              ),
    ('dlaswp',               'zlaswp'              ),
    ('dlat2s',               'zlat2c'              ),
    ('dnrm2',                'dznrm2'              ),
    ('dormqr',               'zunmqr'              ),
    ('dpotrf',               'zpotrf'              ),
    ('dpotrs',               'zpotrs'              ),
    ('dsymm',                'zhemm'               ),
    ('dsymv',                'zhemv'               ),
    ('dsyrk',                'zherk'               ),
    ('dtrmm',                'ztrmm'               ),
    ('dtrsm',                'ztrsm'               ),
    ('dtrsv',                'ztrsv'               ),
    ('damax',                'dzamax'              ),
    ('idamax',               'izamax'              ),
    ('sgetrf',               'cgetrf',             ),
    ('sgeswp',               'cgeswp',             ),
    ('slag2d',               'clag2z'              ),
    ('slansy',               'clanhe'              ),
    ('slaswp',               'claswp'              ),
    ('slat2d',               'clat2z'              ),
    ('spotrf',               'cpotrf'              ),
    ('strmm',                'ctrmm'               ),
    ('strsm',                'ctrsm'               ),
    ('strsv',                'ctrsv'               ),
]


# ----------------------------------------
blas = [
    # BLAS, lowercase, alphabetic order
    #int  single                  double                  single-complex          double-complex
    #'', '12345678901234567890', '12345678901234567890', '12345678901234567890', '12345678901234567890')
    ('', 'isamax',               'idamax',               'icamax',               'izamax'              ),
    ('', 'isamax',               'idamax',               'isamax',               'idamax'              ),
    ('', 'isamin',               'idamin',               'icamin',               'izamin'              ),
    ('', 'samax',                'damax',                'samax',                'damax'               ),
    ('', 'samax',                'damax',                'scamax',               'dzamax'              ),
    ('', 'sasum',                'dasum',                'scasum',               'dzasum'              ),
    ('', 'saxpy',                'daxpy',                'saxpy',                'daxpy'               ),
    ('', 'saxpy',                'daxpy',                'caxpy',                'zaxpy'               ),
    ('', 'scopy',                'dcopy',                'ccopy',                'zcopy'               ),
    ('', 'scopy',                'dcopy',                'scopy',                'dcopy'               ),
    ('', 'sdot',                 'ddot',                 'cdotc',                'zdotc'               ),
    ('', 'sdot',                 'ddot',                 'cdotu',                'zdotu'               ),
    ('', 'dot',                  'dot',                  'dotc',                 'dotc'                ),
    ('', 'dot',                  'dot',                  'dotu',                 'dotu'                ),
    ('', 'sgeadd',               'dgeadd',               'cgeadd',               'zgeadd'              ),
    ('', 'sgem',                 'dgem',                 'cgem',                 'zgem'                ), # zgemm, zgemdm, zgemv
    ('', 'sger',                 'dger',                 'cgerc',                'zgerc'               ),
    ('', 'sger',                 'dger',                 'cgeru',                'zgeru'               ),
    ('', 'snrm2',                'dnrm2',                'scnrm2',               'dznrm2'              ),
    ('', 'snrm2',                'dnrm2',                'snrm2',                'dnrm2'               ),
    ('', 'srot',                 'drot',                 'crot',                 'zrot'                ),
    ('', 'srot',                 'drot',                 'csrot',                'zdrot'               ),
    ('', 'srot',                 'drot',                 'srot',                 'drot'                ),
    ('', 'sscal',                'dscal',                'cscal',                'zscal'               ),
    ('', 'sscal',                'dscal',                'csscal',               'zdscal'              ),
    ('', 'sscal',                'dscal',                'sscal',                'dscal'               ),
    ('', 'sswap',                'dswap',                'cswap',                'zswap'               ),
    ('', 'ssymm',                'dsymm',                'chemm',                'zhemm'               ),
    ('', 'ssymm',                'dsymm',                'csymm',                'zsymm'               ),
    ('', 'ssymv',                'dsymv',                'chemv',                'zhemv'               ),
    ('', 'ssymv',                'dsymv',                'csymv',                'zsymv'               ),
    ('', 'ssyr',                 'dsyr',                 'cher',                 'zher'                ),  # also does zher2, zher2k, zherk
    ('', 'ssyr',                 'dsyr',                 'csyr',                 'zsyr'                ),  # also does zsyrk, zsyr2k
    ('', 'stbsm',                'dtbsm',                'ctbsm',                'ztbsm'               ),
    ('', 'stradd',               'dtradd',               'ctradd',               'ztradd'              ),
    ('', 'strmm',                'dtrmm',                'ctrmm',                'ztrmm'               ),
    ('', 'strmv',                'dtrmv',                'ctrmv',                'ztrmv'               ),
    ('', 'strsm',                'dtrsm',                'ctrsm',                'ztrsm'               ),
    ('', 'strsv',                'dtrsv',                'ctrsv',                'ztrsv'               ),
]


# ----------------------------------------
lapack = [
    # LAPACK, lowercase, alphabetic order
    #int  single                  double                  single-complex          double-complex
    #'', '12345678901234567890', '12345678901234567890', '12345678901234567890', '12345678901234567890')
    ('', 'sbdsdc',               'dbdsdc',               'sbdsdc',               'dbdsdc'              ),
    ('', 'sbdsqr',               'dbdsqr',               'cbdsqr',               'zbdsqr'              ),
    ('', 'sbdt01',               'dbdt01',               'cbdt01',               'zbdt01'              ),
    ('', 'sgbbrd',               'dgbbrd',               'cgbbrd',               'zgbbrd'              ),
    ('', 'sgbsv',                'dgbsv',                'cgbsv',                'zgbsv'               ),
    ('', 'sgbtrf',               'dgbtrf',               'cgbtrf',               'zgbtrf'              ),
    ('', 'sgbtrs',               'dgbtrs',               'cgbtrs',               'zgbtrs'              ),
    ('', 'sgebak',               'dgebak',               'cgebak',               'zgebak'              ),
    ('', 'sgebal',               'dgebal',               'cgebal',               'zgebal'              ),
    ('', 'sgebd2',               'dgebd2',               'cgebd2',               'zgebd2'              ),
    ('', 'sgebrd',               'dgebrd',               'cgebrd',               'zgebrd'              ),
    ('', 'sgeev',                'dgeev',                'cgeev',                'zgeev'               ),
    ('', 'sgegqr',               'dgegqr',               'cgegqr',               'zgegqr'              ),
    ('', 'sgehd2',               'dgehd2',               'cgehd2',               'zgehd2'              ),
    ('', 'sgehrd',               'dgehrd',               'cgehrd',               'zgehrd'              ),
    ('', 'sgeinv',               'dgeinv',               'cgeinv',               'zgeinv'              ),
    ('', 'sgelq2',               'dgelq2',               'cgelq2',               'zgelq2'              ),
    ('', 'sgelqf',               'dgelqf',               'cgelqf',               'zgelqf'              ),
    ('', 'sgelqs',               'dgelqs',               'cgelqs',               'zgelqs'              ),
    ('', 'sgelqt',               'dgelqt',               'cgelqt',               'zgelqt'              ),
    ('', 'sgels',                'dgels',                'cgels',                'zgels'               ),
    ('', 'sgeqlf',               'dgeqlf',               'cgeqlf',               'zgeqlf'              ),
    ('', 'sgeqp3',               'dgeqp3',               'cgeqp3',               'zgeqp3'              ),
    ('', 'sgeqr2',               'dgeqr2',               'cgeqr2',               'zgeqr2'              ),
    ('', 'sgeqrf',               'dgeqrf',               'cgeqrf',               'zgeqrf'              ),
    ('', 'sgeqrs',               'dgeqrs',               'cgeqrs',               'zgeqrs'              ),
    ('', 'sgeqrt',               'dgeqrt',               'cgeqrt',               'zgeqrt'              ),
    ('', 'sgerfs',               'dgerfs',               'cgerfs',               'zgerfs'              ),
    ('', 'sgesdd',               'dgesdd',               'cgesdd',               'zgesdd'              ),
    ('', 'sgessm',               'dgessm',               'cgessm',               'zgessm'              ),
    ('', 'sgessq',               'dgessq',               'cgessq',               'zgessq'              ),
    ('', 'sgessq',               'dgessq',               'sgessq',               'dgessq'              ),
    ('', 'sgesv',                'dgesv',                'cgesv',                'zgesv'               ),  # also does zgesvd
    ('', 'sgeswp',               'dgeswp',               'cgeswp',               'zgeswp'              ),
    ('', 'sget22',               'dget22',               'cget22',               'zget22'              ),
    ('', 'sgetf2',               'dgetf2',               'cgetf2',               'zgetf2'              ),
    ('', 'sgetmi',               'dgetmi',               'cgetmi',               'zgetmi'              ),
    ('', 'sgetmo',               'dgetmo',               'cgetmo',               'zgetmo'              ),
    ('', 'sgetrf',               'dgetrf',               'cgetrf',               'zgetrf'              ),
    ('', 'sgetri',               'dgetri',               'cgetri',               'zgetri'              ),
    ('', 'sgetrs',               'dgetrs',               'cgetrs',               'zgetrs'              ),
    ('', 'shseqr',               'dhseqr',               'chseqr',               'zhseqr'              ),
    ('', 'shst01',               'dhst01',               'chst01',               'zhst01'              ),
    ('', 'slabad',               'dlabad',               'slabad',               'dlabad'              ),
    ('', 'slabrd',               'dlabrd',               'clabrd',               'zlabrd'              ),
    ('', 'slacgv',               'dlacgv',               'clacgv',               'zlacgv'              ),
    ('', 'slacp2',               'dlacp2',               'clacp2',               'zlacp2'              ),
    ('', 'slacpy',               'dlacpy',               'clacpy',               'zlacpy'              ),
    ('', 'slacrm',               'dlacrm',               'clacrm',               'zlacrm'              ),
    ('', 'sladiv',               'dladiv',               'cladiv',               'zladiv'              ),
    ('', 'slaed',                'dlaed',                'slaed',                'dlaed'               ),
    ('', 'slaex',                'dlaex',                'slaex',                'dlaex'               ),
    ('', 'slag2d',               'dlag2s',               'clag2z',               'zlag2c'              ),
    ('', 'slagsy',               'dlagsy',               'claghe',               'zlaghe'              ),
    ('', 'slagsy',               'dlagsy',               'clagsy',               'zlagsy'              ),
    ('', 'slahr',                'dlahr',                'clahr',                'zlahr'               ),
    ('', 'slaln2',               'dlaln2',               'slaln2',               'dlaln2'              ),
    ('', 'slamc3',               'dlamc3',               'slamc3',               'dlamc3'              ),
    ('', 'slamch',               'dlamch',               'slamch',               'dlamch'              ),
    ('', 'slamrg',               'dlamrg',               'slamrg',               'dlamrg'              ),
    ('', 'slangb',               'dlangb',               'clangb',               'zlangb'              ),
    ('', 'slange',               'dlange',               'clange',               'zlange'              ),
    ('', 'slange',               'dlange',               'slange',               'dlange'              ),
    ('', 'slanst',               'dlanst',               'clanht',               'zlanht'              ),
    ('', 'slansy',               'dlansy',               'clanhe',               'zlanhe'              ),
    ('', 'slansy',               'dlansy',               'clansy',               'zlansy'              ),
    ('', 'slansy',               'dlansy',               'slansy',               'dlansy'              ),
    ('', 'slantr',               'dlantr',               'clantr',               'zlantr'              ),
    ('', 'slantr',               'dlantr',               'slantr',               'dlantr'              ),
    ('', 'slapy3',               'dlapy3',               'slapy3',               'dlapy3'              ),
    ('', 'slaqp2',               'dlaqp2',               'claqp2',               'zlaqp2'              ),
    ('', 'slaqps',               'dlaqps',               'claqps',               'zlaqps'              ),
    ('', 'slaqtrs',              'dlaqtrs',              'claqtrs',              'zlaqtrs'             ),
    ('', 'slarcm',               'dlarcm',               'clarcm',               'zlarcm'              ),
    ('', 'slarf',                'dlarf',                'clarf',                'zlarf'               ),  # also does zlarfb, zlarfg, etc.
    ('', 'slarnv',               'dlarnv',               'clarnv',               'zlarnv'              ),
    ('', 'slarnv',               'dlarnv',               'slarnv',               'dlarnv'              ),
    ('', 'slartg',               'dlartg',               'clartg',               'zlartg'              ),
    ('', 'slascl',               'dlascl',               'clascl',               'zlascl'              ),
    ('', 'slaset',               'dlaset',               'claset',               'zlaset'              ),
    ('', 'slasrt',               'dlasrt',               'slasrt',               'dlasrt'              ),
    ('', 'slassq',               'dlassq',               'classq',               'zlassq'              ),
    ('', 'slaswp',               'dlaswp',               'claswp',               'zlaswp'              ),
    ('', 'slasyf',               'dlasyf',               'clahef',               'zlahef'              ),
    ('', 'slatms',               'dlatms',               'clatms',               'zlatms'              ),
    ('', 'slatrd',               'dlatrd',               'clatrd',               'zlatrd'              ),
    ('', 'slatrs',               'dlatrs',               'clatrs',               'zlatrs'              ),
    ('', 'slauum',               'dlauum',               'clauum',               'zlauum'              ),
    ('', 'slavsy',               'dlavsy',               'clavhe',               'zlavhe'              ),
    ('', 'sorg2r',               'dorg2r',               'cung2r',               'zung2r'              ),
    ('', 'sorgbr',               'dorgbr',               'cungbr',               'zungbr'              ),
    ('', 'sorghr',               'dorghr',               'cunghr',               'zunghr'              ),
    ('', 'sorglq',               'dorglq',               'cunglq',               'zunglq'              ),
    ('', 'sorgql',               'dorgql',               'cungql',               'zungql'              ),
    ('', 'sorgqr',               'dorgqr',               'cungqr',               'zungqr'              ),
    ('', 'sorgtr',               'dorgtr',               'cungtr',               'zungtr'              ),
    ('', 'sorm2r',               'dorm2r',               'cunm2r',               'zunm2r'              ),
    ('', 'sormbr',               'dormbr',               'cunmbr',               'zunmbr'              ),
    ('', 'sormlq',               'dormlq',               'cunmlq',               'zunmlq'              ),
    ('', 'sormql',               'dormql',               'cunmql',               'zunmql'              ),
    ('', 'sormqr',               'dormqr',               'cunmqr',               'zunmqr'              ),
    ('', 'sormr2',               'dormr2',               'cunmr2',               'zunmr2'              ),
    ('', 'sormtr',               'dormtr',               'cunmtr',               'zunmtr'              ),
    ('', 'sort01',               'dort01',               'cunt01',               'zunt01'              ),
    ('', 'spack',                'dpack',                'cpack',                'zpack'               ),
    ('', 'spamm',                'dpamm',                'cpamm',                'zpamm'               ),
    ('', 'sparfb',               'dparfb',               'cparfb',               'zparfb'              ),
    ('', 'spbsv',                'dpbsv',                'cpbsv',                'zpbsv'               ),
    ('', 'spbtrf',               'dpbtrf',               'cpbtrf',               'zpbtrf'              ),
    ('', 'spbtrf',               'dpbtrf',               'cpbtrf',               'zpbtrf'              ),
    ('', 'spbtrs',               'dpbtrs',               'cpbtrs',               'zpbtrs'              ),
    ('', 'spbtrs',               'dpbtrs',               'cpbtrs',               'zpbtrs'              ),
    ('', 'spemv',                'dpemv',                'cpemv',                'zpemv'               ),
    ('', 'splgsy',               'dplgsy',               'cplghe',               'zplghe'              ),
    ('', 'splgsy',               'dplgsy',               'cplgsy',               'zplgsy'              ),
    ('', 'splrnt',               'dplrnt',               'cplrnt',               'zplrnt'              ),
    ('', 'splrnt',               'dplrnt',               'splrnt',               'dplrnt'              ),
    ('', 'spoinv',               'dpoinv',               'cpoinv',               'zpoinv'              ),
    ('', 'sposv',                'dposv',                'cposv',                'zposv'               ),
    ('', 'spotf2',               'dpotf2',               'cpotf2',               'zpotf2'              ),
    ('', 'spotrf',               'dpotrf',               'cpotrf',               'zpotrf'              ),
    ('', 'spotri',               'dpotri',               'cpotri',               'zpotri'              ),
    ('', 'spotrs',               'dpotrs',               'cpotrs',               'zpotrs'              ),
    ('', 'sqpt01',               'dqpt01',               'cqpt01',               'zqpt01'              ),
    ('', 'sqrt02',               'dqrt02',               'cqrt02',               'zqrt02'              ),
    ('', 'ssbtrd',               'dsbtrd',               'chbtrd',               'zhbtrd'              ),
    ('', 'sshift',               'dshift',               'cshift',               'zshift'              ),
    ('', 'sssssm',               'dssssm',               'cssssm',               'zssssm'              ),
    ('', 'sstebz',               'dstebz',               'sstebz',               'dstebz'              ),
    ('', 'sstedc',               'dstedc',               'cstedc',               'zstedc'              ),
    ('', 'sstedx',               'dstedx',               'cstedx',               'zstedx'              ),
    ('', 'sstedx',               'dstedx',               'sstedx',               'dstedx'              ),
    ('', 'sstegr',               'dstegr',               'cstegr',               'zstegr'              ),
    ('', 'sstein',               'dstein',               'cstein',               'zstein'              ),
    ('', 'sstemr',               'dstemr',               'cstemr',               'zstemr'              ),
    ('', 'ssteqr',               'dsteqr',               'csteqr',               'zsteqr'              ),
    ('', 'ssterf',               'dsterf',               'ssterf',               'dsterf'              ),
    ('', 'ssterm',               'dsterm',               'csterm',               'zsterm'              ),
    ('', 'sstt21',               'dstt21',               'cstt21',               'zstt21'              ),
    ('', 'ssyev',                'dsyev',                'cheev',                'zheev'               ),
    ('', 'ssyevd',               'dsyevd',               'cheevd',               'zheevd'              ),
    ('', 'ssygs2',               'dsygs2',               'chegs2',               'zhegs2'              ),
    ('', 'ssygst',               'dsygst',               'chegst',               'zhegst'              ),
    ('', 'ssygv',                'dsygv',                'chegv',                'zhegv'               ),
    ('', 'ssyssq',               'dsyssq',               'chessq',               'zhessq'              ),
    ('', 'ssyssq',               'dsyssq',               'csyssq',               'zsyssq'              ),
    ('', 'ssyssq',               'dsyssq',               'ssyssq',               'dsyssq'              ),
    ('', 'ssysv',                'dsysv',                'chesv',                'zhesv'               ),
    ('', 'ssysv',                'dsysv',                'csysv',                'zsysv'               ),
    ('', 'ssyswp',               'dsyswp',               'cheswp',               'zheswp'              ),
    ('', 'ssyt21',               'dsyt21',               'chet21',               'zhet21'              ),
    ('', 'ssytd2',               'dsytd2',               'chetd2',               'zhetd2'              ),
    ('', 'ssytf2',               'dsytf2',               'chetf2',               'zhetf2'              ),
    ('', 'ssytf2',               'dsytf2',               'csytf2',               'zsytf2'              ),
    ('', 'ssytrd',               'dsytrd',               'chetrd',               'zhetrd'              ),
    ('', 'ssytrf',               'dsytrf',               'chetrf',               'zhetrf'              ),
    ('', 'ssytrf',               'dsytrf',               'csytrf',               'zsytrf'              ),
    ('', 'ssytrs',               'dsytrs',               'chetrs',               'zhetrs'              ),
    ('', 'ssytrs',               'dsytrs',               'csytrs',               'zsytrs'              ),
    ('', 'stpgqrt',              'dtpgqrt',              'ctpgqrt',              'ztpgqrt'             ),
    ('', 'stplqt',               'dtplqt',               'ctplqt',               'ztplqt'              ),
    ('', 'stpmlqt',              'dtpmlqt',              'ctpmlqt',              'ztpmlqt'             ),
    ('', 'stpmqrt',              'dtpmqrt',              'ctpmqrt',              'ztpmqrt'             ),
    ('', 'stpqrt',               'dtpqrt',               'ctpqrt',               'ztpqrt'              ),
    ('', 'strevc',               'dtrevc',               'ctrevc',               'ztrevc'              ),
    ('', 'strsmpl',              'dtrsmpl',              'ctrsmpl',              'ztrsmpl'             ),
    ('', 'strssq',               'dtrssq',               'ctrssq',               'ztrssq'              ),
    ('', 'strtri',               'dtrtri',               'ctrtri',               'ztrtri'              ),
    ('', 'stslqt',               'dtslqt',               'ctslqt',               'ztslqt'              ),
    ('', 'stsmlq',               'dtsmlq',               'ctsmlq',               'ztsmlq'              ),
    ('', 'stsmqr',               'dtsmqr',               'ctsmqr',               'ztsmqr'              ),
    ('', 'stsqrt',               'dtsqrt',               'ctsqrt',               'ztsqrt'              ),
    ('', 'ststrf',               'dtstrf',               'ctstrf',               'ztstrf'              ),
    ('', 'sttlqt',               'dttlqt',               'cttlqt',               'zttlqt'              ),
    ('', 'sttmlq',               'dttmlq',               'cttmlq',               'zttmlq'              ),
    ('', 'sttmqr',               'dttmqr',               'cttmqr',               'zttmqr'              ),
    ('', 'sttqrt',               'dttqrt',               'cttqrt',               'zttqrt'              ),
]
