/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.contrib.demo.BalloonTipManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class FilteredTextField
extends JTextField {
    public static final Character[] UPPERCASE_CHARS = new Character[]{Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z')};
    public static final Character[] LOWERCASE_CHARS = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z')};
    public static final Character[] NUMERIC_CHARS = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('0')};
    private static final Integer ENTRY_BALLOON = 0;
    private static final Integer VALID_BALLOON = 1;
    private static final Integer LENGTH_BALLOON = 2;
    private static final Border RED_BORDER = BorderFactory.createLineBorder(Color.RED, 2);
    private ArrayList<Character> allowable = new ArrayList();
    private int maximumLength = String.valueOf(Long.MAX_VALUE).length();
    private Border defaultBorder = null;
    private boolean isValid = true;
    private Popup balloon = null;
    private String entryError = null;
    private String validRegex = null;
    private String validError = null;
    private Color balloonBorderColor = null;
    private Color balloonBackgroundColor = null;
    private Color balloonTextColor = null;
    private Integer balloonDuration = null;
    private Integer balloonType = null;

    public FilteredTextField() {
        this.init();
    }

    public FilteredTextField(int columns) {
        super(columns);
        this.init();
    }

    private void init() {
        this.defaultBorder = this.getBorder();
        this.entryError = "";
        this.validRegex = "";
        this.validError = "";
        this.balloonBorderColor = BalloonTipManager.DEFAULT_BORDER_COLOR;
        this.balloonBackgroundColor = BalloonTipManager.DEFAULT_BACKGROUND_COLOR;
        this.balloonTextColor = BalloonTipManager.DEFAULT_TEXT_COLOR;
        this.balloonDuration = 10000;
        this.balloonType = ENTRY_BALLOON;
        this.addFocusListener(new ValidationEar());
    }

    public void setCharacters(Character[] characters) {
        this.clearCharacters();
        for (int i = 0; i < characters.length; ++i) {
            this.addCharacter(characters[i]);
        }
    }

    public void addCharacters(Character[] characters) {
        for (int i = 0; i < characters.length; ++i) {
            this.addCharacter(characters[i]);
        }
    }

    public void addCharacter(Character character) {
        if (!this.allowable.contains(character)) {
            this.allowable.add(character);
        }
    }

    public void clearCharacters() {
        this.allowable.clear();
    }

    public void removeCharacters(Character[] characters) {
        for (int i = 0; i < characters.length; ++i) {
            this.removeCharacter(characters[i]);
        }
    }

    public void removeCharacter(Character character) {
        if (this.allowable.contains(character)) {
            this.allowable.remove(character);
        }
    }

    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    public void setEntryError(String entryError) {
        this.entryError = entryError;
    }

    public void setValidRegex(String validRegex) {
        this.validRegex = validRegex;
    }

    public void setValidError(String validError) {
        this.validError = validError;
    }

    public void setBalloonBorderColor(Color borderColor) {
        this.balloonBorderColor = borderColor;
    }

    public void setBalloonBackgroundColor(Color backgroundColor) {
        this.balloonBackgroundColor = backgroundColor;
    }

    public void setBalloonTextColor(Color textColor) {
        this.balloonTextColor = textColor;
    }

    public void setBalloonDuration(Integer duration) {
        this.balloonDuration = duration;
    }

    @Override
    protected Document createDefaultModel() {
        return new FilteredTextFieldDocument();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JFrame jframe = new JFrame("Balloon Tips on FilteredTextField");
        jframe.setDefaultCloseOperation(3);
        jframe.setSize(400, 75);
        jframe.setLocation(400, 400);
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BorderLayout());
        FilteredTextField ftfield = new FilteredTextField(10);
        ftfield.setCharacters(LOWERCASE_CHARS);
        ftfield.addCharacter(Character.valueOf('-'));
        ftfield.addCharacter(Character.valueOf('_'));
        ftfield.addCharacter(Character.valueOf(' '));
        ftfield.setMaximumLength(10);
        ftfield.setEntryError("Only lower case letters, hyphens, underscores, and spaces allowed.");
        ftfield.setValidRegex("^a+[a-z-_ ]*");
        ftfield.setValidError("The string must begin with the letter 'a'.");
        jpanel.add((Component)new JLabel("Type some text into either field"), "North");
        jpanel.add((Component)ftfield, "Center");
        jpanel.add((Component)new FilteredTextField(10), "South");
        jframe.getContentPane().add(jpanel);
        jframe.setVisible(true);
    }

    private class ValidationEar
    extends FocusAdapter {
        private ValidationEar() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String entered = FilteredTextField.this.getText().trim();
            if (!entered.matches(FilteredTextField.this.validRegex)) {
                if (FilteredTextField.this.balloon != null) {
                    FilteredTextField.this.balloon.hide();
                }
                FilteredTextField.this.setBorder(BorderFactory.createCompoundBorder(RED_BORDER, FilteredTextField.this.defaultBorder));
                FilteredTextField.this.isValid = false;
            } else {
                FilteredTextField.this.setBorder(FilteredTextField.this.defaultBorder);
                FilteredTextField.this.isValid = true;
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (!FilteredTextField.this.isValid) {
                FilteredTextField.this.balloon = BalloonTipManager.getBalloonTip(FilteredTextField.this, FilteredTextField.this.validError, 0, 0, FilteredTextField.this.balloonDuration, FilteredTextField.this.balloonBorderColor, FilteredTextField.this.balloonBackgroundColor, FilteredTextField.this.balloonTextColor);
                FilteredTextField.this.balloon.show();
                FilteredTextField.this.balloonType = VALID_BALLOON;
            }
        }
    }

    private class FilteredTextFieldDocument
    extends PlainDocument {
        public FilteredTextFieldDocument() {
            this.addDocumentListener(new FilteredTextFieldEar());
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing() && FilteredTextField.this.balloonType == VALID_BALLOON) {
                FilteredTextField.this.balloon.hide();
            }
            StringBuilder buffer = new StringBuilder(FilteredTextField.this.getText());
            if (offset >= 0 && offset <= buffer.length()) {
                buffer.insert(offset, str);
                String strBuf = buffer.toString();
                if (buffer.length() > FilteredTextField.this.maximumLength) {
                    if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing()) {
                        if (FilteredTextField.this.balloonType == LENGTH_BALLOON) {
                            BalloonTipManager.restartTimer();
                            return;
                        }
                        FilteredTextField.this.balloon.hide();
                    }
                    FilteredTextField.this.balloon = BalloonTipManager.getBalloonTip(FilteredTextField.this, "The number of characters must be less than or equal to " + FilteredTextField.this.maximumLength, 0, 0, FilteredTextField.this.balloonDuration, FilteredTextField.this.balloonBorderColor, FilteredTextField.this.balloonBackgroundColor, FilteredTextField.this.balloonTextColor);
                    FilteredTextField.this.balloon.show();
                    FilteredTextField.this.balloonType = LENGTH_BALLOON;
                    return;
                }
                if (strBuf == null || strBuf.equals("")) {
                    this.remove(0, this.getLength());
                    super.insertString(0, "", null);
                    if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing()) {
                        FilteredTextField.this.balloon.hide();
                    }
                    return;
                }
                if (FilteredTextField.this.allowable.contains(Character.valueOf(str.charAt(0)))) {
                    super.insertString(offset, str, a);
                    if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing()) {
                        FilteredTextField.this.balloon.hide();
                    }
                } else {
                    if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing()) {
                        if (FilteredTextField.this.balloonType == ENTRY_BALLOON) {
                            BalloonTipManager.restartTimer();
                            return;
                        }
                        FilteredTextField.this.balloon.hide();
                    }
                    FilteredTextField.this.balloon = BalloonTipManager.getBalloonTip(FilteredTextField.this, FilteredTextField.this.entryError, 0, 0, FilteredTextField.this.balloonDuration, FilteredTextField.this.balloonBorderColor, FilteredTextField.this.balloonBackgroundColor, FilteredTextField.this.balloonTextColor);
                    FilteredTextField.this.balloon.show();
                    FilteredTextField.this.balloonType = ENTRY_BALLOON;
                }
            }
        }

        private class FilteredTextFieldEar
        implements DocumentListener {
            private FilteredTextFieldEar() {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (FilteredTextField.this.balloon != null && BalloonTipManager.isShowing()) {
                    FilteredTextField.this.balloon.hide();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        }
    }
}

