/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.contrib.demo;

import com.sun.jna.contrib.demo.BalloonManager;
import com.sun.jna.platform.WindowUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class BalloonManagerDemo {
    private static final int ICON_SIZE = 48;

    public static void main(String[] args) {
        try {
            System.setProperty("sun.java2d.noddraw", "true");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame f = new JFrame("Balloon Test");
        String BALLOON_TEXT = "<html><center>This is some sample balloon text<br>which has been formatted with html.<br>Click to dismiss.</center></html>";
        final JLabel content = new JLabel("<html><center>This is some sample balloon text<br>which has been formatted with html.<br>Click to dismiss.</center></html>");
        content.setIconTextGap(10);
        content.setBorder(new EmptyBorder(0, 8, 0, 8));
        content.setSize(content.getPreferredSize());
        content.setIcon(new InfoIcon());
        JLabel label = new JLabel("Click anywhere for more information");
        label.setHorizontalAlignment(0);
        label.addMouseListener(new MouseAdapter(){
            private MouseListener listener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.hidePopup(e);
                }
            };
            private Popup popup;

            private void hidePopup(MouseEvent e) {
                e.getComponent().removeMouseListener(this.listener);
                if (this.popup != null) {
                    this.popup.hide();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.hidePopup(e);
                this.popup = BalloonManager.getBalloon(e.getComponent(), content, e.getX(), e.getY());
                this.popup.show();
                content.getParent().addMouseListener(this.listener);
            }
        });
        f.getContentPane().add(label);
        f.pack();
        f.setSize(new Dimension(300, 300));
        f.setLocation(100, 100);
        try {
            WindowUtils.setWindowMask((Window)f, WindowUtils.MASK_NONE);
            f.setVisible(true);
            f.setDefaultCloseOperation(3);
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            String msg = e.getMessage() + "\nError loading the JNA library";
            JTextArea area = new JTextArea(msg);
            area.setOpaque(false);
            area.setFont(UIManager.getFont("Label.font"));
            area.setEditable(false);
            area.setColumns(80);
            area.setRows(8);
            area.setWrapStyleWord(true);
            area.setLineWrap(true);
            JOptionPane.showMessageDialog(null, new JScrollPane(area), "Library Load Error: " + System.getProperty("os.name") + "/" + System.getProperty("os.arch"), 0);
            System.exit(1);
        }
    }

    private static class InfoIcon
    implements Icon {
        private InfoIcon() {
        }

        @Override
        public int getIconHeight() {
            return 48;
        }

        @Override
        public int getIconWidth() {
            return 48;
        }

        @Override
        public void paintIcon(Component c, Graphics graphics, int x, int y) {
            Font font = UIManager.getFont("TextField.font");
            Graphics2D g = (Graphics2D)graphics.create(x, y, this.getIconWidth(), this.getIconHeight());
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setFont(font.deriveFont(1, this.getIconWidth() * 3 / 4));
            g.setColor(Color.green.darker());
            int SW = Math.max(this.getIconWidth() / 10, 4);
            g.setStroke(new BasicStroke(SW));
            g.drawArc(SW / 2, SW / 2, this.getIconWidth() - SW - 1, this.getIconHeight() - SW - 1, 0, 360);
            Rectangle2D bounds = font.getStringBounds("i", g.getFontRenderContext());
            g.drawString("i", (float)Math.round(((double)this.getIconWidth() - bounds.getWidth()) / 2.0 - (double)(this.getIconWidth() / 12)), (float)((long)(SW / 2) + Math.round(((double)this.getIconHeight() - bounds.getHeight()) / 2.0 - bounds.getY() + (double)(this.getIconHeight() / 8))));
            g.dispose();
        }
    }
}

