/*
 * Copyright (c) 2010-2011, Jan Friesse <honzaf@users.sourceforge.net>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _OPT_H_
#define _OPT_H_

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Option for DHCP Message type
 */
enum opt_msg_type {
	OPT_MSG_TYPE_NONE	= 0,
	OPT_MSG_TYPE_DISCOVER	= 1,
	OPT_MSG_TYPE_OFFER	= 2,
	OPT_MSG_TYPE_REQUEST	= 3,
	OPT_MSG_TYPE_DECLINE	= 4,
	OPT_MSG_TYPE_ACK	= 5,
	OPT_MSG_TYPE_NAK	= 6,
	OPT_MSG_TYPE_RELEASE	= 7,
	OPT_MSG_TYPE_UNKNOWN	= 8,
};

/*
 * Option overload option
 */
enum opt_overload {
	OPT_OVERLOAD_NONE	= 0,
	OPT_OVERLOAD_FILE	= 1,
	OPT_OVERLOAD_SNAME	= 2,
	OPT_OVERLOAD_BOTH	= 3,
};

extern void	opt_decode(uint8_t opt, uint8_t opt_len, const char *msg_p,
    int *end_reached, enum opt_msg_type *msg_type, enum opt_overload *overload,
    int verbose);

#ifdef __cplusplus
}
#endif

#endif /* _OPT_H_ */
