---
title: Hamcrest Related Projects
layout: default
---
[Java Hamcrest Home](index)

# Related Projects

Here are some projects that provide additional features and matchers

* [Awaitility](https://github.com/jayway/awaitility) (a DSL that allows you to express expectations of an asynchronous system in a concise and easy to read manner)
* [EZ Testing](https://github.com/EZGames/ez-testing) (contains base classes for defining chainable matchers that have a similar style to AssertJ)
* [Hamcrest 1.3 Utility Matchers](https://github.com/NitorCreations/matchers) (Java matchers like CollectionMatchers, MapMatchers, FieldMatcher, SerializableMatcher etc)
* [Hamcrest auto matcher](https://github.com/itsallcode/hamcrest-auto-matcher) (uses reflection to automatically match model classes)
* [Hamcrest avro](https://github.com/Byhiras/avro-utils)
* [Hamcrest Composites](https://github.com/Cornutum/hamcrest-composites) (for comparing complex Java objects with better testability)
* [Hamcrest Date](https://github.com/modularit/hamcrest-date) (for comparing dates)
* [Hamcrest HAR](https://github.com/roydekleijn/har-assert) (for HTTP archive files)
* [Hamcrest Java Extras](https://github.com/sf105/hamcrest-java-extras) (currently only a couple of Json matchers)
* [Hamcrest JSON](https://github.com/hertzsprung/hamcrest-json) (for comparing entire JSON documents)
* [Hamcrest Mail](https://github.com/devopsix/hamcrest-mail) (for comparing types from the `javax.mail` package)
* [Hamcrest Path](https://github.com/seinesoftware/hamcrest-path) (for testing path existence and permissions) 
* [Hamcrest Querydsl](https://github.com/beloglazov/hamcrest-querydsl) (for checking query results: hasResultSize, hasColumnRange, hasColumnMax, hasColumnMin, hasColumnContainingAll, hasColumnContainingAny)
* [Hamcrest Result Set Matcher](https://github.com/exasol/hamcrest-resultset-matcher) (comparing JDBC result set against each other or structures)
* [Hamcrest Text Patterns](http://code.google.com/p/hamcrest-text-patterns/)
* [hamcrest-pojo-matcher-generator](https://github.com/yandex-qatools/hamcrest-pojo-matcher-generator) (Annotation processor to generate feature-matchers based on your POJOs)
* [http-matchers](https://github.com/valid4j/http-matchers) (Matchers to test your web service via the standard Java API for RESTful Services (JAX-RS))
* [json-path-matchers](https://github.com/jayway/JsonPath/tree/master/json-path-assert) (for evaluating JSON path expressions)
* [JsonUnit](https://github.com/lukas-krecan/JsonUnit) (for comparing JSON structures jsonEquals, jsonPartEquals)
* [Proboscis](https://github.com/sf105/proboscis) (a tiny java library for polling for a result, originally intended for tested asynchronous systems)
* [Shazamcrest](https://github.com/shazam/shazamcrest) (Matchers for beans with custom field matching and nice failure messages)
* [Spotify's hamcrest matchers](https://github.com/spotify/java-hamcrest) (Matchers for POJOs, JSON, and some of the types introduced in Java 8)
* [valid4j](https://github.com/valid4j/valid4j) (assertion and validation library, i.e supporting design-by-contract style and/or recoverable input validation)
