/* filelock.c Lock and unlock a file or parts of files.  */
/*
    Copyright (C) 1995-1998 Uwe Ohse

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Contact: uwe@ohse.de, Uwe Ohse @ DU3 (mausnet)
*/

#include "filelock.h"

#if defined(CAN_LOCK_FILES)
int 
lock_region (int fd, int cmd, int typ, off_t offset, int whence, off_t len)
{
	struct flock lock;

	lock.l_type = typ;
	lock.l_start = offset;
	lock.l_len = len;
	lock.l_whence = whence;
	return fcntl (fd, cmd, &lock);
}
#endif

