This directory contains the C# Protocol Buffers runtime library.

Usage
=====

The easiest way how to use C# protobufs is via the `Google.Protobuf`
NuGet package. Just add the NuGet package to your VS project.

You will also want to install the `Google.Protobuf.Tools` NuGet package, which
contains precompiled version of `protoc.exe` and a copy of well known `.proto`
files under the package's `tools` directory.

To generate C# files from your `.proto` files, invoke `protoc` with the
`--csharp_out` option.

Supported platforms
===================

The runtime library is built as a class library, supporting targets of:

- .NET 4.5+ (`net45`)
- .NET Standard 1.1 and 2.0 (`netstandard1.1` and `netstandard2.0`)
- .NET 5+ (`net50`)

You should be able to use Protocol Buffers in Visual Studio 2012 and
all later versions. This includes all code generated by `protoc`,
which only uses features from C# 3 and earlier. When compiling generated
code with old compilers (before C# 7.2) you need to define the
`GOOGLE_PROTOBUF_REFSTRUCT_COMPATIBILITY_MODE` symbol in your project
so that the generated classes don't implement `IBufferMessage`, which uses
`ref struct` types.

Building
========

Open the `src/Google.Protobuf.sln` solution in Visual Studio 2022 or
later.

Although *users* of this project are only expected to have Visual
Studio 2012 or later, *developers* of the library are required to
have Visual Studio 2022 or later, as the library uses C# 10 features
in its implementation and runs tests under .NET 6. These features
have no impact when using the compiled code - they're only relevant
when building the `Google.Protobuf` assembly.

Testing
=======

The unit tests use [NUnit 3](https://github.com/nunit/nunit). Tests can be
run using the Visual Studio Test Explorer or `dotnet test`.

.NET 3.5
========

We don't support .NET 3.5. It *used* to be feasible to build this library
targeting .NET 3.5, but a number of changes requiring newer runtime/framework
features have been added over time. While it would no doubt be *possible* to
rework the current implementation to allow most of the functionality to be built
in .NET 3.5, this would create an undue maintenance burden.

History of C# protobufs
=======================

This subtree was originally imported from https://github.com/jskeet/protobuf-csharp-port
and represents the latest development version of C# protobufs, that will now be developed
and maintained by Google. All the development will be done in open, under this repository
(https://github.com/protocolbuffers/protobuf).

The previous project differs from this project in a number of ways:

- The old code only supported proto2; the new code initially only supported
proto3 (so no unknown fields, no required/optional distinction, no
extensions); since then proto2 support has been added
- The old code was based on immutable message types and builders for
them
- The old code did not support maps or `oneof`
- The old code had its own JSON representation, whereas the new code
uses the standard protobuf JSON representation
- The old code had no notion of the "well-known types" which have
special support in the new code
- The old project supported some older platforms (such as older
versions of Silverlight) which are not currently supported in the
new project
