// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package kmsinventory provides access to the KMS Inventory API.
//
// For product documentation, see: https://cloud.google.com/kms/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/kmsinventory/v1"
//	...
//	ctx := context.Background()
//	kmsinventoryService, err := kmsinventory.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	kmsinventoryService, err := kmsinventory.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	kmsinventoryService, err := kmsinventory.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package kmsinventory // import "google.golang.org/api/kmsinventory/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "kmsinventory:v1"
const apiName = "kmsinventory"
const apiVersion = "v1"
const basePath = "https://kmsinventory.googleapis.com/"
const basePathTemplate = "https://kmsinventory.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://kmsinventory.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.ProtectedResources = NewOrganizationsProtectedResourcesService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	ProtectedResources *OrganizationsProtectedResourcesService
}

func NewOrganizationsProtectedResourcesService(s *Service) *OrganizationsProtectedResourcesService {
	rs := &OrganizationsProtectedResourcesService{s: s}
	return rs
}

type OrganizationsProtectedResourcesService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.CryptoKeys = NewProjectsCryptoKeysService(s)
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	CryptoKeys *ProjectsCryptoKeysService

	Locations *ProjectsLocationsService
}

func NewProjectsCryptoKeysService(s *Service) *ProjectsCryptoKeysService {
	rs := &ProjectsCryptoKeysService{s: s}
	return rs
}

type ProjectsCryptoKeysService struct {
	s *Service
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.KeyRings = NewProjectsLocationsKeyRingsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	KeyRings *ProjectsLocationsKeyRingsService
}

func NewProjectsLocationsKeyRingsService(s *Service) *ProjectsLocationsKeyRingsService {
	rs := &ProjectsLocationsKeyRingsService{s: s}
	rs.CryptoKeys = NewProjectsLocationsKeyRingsCryptoKeysService(s)
	return rs
}

type ProjectsLocationsKeyRingsService struct {
	s *Service

	CryptoKeys *ProjectsLocationsKeyRingsCryptoKeysService
}

func NewProjectsLocationsKeyRingsCryptoKeysService(s *Service) *ProjectsLocationsKeyRingsCryptoKeysService {
	rs := &ProjectsLocationsKeyRingsCryptoKeysService{s: s}
	return rs
}

type ProjectsLocationsKeyRingsCryptoKeysService struct {
	s *Service
}

// GoogleCloudKmsInventoryV1ListCryptoKeysResponse: Response message for
// KeyDashboardService.ListCryptoKeys.
type GoogleCloudKmsInventoryV1ListCryptoKeysResponse struct {
	// CryptoKeys: The list of CryptoKeys.
	CryptoKeys []*GoogleCloudKmsV1CryptoKey `json:"cryptoKeys,omitempty"`
	// NextPageToken: The page token returned from the previous response if the
	// next page is desired.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CryptoKeys") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CryptoKeys") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsInventoryV1ListCryptoKeysResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsInventoryV1ListCryptoKeysResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsInventoryV1ProtectedResource: Metadata about a resource
// protected by a Cloud KMS key.
type GoogleCloudKmsInventoryV1ProtectedResource struct {
	// CloudProduct: The Cloud product that owns the resource. Example: `compute`
	CloudProduct string `json:"cloudProduct,omitempty"`
	// CreateTime: Output only. The time at which this resource was created. The
	// granularity is in seconds. Timestamp.nanos will always be 0.
	CreateTime string `json:"createTime,omitempty"`
	// CryptoKeyVersion: The name of the Cloud KMS CryptoKeyVersion
	// (https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
	// used to protect this resource via CMEK. This field is empty if the Google
	// Cloud product owning the resource does not provide key version data to Asset
	// Inventory. If there are multiple key versions protecting the resource, then
	// this is same value as the first element of crypto_key_versions.
	CryptoKeyVersion string `json:"cryptoKeyVersion,omitempty"`
	// CryptoKeyVersions: The names of the Cloud KMS CryptoKeyVersion
	// (https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys.cryptoKeyVersions?hl=en)
	// used to protect this resource via CMEK. This field is empty if the Google
	// Cloud product owning the resource does not provide key versions data to
	// Asset Inventory. The first element of this field is stored in
	// crypto_key_version.
	CryptoKeyVersions []string `json:"cryptoKeyVersions,omitempty"`
	// Labels: A key-value pair of the resource's labels (v1) to their values.
	Labels map[string]string `json:"labels,omitempty"`
	// Location: Location can be `global`, regional like `us-east1`, or zonal like
	// `us-west1-b`.
	Location string `json:"location,omitempty"`
	// Name: The full resource name of the resource. Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/insta
	// nce1`.
	Name string `json:"name,omitempty"`
	// Project: Format: `projects/{PROJECT_NUMBER}`.
	Project string `json:"project,omitempty"`
	// ProjectId: The ID of the project that owns the resource.
	ProjectId string `json:"projectId,omitempty"`
	// ResourceType: Example: `compute.googleapis.com/Disk`
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudProduct") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudProduct") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsInventoryV1ProtectedResource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsInventoryV1ProtectedResource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsInventoryV1ProtectedResourcesSummary: Aggregate information
// about the resources protected by a Cloud KMS key in the same Cloud
// organization as the key.
type GoogleCloudKmsInventoryV1ProtectedResourcesSummary struct {
	// CloudProducts: The number of resources protected by the key grouped by Cloud
	// product.
	CloudProducts map[string]string `json:"cloudProducts,omitempty"`
	// Locations: The number of resources protected by the key grouped by region.
	Locations map[string]string `json:"locations,omitempty"`
	// Name: The full name of the ProtectedResourcesSummary resource. Example:
	// projects/test-project/locations/us/keyRings/test-keyring/cryptoKeys/test-key/
	// protectedResourcesSummary
	Name string `json:"name,omitempty"`
	// ProjectCount: The number of distinct Cloud projects in the same Cloud
	// organization as the key that have resources protected by the key.
	ProjectCount int64 `json:"projectCount,omitempty"`
	// ResourceCount: The total number of protected resources in the same Cloud
	// organization as the key.
	ResourceCount int64 `json:"resourceCount,omitempty,string"`
	// ResourceTypes: The number of resources protected by the key grouped by
	// resource type.
	ResourceTypes map[string]string `json:"resourceTypes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CloudProducts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudProducts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsInventoryV1ProtectedResourcesSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsInventoryV1ProtectedResourcesSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse: Response message
// for KeyTrackingService.SearchProtectedResources.
type GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// ProtectedResources: Protected resources for this page.
	ProtectedResources []*GoogleCloudKmsInventoryV1ProtectedResource `json:"protectedResources,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1CryptoKey: A CryptoKey represents a logical key that can be
// used for cryptographic operations. A CryptoKey is made up of zero or more
// versions, which represent the actual key material used in cryptographic
// operations.
type GoogleCloudKmsV1CryptoKey struct {
	// CreateTime: Output only. The time at which this CryptoKey was created.
	CreateTime string `json:"createTime,omitempty"`
	// CryptoKeyBackend: Immutable. The resource name of the backend environment
	// where the key material for all CryptoKeyVersions associated with this
	// CryptoKey reside and where all related cryptographic operations are
	// performed. Only applicable if CryptoKeyVersions have a ProtectionLevel of
	// EXTERNAL_VPC, with the resource name in the format
	// `projects/*/locations/*/ekmConnections/*`. Note, this list is non-exhaustive
	// and may apply to additional ProtectionLevels in the future.
	CryptoKeyBackend string `json:"cryptoKeyBackend,omitempty"`
	// DestroyScheduledDuration: Immutable. The period of time that versions of
	// this key spend in the DESTROY_SCHEDULED state before transitioning to
	// DESTROYED. If not specified at creation time, the default duration is 30
	// days.
	DestroyScheduledDuration string `json:"destroyScheduledDuration,omitempty"`
	// ImportOnly: Immutable. Whether this key may contain imported versions only.
	ImportOnly bool `json:"importOnly,omitempty"`
	// KeyAccessJustificationsPolicy: Optional. The policy used for Key Access
	// Justifications Policy Enforcement. If this field is present and this key is
	// enrolled in Key Access Justifications Policy Enforcement, the policy will be
	// evaluated in encrypt, decrypt, and sign operations, and the operation will
	// fail if rejected by the policy. The policy is defined by specifying zero or
	// more allowed justification codes.
	// https://cloud.google.com/assured-workloads/key-access-justifications/docs/justification-codes
	// By default, this field is absent, and all justification codes are allowed.
	KeyAccessJustificationsPolicy *GoogleCloudKmsV1KeyAccessJustificationsPolicy `json:"keyAccessJustificationsPolicy,omitempty"`
	// Labels: Labels with user-defined metadata. For more information, see
	// Labeling Keys (https://cloud.google.com/kms/docs/labeling-keys).
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name for this CryptoKey in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`.
	Name string `json:"name,omitempty"`
	// NextRotationTime: At next_rotation_time, the Key Management Service will
	// automatically: 1. Create a new version of this CryptoKey. 2. Mark the new
	// version as primary. Key rotations performed manually via
	// CreateCryptoKeyVersion and UpdateCryptoKeyPrimaryVersion do not affect
	// next_rotation_time. Keys with purpose ENCRYPT_DECRYPT support automatic
	// rotation. For other keys, this field must be omitted.
	NextRotationTime string `json:"nextRotationTime,omitempty"`
	// Primary: Output only. A copy of the "primary" CryptoKeyVersion that will be
	// used by Encrypt when this CryptoKey is given in EncryptRequest.name. The
	// CryptoKey's primary version can be updated via
	// UpdateCryptoKeyPrimaryVersion. Keys with purpose ENCRYPT_DECRYPT may have a
	// primary. For other keys, this field will be omitted.
	Primary *GoogleCloudKmsV1CryptoKeyVersion `json:"primary,omitempty"`
	// Purpose: Immutable. The immutable purpose of this CryptoKey.
	//
	// Possible values:
	//   "CRYPTO_KEY_PURPOSE_UNSPECIFIED" - Not specified.
	//   "ENCRYPT_DECRYPT" - CryptoKeys with this purpose may be used with Encrypt
	// and Decrypt.
	//   "ASYMMETRIC_SIGN" - CryptoKeys with this purpose may be used with
	// AsymmetricSign and GetPublicKey.
	//   "ASYMMETRIC_DECRYPT" - CryptoKeys with this purpose may be used with
	// AsymmetricDecrypt and GetPublicKey.
	//   "RAW_ENCRYPT_DECRYPT" - CryptoKeys with this purpose may be used with
	// RawEncrypt and RawDecrypt. This purpose is meant to be used for
	// interoperable symmetric encryption and does not support automatic CryptoKey
	// rotation.
	//   "MAC" - CryptoKeys with this purpose may be used with MacSign.
	Purpose string `json:"purpose,omitempty"`
	// RotationPeriod: next_rotation_time will be advanced by this period when the
	// service automatically rotates a key. Must be at least 24 hours and at most
	// 876,000 hours. If rotation_period is set, next_rotation_time must also be
	// set. Keys with purpose ENCRYPT_DECRYPT support automatic rotation. For other
	// keys, this field must be omitted.
	RotationPeriod string `json:"rotationPeriod,omitempty"`
	// VersionTemplate: A template describing settings for new CryptoKeyVersion
	// instances. The properties of new CryptoKeyVersion instances created by
	// either CreateCryptoKeyVersion or auto-rotation are controlled by this
	// template.
	VersionTemplate *GoogleCloudKmsV1CryptoKeyVersionTemplate `json:"versionTemplate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1CryptoKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1CryptoKey
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1CryptoKeyVersion: A CryptoKeyVersion represents an
// individual cryptographic key, and the associated key material. An ENABLED
// version can be used for cryptographic operations. For security reasons, the
// raw cryptographic key material represented by a CryptoKeyVersion can never
// be viewed or exported. It can only be used to encrypt, decrypt, or sign data
// when an authorized user or application invokes Cloud KMS.
type GoogleCloudKmsV1CryptoKeyVersion struct {
	// Algorithm: Output only. The CryptoKeyVersionAlgorithm that this
	// CryptoKeyVersion supports.
	//
	// Possible values:
	//   "CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED" - Not specified.
	//   "GOOGLE_SYMMETRIC_ENCRYPTION" - Creates symmetric encryption keys.
	//   "AES_128_GCM" - AES-GCM (Galois Counter Mode) using 128-bit keys.
	//   "AES_256_GCM" - AES-GCM (Galois Counter Mode) using 256-bit keys.
	//   "AES_128_CBC" - AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
	//   "AES_256_CBC" - AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
	//   "AES_128_CTR" - AES-CTR (Counter Mode) using 128-bit keys.
	//   "AES_256_CTR" - AES-CTR (Counter Mode) using 256-bit keys.
	//   "RSA_SIGN_PSS_2048_SHA256" - RSASSA-PSS 2048 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_3072_SHA256" - RSASSA-PSS 3072 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_4096_SHA256" - RSASSA-PSS 4096 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_4096_SHA512" - RSASSA-PSS 4096 bit key with a SHA512 digest.
	//   "RSA_SIGN_PKCS1_2048_SHA256" - RSASSA-PKCS1-v1_5 with a 2048 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_3072_SHA256" - RSASSA-PKCS1-v1_5 with a 3072 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA256" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA512" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA512 digest.
	//   "RSA_SIGN_RAW_PKCS1_2048" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 2048 bit key.
	//   "RSA_SIGN_RAW_PKCS1_3072" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 3072 bit key.
	//   "RSA_SIGN_RAW_PKCS1_4096" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 4096 bit key.
	//   "RSA_DECRYPT_OAEP_2048_SHA256" - RSAES-OAEP 2048 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_3072_SHA256" - RSAES-OAEP 3072 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA256" - RSAES-OAEP 4096 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA512" - RSAES-OAEP 4096 bit key with a SHA512
	// digest.
	//   "RSA_DECRYPT_OAEP_2048_SHA1" - RSAES-OAEP 2048 bit key with a SHA1 digest.
	//   "RSA_DECRYPT_OAEP_3072_SHA1" - RSAES-OAEP 3072 bit key with a SHA1 digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA1" - RSAES-OAEP 4096 bit key with a SHA1 digest.
	//   "EC_SIGN_P256_SHA256" - ECDSA on the NIST P-256 curve with a SHA256
	// digest. Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_P384_SHA384" - ECDSA on the NIST P-384 curve with a SHA384
	// digest. Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_SECP256K1_SHA256" - ECDSA on the non-NIST secp256k1 curve. This
	// curve is only supported for HSM protection level. Other hash functions can
	// also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_ED25519" - EdDSA on the Curve25519 in pure mode (taking data as
	// input).
	//   "HMAC_SHA256" - HMAC-SHA256 signing with a 256 bit key.
	//   "HMAC_SHA1" - HMAC-SHA1 signing with a 160 bit key.
	//   "HMAC_SHA384" - HMAC-SHA384 signing with a 384 bit key.
	//   "HMAC_SHA512" - HMAC-SHA512 signing with a 512 bit key.
	//   "HMAC_SHA224" - HMAC-SHA224 signing with a 224 bit key.
	//   "EXTERNAL_SYMMETRIC_ENCRYPTION" - Algorithm representing symmetric
	// encryption by an external key manager.
	//   "PQ_SIGN_ML_DSA_65" - The post-quantum Module-Lattice-Based Digital
	// Signature Algorithm, at security level 3. Randomized version.
	//   "PQ_SIGN_SLH_DSA_SHA2_128S" - The post-quantum stateless hash-based
	// digital signature algorithm, at security level 1. Randomized version.
	//   "PQ_SIGN_HASH_SLH_DSA_SHA2_128S_SHA256" - The post-quantum stateless
	// hash-based digital signature algorithm, at security level 1. Randomized
	// pre-hash version supporting SHA256 digests.
	Algorithm string `json:"algorithm,omitempty"`
	// Attestation: Output only. Statement that was generated and signed by the HSM
	// at key creation time. Use this statement to verify attributes of the key as
	// stored on the HSM, independently of Google. Only provided for key versions
	// with protection_level HSM.
	Attestation *GoogleCloudKmsV1KeyOperationAttestation `json:"attestation,omitempty"`
	// CreateTime: Output only. The time at which this CryptoKeyVersion was
	// created.
	CreateTime string `json:"createTime,omitempty"`
	// DestroyEventTime: Output only. The time this CryptoKeyVersion's key material
	// was destroyed. Only present if state is DESTROYED.
	DestroyEventTime string `json:"destroyEventTime,omitempty"`
	// DestroyTime: Output only. The time this CryptoKeyVersion's key material is
	// scheduled for destruction. Only present if state is DESTROY_SCHEDULED.
	DestroyTime string `json:"destroyTime,omitempty"`
	// ExternalDestructionFailureReason: Output only. The root cause of the most
	// recent external destruction failure. Only present if state is
	// EXTERNAL_DESTRUCTION_FAILED.
	ExternalDestructionFailureReason string `json:"externalDestructionFailureReason,omitempty"`
	// ExternalProtectionLevelOptions: ExternalProtectionLevelOptions stores a
	// group of additional fields for configuring a CryptoKeyVersion that are
	// specific to the EXTERNAL protection level and EXTERNAL_VPC protection
	// levels.
	ExternalProtectionLevelOptions *GoogleCloudKmsV1ExternalProtectionLevelOptions `json:"externalProtectionLevelOptions,omitempty"`
	// GenerateTime: Output only. The time this CryptoKeyVersion's key material was
	// generated.
	GenerateTime string `json:"generateTime,omitempty"`
	// GenerationFailureReason: Output only. The root cause of the most recent
	// generation failure. Only present if state is GENERATION_FAILED.
	GenerationFailureReason string `json:"generationFailureReason,omitempty"`
	// ImportFailureReason: Output only. The root cause of the most recent import
	// failure. Only present if state is IMPORT_FAILED.
	ImportFailureReason string `json:"importFailureReason,omitempty"`
	// ImportJob: Output only. The name of the ImportJob used in the most recent
	// import of this CryptoKeyVersion. Only present if the underlying key material
	// was imported.
	ImportJob string `json:"importJob,omitempty"`
	// ImportTime: Output only. The time at which this CryptoKeyVersion's key
	// material was most recently imported.
	ImportTime string `json:"importTime,omitempty"`
	// Name: Output only. The resource name for this CryptoKeyVersion in the format
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*/cryptoKeyVersions/*`.
	Name string `json:"name,omitempty"`
	// ProtectionLevel: Output only. The ProtectionLevel describing how crypto
	// operations are performed with this CryptoKeyVersion.
	//
	// Possible values:
	//   "PROTECTION_LEVEL_UNSPECIFIED" - Not specified.
	//   "SOFTWARE" - Crypto operations are performed in software.
	//   "HSM" - Crypto operations are performed in a Hardware Security Module.
	//   "EXTERNAL" - Crypto operations are performed by an external key manager.
	//   "EXTERNAL_VPC" - Crypto operations are performed in an EKM-over-VPC
	// backend.
	ProtectionLevel string `json:"protectionLevel,omitempty"`
	// ReimportEligible: Output only. Whether or not this key version is eligible
	// for reimport, by being specified as a target in
	// ImportCryptoKeyVersionRequest.crypto_key_version.
	ReimportEligible bool `json:"reimportEligible,omitempty"`
	// State: The current state of the CryptoKeyVersion.
	//
	// Possible values:
	//   "CRYPTO_KEY_VERSION_STATE_UNSPECIFIED" - Not specified.
	//   "PENDING_GENERATION" - This version is still being generated. It may not
	// be used, enabled, disabled, or destroyed yet. Cloud KMS will automatically
	// mark this version ENABLED as soon as the version is ready.
	//   "ENABLED" - This version may be used for cryptographic operations.
	//   "DISABLED" - This version may not be used, but the key material is still
	// available, and the version can be placed back into the ENABLED state.
	//   "DESTROYED" - The key material of this version is destroyed and no longer
	// stored. This version may only become ENABLED again if this version is
	// reimport_eligible and the original key material is reimported with a call to
	// KeyManagementService.ImportCryptoKeyVersion.
	//   "DESTROY_SCHEDULED" - This version is scheduled for destruction, and will
	// be destroyed soon. Call RestoreCryptoKeyVersion to put it back into the
	// DISABLED state.
	//   "PENDING_IMPORT" - This version is still being imported. It may not be
	// used, enabled, disabled, or destroyed yet. Cloud KMS will automatically mark
	// this version ENABLED as soon as the version is ready.
	//   "IMPORT_FAILED" - This version was not imported successfully. It may not
	// be used, enabled, disabled, or destroyed. The submitted key material has
	// been discarded. Additional details can be found in
	// CryptoKeyVersion.import_failure_reason.
	//   "GENERATION_FAILED" - This version was not generated successfully. It may
	// not be used, enabled, disabled, or destroyed. Additional details can be
	// found in CryptoKeyVersion.generation_failure_reason.
	//   "PENDING_EXTERNAL_DESTRUCTION" - This version was destroyed, and it may
	// not be used or enabled again. Cloud KMS is waiting for the corresponding key
	// material residing in an external key manager to be destroyed.
	//   "EXTERNAL_DESTRUCTION_FAILED" - This version was destroyed, and it may not
	// be used or enabled again. However, Cloud KMS could not confirm that the
	// corresponding key material residing in an external key manager was
	// destroyed. Additional details can be found in
	// CryptoKeyVersion.external_destruction_failure_reason.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1CryptoKeyVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1CryptoKeyVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1CryptoKeyVersionTemplate: A CryptoKeyVersionTemplate
// specifies the properties to use when creating a new CryptoKeyVersion, either
// manually with CreateCryptoKeyVersion or automatically as a result of
// auto-rotation.
type GoogleCloudKmsV1CryptoKeyVersionTemplate struct {
	// Algorithm: Required. Algorithm to use when creating a CryptoKeyVersion based
	// on this template. For backwards compatibility, GOOGLE_SYMMETRIC_ENCRYPTION
	// is implied if both this field is omitted and CryptoKey.purpose is
	// ENCRYPT_DECRYPT.
	//
	// Possible values:
	//   "CRYPTO_KEY_VERSION_ALGORITHM_UNSPECIFIED" - Not specified.
	//   "GOOGLE_SYMMETRIC_ENCRYPTION" - Creates symmetric encryption keys.
	//   "AES_128_GCM" - AES-GCM (Galois Counter Mode) using 128-bit keys.
	//   "AES_256_GCM" - AES-GCM (Galois Counter Mode) using 256-bit keys.
	//   "AES_128_CBC" - AES-CBC (Cipher Block Chaining Mode) using 128-bit keys.
	//   "AES_256_CBC" - AES-CBC (Cipher Block Chaining Mode) using 256-bit keys.
	//   "AES_128_CTR" - AES-CTR (Counter Mode) using 128-bit keys.
	//   "AES_256_CTR" - AES-CTR (Counter Mode) using 256-bit keys.
	//   "RSA_SIGN_PSS_2048_SHA256" - RSASSA-PSS 2048 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_3072_SHA256" - RSASSA-PSS 3072 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_4096_SHA256" - RSASSA-PSS 4096 bit key with a SHA256 digest.
	//   "RSA_SIGN_PSS_4096_SHA512" - RSASSA-PSS 4096 bit key with a SHA512 digest.
	//   "RSA_SIGN_PKCS1_2048_SHA256" - RSASSA-PKCS1-v1_5 with a 2048 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_3072_SHA256" - RSASSA-PKCS1-v1_5 with a 3072 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA256" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA256 digest.
	//   "RSA_SIGN_PKCS1_4096_SHA512" - RSASSA-PKCS1-v1_5 with a 4096 bit key and a
	// SHA512 digest.
	//   "RSA_SIGN_RAW_PKCS1_2048" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 2048 bit key.
	//   "RSA_SIGN_RAW_PKCS1_3072" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 3072 bit key.
	//   "RSA_SIGN_RAW_PKCS1_4096" - RSASSA-PKCS1-v1_5 signing without encoding,
	// with a 4096 bit key.
	//   "RSA_DECRYPT_OAEP_2048_SHA256" - RSAES-OAEP 2048 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_3072_SHA256" - RSAES-OAEP 3072 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA256" - RSAES-OAEP 4096 bit key with a SHA256
	// digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA512" - RSAES-OAEP 4096 bit key with a SHA512
	// digest.
	//   "RSA_DECRYPT_OAEP_2048_SHA1" - RSAES-OAEP 2048 bit key with a SHA1 digest.
	//   "RSA_DECRYPT_OAEP_3072_SHA1" - RSAES-OAEP 3072 bit key with a SHA1 digest.
	//   "RSA_DECRYPT_OAEP_4096_SHA1" - RSAES-OAEP 4096 bit key with a SHA1 digest.
	//   "EC_SIGN_P256_SHA256" - ECDSA on the NIST P-256 curve with a SHA256
	// digest. Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_P384_SHA384" - ECDSA on the NIST P-384 curve with a SHA384
	// digest. Other hash functions can also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_SECP256K1_SHA256" - ECDSA on the non-NIST secp256k1 curve. This
	// curve is only supported for HSM protection level. Other hash functions can
	// also be used:
	// https://cloud.google.com/kms/docs/create-validate-signatures#ecdsa_support_for_other_hash_algorithms
	//   "EC_SIGN_ED25519" - EdDSA on the Curve25519 in pure mode (taking data as
	// input).
	//   "HMAC_SHA256" - HMAC-SHA256 signing with a 256 bit key.
	//   "HMAC_SHA1" - HMAC-SHA1 signing with a 160 bit key.
	//   "HMAC_SHA384" - HMAC-SHA384 signing with a 384 bit key.
	//   "HMAC_SHA512" - HMAC-SHA512 signing with a 512 bit key.
	//   "HMAC_SHA224" - HMAC-SHA224 signing with a 224 bit key.
	//   "EXTERNAL_SYMMETRIC_ENCRYPTION" - Algorithm representing symmetric
	// encryption by an external key manager.
	//   "PQ_SIGN_ML_DSA_65" - The post-quantum Module-Lattice-Based Digital
	// Signature Algorithm, at security level 3. Randomized version.
	//   "PQ_SIGN_SLH_DSA_SHA2_128S" - The post-quantum stateless hash-based
	// digital signature algorithm, at security level 1. Randomized version.
	//   "PQ_SIGN_HASH_SLH_DSA_SHA2_128S_SHA256" - The post-quantum stateless
	// hash-based digital signature algorithm, at security level 1. Randomized
	// pre-hash version supporting SHA256 digests.
	Algorithm string `json:"algorithm,omitempty"`
	// ProtectionLevel: ProtectionLevel to use when creating a CryptoKeyVersion
	// based on this template. Immutable. Defaults to SOFTWARE.
	//
	// Possible values:
	//   "PROTECTION_LEVEL_UNSPECIFIED" - Not specified.
	//   "SOFTWARE" - Crypto operations are performed in software.
	//   "HSM" - Crypto operations are performed in a Hardware Security Module.
	//   "EXTERNAL" - Crypto operations are performed by an external key manager.
	//   "EXTERNAL_VPC" - Crypto operations are performed in an EKM-over-VPC
	// backend.
	ProtectionLevel string `json:"protectionLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Algorithm") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1CryptoKeyVersionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1CryptoKeyVersionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1ExternalProtectionLevelOptions:
// ExternalProtectionLevelOptions stores a group of additional fields for
// configuring a CryptoKeyVersion that are specific to the EXTERNAL protection
// level and EXTERNAL_VPC protection levels.
type GoogleCloudKmsV1ExternalProtectionLevelOptions struct {
	// EkmConnectionKeyPath: The path to the external key material on the EKM when
	// using EkmConnection e.g., "v0/my/key". Set this field instead of
	// external_key_uri when using an EkmConnection.
	EkmConnectionKeyPath string `json:"ekmConnectionKeyPath,omitempty"`
	// ExternalKeyUri: The URI for an external resource that this CryptoKeyVersion
	// represents.
	ExternalKeyUri string `json:"externalKeyUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EkmConnectionKeyPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EkmConnectionKeyPath") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1ExternalProtectionLevelOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1ExternalProtectionLevelOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1KeyAccessJustificationsPolicy: A
// KeyAccessJustificationsPolicy specifies zero or more allowed AccessReason
// values for encrypt, decrypt, and sign operations on a CryptoKey.
type GoogleCloudKmsV1KeyAccessJustificationsPolicy struct {
	// AllowedAccessReasons: The list of allowed reasons for access to a CryptoKey.
	// Zero allowed access reasons means all encrypt, decrypt, and sign operations
	// for the CryptoKey associated with this policy will fail.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - Unspecified access reason.
	//   "CUSTOMER_INITIATED_SUPPORT" - Customer-initiated support.
	//   "GOOGLE_INITIATED_SERVICE" - Google-initiated access for system management
	// and troubleshooting.
	//   "THIRD_PARTY_DATA_REQUEST" - Google-initiated access in response to a
	// legal request or legal process.
	//   "GOOGLE_INITIATED_REVIEW" - Google-initiated access for security, fraud,
	// abuse, or compliance purposes.
	//   "CUSTOMER_INITIATED_ACCESS" - Customer uses their account to perform any
	// access to their own data which their IAM policy authorizes.
	//   "GOOGLE_INITIATED_SYSTEM_OPERATION" - Google systems access customer data
	// to help optimize the structure of the data or quality for future uses by the
	// customer.
	//   "REASON_NOT_EXPECTED" - No reason is expected for this key request.
	//   "MODIFIED_CUSTOMER_INITIATED_ACCESS" - Customer uses their account to
	// perform any access to their own data which their IAM policy authorizes, and
	// one of the following is true: * A Google administrator has reset the
	// root-access account associated with the user's organization within the past
	// 7 days. * A Google-initiated emergency access operation has interacted with
	// a resource in the same project or folder as the currently accessed resource
	// within the past 7 days.
	//   "MODIFIED_GOOGLE_INITIATED_SYSTEM_OPERATION" - Google systems access
	// customer data to help optimize the structure of the data or quality for
	// future uses by the customer, and one of the following is true: * A Google
	// administrator has reset the root-access account associated with the user's
	// organization within the past 7 days. * A Google-initiated emergency access
	// operation has interacted with a resource in the same project or folder as
	// the currently accessed resource within the past 7 days.
	//   "GOOGLE_RESPONSE_TO_PRODUCTION_ALERT" - Google-initiated access to
	// maintain system reliability.
	//   "CUSTOMER_AUTHORIZED_WORKFLOW_SERVICING" - One of the following operations
	// is being executed while simultaneously encountering an internal technical
	// issue which prevented a more precise justification code from being
	// generated: * Your account has been used to perform any access to your own
	// data which your IAM policy authorizes. * An automated Google system operates
	// on encrypted customer data which your IAM policy authorizes. *
	// Customer-initiated Google support access. * Google-initiated support access
	// to protect system reliability.
	AllowedAccessReasons []string `json:"allowedAccessReasons,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedAccessReasons") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedAccessReasons") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1KeyAccessJustificationsPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1KeyAccessJustificationsPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1KeyOperationAttestation: Contains an HSM-generated
// attestation about a key operation. For more information, see [Verifying
// attestations] (https://cloud.google.com/kms/docs/attest-key).
type GoogleCloudKmsV1KeyOperationAttestation struct {
	// CertChains: Output only. The certificate chains needed to validate the
	// attestation
	CertChains *GoogleCloudKmsV1KeyOperationAttestationCertificateChains `json:"certChains,omitempty"`
	// Content: Output only. The attestation data provided by the HSM when the key
	// operation was performed.
	Content string `json:"content,omitempty"`
	// Format: Output only. The format of the attestation data.
	//
	// Possible values:
	//   "ATTESTATION_FORMAT_UNSPECIFIED" - Not specified.
	//   "CAVIUM_V1_COMPRESSED" - Cavium HSM attestation compressed with gzip. Note
	// that this format is defined by Cavium and subject to change at any time. See
	// https://www.marvell.com/products/security-solutions/nitrox-hs-adapters/software-key-attestation.html.
	//   "CAVIUM_V2_COMPRESSED" - Cavium HSM attestation V2 compressed with gzip.
	// This is a new format introduced in Cavium's version 3.2-08.
	Format string `json:"format,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertChains") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertChains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1KeyOperationAttestation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1KeyOperationAttestation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudKmsV1KeyOperationAttestationCertificateChains: Certificate chains
// needed to verify the attestation. Certificates in chains are PEM-encoded and
// are ordered based on https://tools.ietf.org/html/rfc5246#section-7.4.2.
type GoogleCloudKmsV1KeyOperationAttestationCertificateChains struct {
	// CaviumCerts: Cavium certificate chain corresponding to the attestation.
	CaviumCerts []string `json:"caviumCerts,omitempty"`
	// GoogleCardCerts: Google card certificate chain corresponding to the
	// attestation.
	GoogleCardCerts []string `json:"googleCardCerts,omitempty"`
	// GooglePartitionCerts: Google partition certificate chain corresponding to
	// the attestation.
	GooglePartitionCerts []string `json:"googlePartitionCerts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaviumCerts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaviumCerts") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudKmsV1KeyOperationAttestationCertificateChains) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudKmsV1KeyOperationAttestationCertificateChains
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OrganizationsProtectedResourcesSearchCall struct {
	s            *Service
	scope        string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Returns metadata about the resources protected by the given Cloud
// KMS CryptoKey in the given Cloud organization.
//
// - scope: Resource name of the organization. Example: organizations/123.
func (r *OrganizationsProtectedResourcesService) Search(scope string) *OrganizationsProtectedResourcesSearchCall {
	c := &OrganizationsProtectedResourcesSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.scope = scope
	return c
}

// CryptoKey sets the optional parameter "cryptoKey": Required. The resource
// name of the CryptoKey.
func (c *OrganizationsProtectedResourcesSearchCall) CryptoKey(cryptoKey string) *OrganizationsProtectedResourcesSearchCall {
	c.urlParams_.Set("cryptoKey", cryptoKey)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// resources to return. The service may return fewer than this value. If
// unspecified, at most 500 resources will be returned. The maximum value is
// 500; values above 500 will be coerced to 500.
func (c *OrganizationsProtectedResourcesSearchCall) PageSize(pageSize int64) *OrganizationsProtectedResourcesSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous KeyTrackingService.SearchProtectedResources call. Provide
// this to retrieve the subsequent page. When paginating, all other parameters
// provided to KeyTrackingService.SearchProtectedResources must match the call
// that provided the page token.
func (c *OrganizationsProtectedResourcesSearchCall) PageToken(pageToken string) *OrganizationsProtectedResourcesSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ResourceTypes sets the optional parameter "resourceTypes": A list of
// resource types that this request searches for. If empty, it will search all
// the trackable resource types
// (https://cloud.google.com/kms/docs/view-key-usage#tracked-resource-types).
// Regular expressions are also supported. For example: *
// `compute.googleapis.com.*` snapshots resources whose type starts with
// `compute.googleapis.com`. * `.*Image` snapshots resources whose type ends
// with `Image`. * `.*Image.*` snapshots resources whose type contains `Image`.
// See RE2 (https://github.com/google/re2/wiki/Syntax) for all supported
// regular expression syntax. If the regular expression does not match any
// supported resource type, an INVALID_ARGUMENT error will be returned.
func (c *OrganizationsProtectedResourcesSearchCall) ResourceTypes(resourceTypes ...string) *OrganizationsProtectedResourcesSearchCall {
	c.urlParams_.SetMulti("resourceTypes", append([]string{}, resourceTypes...))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OrganizationsProtectedResourcesSearchCall) Fields(s ...googleapi.Field) *OrganizationsProtectedResourcesSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OrganizationsProtectedResourcesSearchCall) IfNoneMatch(entityTag string) *OrganizationsProtectedResourcesSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OrganizationsProtectedResourcesSearchCall) Context(ctx context.Context) *OrganizationsProtectedResourcesSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OrganizationsProtectedResourcesSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsProtectedResourcesSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+scope}/protectedResources:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"scope": c.scope,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "kmsinventory.organizations.protectedResources.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "kmsinventory.organizations.protectedResources.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OrganizationsProtectedResourcesSearchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "kmsinventory.organizations.protectedResources.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsProtectedResourcesSearchCall) Pages(ctx context.Context, f func(*GoogleCloudKmsInventoryV1SearchProtectedResourcesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsCryptoKeysListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Returns cryptographic keys managed by Cloud KMS in a given Cloud
// project. Note that this data is sourced from snapshots, meaning it may not
// completely reflect the actual state of key metadata at call time.
//
//   - parent: The Google Cloud project for which to retrieve key metadata, in
//     the format `projects/*`.
func (r *ProjectsCryptoKeysService) List(parent string) *ProjectsCryptoKeysListCall {
	c := &ProjectsCryptoKeysListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of keys
// to return. The service may return fewer than this value. If unspecified, at
// most 1000 keys will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *ProjectsCryptoKeysListCall) PageSize(pageSize int64) *ProjectsCryptoKeysListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Pass this into a
// subsequent request in order to receive the next page of results.
func (c *ProjectsCryptoKeysListCall) PageToken(pageToken string) *ProjectsCryptoKeysListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsCryptoKeysListCall) Fields(s ...googleapi.Field) *ProjectsCryptoKeysListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsCryptoKeysListCall) IfNoneMatch(entityTag string) *ProjectsCryptoKeysListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsCryptoKeysListCall) Context(ctx context.Context) *ProjectsCryptoKeysListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsCryptoKeysListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsCryptoKeysListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/cryptoKeys")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "kmsinventory.projects.cryptoKeys.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "kmsinventory.projects.cryptoKeys.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudKmsInventoryV1ListCryptoKeysResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsCryptoKeysListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudKmsInventoryV1ListCryptoKeysResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudKmsInventoryV1ListCryptoKeysResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "kmsinventory.projects.cryptoKeys.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsCryptoKeysListCall) Pages(ctx context.Context, f func(*GoogleCloudKmsInventoryV1ListCryptoKeysResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetProtectedResourcesSummary: Returns aggregate information about the
// resources protected by the given Cloud KMS CryptoKey. Only resources within
// the same Cloud organization as the key will be returned. The project that
// holds the key must be part of an organization in order for this call to
// succeed.
//
// - name: The resource name of the CryptoKey.
func (r *ProjectsLocationsKeyRingsCryptoKeysService) GetProtectedResourcesSummary(name string) *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall {
	c := &ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) Fields(s ...googleapi.Field) *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) IfNoneMatch(entityTag string) *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) Context(ctx context.Context) *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/protectedResourcesSummary")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "kmsinventory.projects.locations.keyRings.cryptoKeys.getProtectedResourcesSummary", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "kmsinventory.projects.locations.keyRings.cryptoKeys.getProtectedResourcesSummary" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudKmsInventoryV1ProtectedResourcesSummary.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsKeyRingsCryptoKeysGetProtectedResourcesSummaryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudKmsInventoryV1ProtectedResourcesSummary, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudKmsInventoryV1ProtectedResourcesSummary{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "kmsinventory.projects.locations.keyRings.cryptoKeys.getProtectedResourcesSummary", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
