﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-insights/ApplicationInsightsRequest.h>
#include <aws/application-insights/ApplicationInsights_EXPORTS.h>
#include <aws/application-insights/model/RecommendationType.h>
#include <aws/application-insights/model/Tier.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ApplicationInsights {
namespace Model {

/**
 */
class DescribeComponentConfigurationRecommendationRequest : public ApplicationInsightsRequest {
 public:
  AWS_APPLICATIONINSIGHTS_API DescribeComponentConfigurationRecommendationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeComponentConfigurationRecommendation"; }

  AWS_APPLICATIONINSIGHTS_API Aws::String SerializePayload() const override;

  AWS_APPLICATIONINSIGHTS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The name of the resource group.</p>
   */
  inline const Aws::String& GetResourceGroupName() const { return m_resourceGroupName; }
  inline bool ResourceGroupNameHasBeenSet() const { return m_resourceGroupNameHasBeenSet; }
  template <typename ResourceGroupNameT = Aws::String>
  void SetResourceGroupName(ResourceGroupNameT&& value) {
    m_resourceGroupNameHasBeenSet = true;
    m_resourceGroupName = std::forward<ResourceGroupNameT>(value);
  }
  template <typename ResourceGroupNameT = Aws::String>
  DescribeComponentConfigurationRecommendationRequest& WithResourceGroupName(ResourceGroupNameT&& value) {
    SetResourceGroupName(std::forward<ResourceGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the component.</p>
   */
  inline const Aws::String& GetComponentName() const { return m_componentName; }
  inline bool ComponentNameHasBeenSet() const { return m_componentNameHasBeenSet; }
  template <typename ComponentNameT = Aws::String>
  void SetComponentName(ComponentNameT&& value) {
    m_componentNameHasBeenSet = true;
    m_componentName = std::forward<ComponentNameT>(value);
  }
  template <typename ComponentNameT = Aws::String>
  DescribeComponentConfigurationRecommendationRequest& WithComponentName(ComponentNameT&& value) {
    SetComponentName(std::forward<ComponentNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tier of the application component.</p>
   */
  inline Tier GetTier() const { return m_tier; }
  inline bool TierHasBeenSet() const { return m_tierHasBeenSet; }
  inline void SetTier(Tier value) {
    m_tierHasBeenSet = true;
    m_tier = value;
  }
  inline DescribeComponentConfigurationRecommendationRequest& WithTier(Tier value) {
    SetTier(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the workload. The name of the workload is required when the tier
   * of the application component is <code>SAP_ASE_SINGLE_NODE</code> or
   * <code>SAP_ASE_HIGH_AVAILABILITY</code>.</p>
   */
  inline const Aws::String& GetWorkloadName() const { return m_workloadName; }
  inline bool WorkloadNameHasBeenSet() const { return m_workloadNameHasBeenSet; }
  template <typename WorkloadNameT = Aws::String>
  void SetWorkloadName(WorkloadNameT&& value) {
    m_workloadNameHasBeenSet = true;
    m_workloadName = std::forward<WorkloadNameT>(value);
  }
  template <typename WorkloadNameT = Aws::String>
  DescribeComponentConfigurationRecommendationRequest& WithWorkloadName(WorkloadNameT&& value) {
    SetWorkloadName(std::forward<WorkloadNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The recommended configuration type.</p>
   */
  inline RecommendationType GetRecommendationType() const { return m_recommendationType; }
  inline bool RecommendationTypeHasBeenSet() const { return m_recommendationTypeHasBeenSet; }
  inline void SetRecommendationType(RecommendationType value) {
    m_recommendationTypeHasBeenSet = true;
    m_recommendationType = value;
  }
  inline DescribeComponentConfigurationRecommendationRequest& WithRecommendationType(RecommendationType value) {
    SetRecommendationType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceGroupName;
  bool m_resourceGroupNameHasBeenSet = false;

  Aws::String m_componentName;
  bool m_componentNameHasBeenSet = false;

  Tier m_tier{Tier::NOT_SET};
  bool m_tierHasBeenSet = false;

  Aws::String m_workloadName;
  bool m_workloadNameHasBeenSet = false;

  RecommendationType m_recommendationType{RecommendationType::NOT_SET};
  bool m_recommendationTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationInsights
}  // namespace Aws
