﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appmesh/AppMesh_EXPORTS.h>
#include <aws/appmesh/model/HttpGatewayRouteAction.h>
#include <aws/appmesh/model/HttpGatewayRouteMatch.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AppMesh {
namespace Model {

/**
 * <p>An object that represents an HTTP gateway route.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/appmesh-2019-01-25/HttpGatewayRoute">AWS
 * API Reference</a></p>
 */
class HttpGatewayRoute {
 public:
  AWS_APPMESH_API HttpGatewayRoute() = default;
  AWS_APPMESH_API HttpGatewayRoute(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API HttpGatewayRoute& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_APPMESH_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An object that represents the action to take if a match is determined.</p>
   */
  inline const HttpGatewayRouteAction& GetAction() const { return m_action; }
  inline bool ActionHasBeenSet() const { return m_actionHasBeenSet; }
  template <typename ActionT = HttpGatewayRouteAction>
  void SetAction(ActionT&& value) {
    m_actionHasBeenSet = true;
    m_action = std::forward<ActionT>(value);
  }
  template <typename ActionT = HttpGatewayRouteAction>
  HttpGatewayRoute& WithAction(ActionT&& value) {
    SetAction(std::forward<ActionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An object that represents the criteria for determining a request match.</p>
   */
  inline const HttpGatewayRouteMatch& GetMatch() const { return m_match; }
  inline bool MatchHasBeenSet() const { return m_matchHasBeenSet; }
  template <typename MatchT = HttpGatewayRouteMatch>
  void SetMatch(MatchT&& value) {
    m_matchHasBeenSet = true;
    m_match = std::forward<MatchT>(value);
  }
  template <typename MatchT = HttpGatewayRouteMatch>
  HttpGatewayRoute& WithMatch(MatchT&& value) {
    SetMatch(std::forward<MatchT>(value));
    return *this;
  }
  ///@}
 private:
  HttpGatewayRouteAction m_action;
  bool m_actionHasBeenSet = false;

  HttpGatewayRouteMatch m_match;
  bool m_matchHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppMesh
}  // namespace Aws
