﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ce/CostExplorer_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CostExplorer {
namespace Model {

/**
 * <p>Details about the Amazon EC2 reservations that Amazon Web Services recommends
 * that you purchase.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ce-2017-10-25/EC2InstanceDetails">AWS
 * API Reference</a></p>
 */
class EC2InstanceDetails {
 public:
  AWS_COSTEXPLORER_API EC2InstanceDetails() = default;
  AWS_COSTEXPLORER_API EC2InstanceDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTEXPLORER_API EC2InstanceDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_COSTEXPLORER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The instance family of the recommended reservation.</p>
   */
  inline const Aws::String& GetFamily() const { return m_family; }
  inline bool FamilyHasBeenSet() const { return m_familyHasBeenSet; }
  template <typename FamilyT = Aws::String>
  void SetFamily(FamilyT&& value) {
    m_familyHasBeenSet = true;
    m_family = std::forward<FamilyT>(value);
  }
  template <typename FamilyT = Aws::String>
  EC2InstanceDetails& WithFamily(FamilyT&& value) {
    SetFamily(std::forward<FamilyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of instance that Amazon Web Services recommends.</p>
   */
  inline const Aws::String& GetInstanceType() const { return m_instanceType; }
  inline bool InstanceTypeHasBeenSet() const { return m_instanceTypeHasBeenSet; }
  template <typename InstanceTypeT = Aws::String>
  void SetInstanceType(InstanceTypeT&& value) {
    m_instanceTypeHasBeenSet = true;
    m_instanceType = std::forward<InstanceTypeT>(value);
  }
  template <typename InstanceTypeT = Aws::String>
  EC2InstanceDetails& WithInstanceType(InstanceTypeT&& value) {
    SetInstanceType(std::forward<InstanceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services Region of the recommended reservation.</p>
   */
  inline const Aws::String& GetRegion() const { return m_region; }
  inline bool RegionHasBeenSet() const { return m_regionHasBeenSet; }
  template <typename RegionT = Aws::String>
  void SetRegion(RegionT&& value) {
    m_regionHasBeenSet = true;
    m_region = std::forward<RegionT>(value);
  }
  template <typename RegionT = Aws::String>
  EC2InstanceDetails& WithRegion(RegionT&& value) {
    SetRegion(std::forward<RegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Availability Zone of the recommended reservation.</p>
   */
  inline const Aws::String& GetAvailabilityZone() const { return m_availabilityZone; }
  inline bool AvailabilityZoneHasBeenSet() const { return m_availabilityZoneHasBeenSet; }
  template <typename AvailabilityZoneT = Aws::String>
  void SetAvailabilityZone(AvailabilityZoneT&& value) {
    m_availabilityZoneHasBeenSet = true;
    m_availabilityZone = std::forward<AvailabilityZoneT>(value);
  }
  template <typename AvailabilityZoneT = Aws::String>
  EC2InstanceDetails& WithAvailabilityZone(AvailabilityZoneT&& value) {
    SetAvailabilityZone(std::forward<AvailabilityZoneT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The platform of the recommended reservation. The platform is the specific
   * combination of operating system, license model, and software on an instance.</p>
   */
  inline const Aws::String& GetPlatform() const { return m_platform; }
  inline bool PlatformHasBeenSet() const { return m_platformHasBeenSet; }
  template <typename PlatformT = Aws::String>
  void SetPlatform(PlatformT&& value) {
    m_platformHasBeenSet = true;
    m_platform = std::forward<PlatformT>(value);
  }
  template <typename PlatformT = Aws::String>
  EC2InstanceDetails& WithPlatform(PlatformT&& value) {
    SetPlatform(std::forward<PlatformT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommended reservation is dedicated or shared.</p>
   */
  inline const Aws::String& GetTenancy() const { return m_tenancy; }
  inline bool TenancyHasBeenSet() const { return m_tenancyHasBeenSet; }
  template <typename TenancyT = Aws::String>
  void SetTenancy(TenancyT&& value) {
    m_tenancyHasBeenSet = true;
    m_tenancy = std::forward<TenancyT>(value);
  }
  template <typename TenancyT = Aws::String>
  EC2InstanceDetails& WithTenancy(TenancyT&& value) {
    SetTenancy(std::forward<TenancyT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommendation is for a current-generation instance.
   * </p>
   */
  inline bool GetCurrentGeneration() const { return m_currentGeneration; }
  inline bool CurrentGenerationHasBeenSet() const { return m_currentGenerationHasBeenSet; }
  inline void SetCurrentGeneration(bool value) {
    m_currentGenerationHasBeenSet = true;
    m_currentGeneration = value;
  }
  inline EC2InstanceDetails& WithCurrentGeneration(bool value) {
    SetCurrentGeneration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determines whether the recommended reservation is size flexible.</p>
   */
  inline bool GetSizeFlexEligible() const { return m_sizeFlexEligible; }
  inline bool SizeFlexEligibleHasBeenSet() const { return m_sizeFlexEligibleHasBeenSet; }
  inline void SetSizeFlexEligible(bool value) {
    m_sizeFlexEligibleHasBeenSet = true;
    m_sizeFlexEligible = value;
  }
  inline EC2InstanceDetails& WithSizeFlexEligible(bool value) {
    SetSizeFlexEligible(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_family;
  bool m_familyHasBeenSet = false;

  Aws::String m_instanceType;
  bool m_instanceTypeHasBeenSet = false;

  Aws::String m_region;
  bool m_regionHasBeenSet = false;

  Aws::String m_availabilityZone;
  bool m_availabilityZoneHasBeenSet = false;

  Aws::String m_platform;
  bool m_platformHasBeenSet = false;

  Aws::String m_tenancy;
  bool m_tenancyHasBeenSet = false;

  bool m_currentGeneration{false};
  bool m_currentGenerationHasBeenSet = false;

  bool m_sizeFlexEligible{false};
  bool m_sizeFlexEligibleHasBeenSet = false;
};

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
