﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ce/model/ResourceDetails.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CostExplorer {
namespace Model {

ResourceDetails::ResourceDetails(JsonView jsonValue) { *this = jsonValue; }

ResourceDetails& ResourceDetails::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("EC2ResourceDetails")) {
    m_eC2ResourceDetails = jsonValue.GetObject("EC2ResourceDetails");
    m_eC2ResourceDetailsHasBeenSet = true;
  }
  return *this;
}

JsonValue ResourceDetails::Jsonize() const {
  JsonValue payload;

  if (m_eC2ResourceDetailsHasBeenSet) {
    payload.WithObject("EC2ResourceDetails", m_eC2ResourceDetails.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CostExplorer
}  // namespace Aws
