﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/cleanrooms/model/ConfiguredTableAssociationAnalysisRuleType.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CleanRooms {
namespace Model {

/**
 * <p>The configured table association summary for the objects listed by the
 * request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/cleanrooms-2022-02-17/ConfiguredTableAssociationSummary">AWS
 * API Reference</a></p>
 */
class ConfiguredTableAssociationSummary {
 public:
  AWS_CLEANROOMS_API ConfiguredTableAssociationSummary() = default;
  AWS_CLEANROOMS_API ConfiguredTableAssociationSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API ConfiguredTableAssociationSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLEANROOMS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The unique configured table ID that this configured table association refers
   * to.</p>
   */
  inline const Aws::String& GetConfiguredTableId() const { return m_configuredTableId; }
  inline bool ConfiguredTableIdHasBeenSet() const { return m_configuredTableIdHasBeenSet; }
  template <typename ConfiguredTableIdT = Aws::String>
  void SetConfiguredTableId(ConfiguredTableIdT&& value) {
    m_configuredTableIdHasBeenSet = true;
    m_configuredTableId = std::forward<ConfiguredTableIdT>(value);
  }
  template <typename ConfiguredTableIdT = Aws::String>
  ConfiguredTableAssociationSummary& WithConfiguredTableId(ConfiguredTableIdT&& value) {
    SetConfiguredTableId(std::forward<ConfiguredTableIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the membership that the configured table association
   * belongs to.</p>
   */
  inline const Aws::String& GetMembershipId() const { return m_membershipId; }
  inline bool MembershipIdHasBeenSet() const { return m_membershipIdHasBeenSet; }
  template <typename MembershipIdT = Aws::String>
  void SetMembershipId(MembershipIdT&& value) {
    m_membershipIdHasBeenSet = true;
    m_membershipId = std::forward<MembershipIdT>(value);
  }
  template <typename MembershipIdT = Aws::String>
  ConfiguredTableAssociationSummary& WithMembershipId(MembershipIdT&& value) {
    SetMembershipId(std::forward<MembershipIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ARN for the membership that the configured table association
   * belongs to.</p>
   */
  inline const Aws::String& GetMembershipArn() const { return m_membershipArn; }
  inline bool MembershipArnHasBeenSet() const { return m_membershipArnHasBeenSet; }
  template <typename MembershipArnT = Aws::String>
  void SetMembershipArn(MembershipArnT&& value) {
    m_membershipArnHasBeenSet = true;
    m_membershipArn = std::forward<MembershipArnT>(value);
  }
  template <typename MembershipArnT = Aws::String>
  ConfiguredTableAssociationSummary& WithMembershipArn(MembershipArnT&& value) {
    SetMembershipArn(std::forward<MembershipArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the configured table association. The table is identified by this
   * name when running Protected Queries against the underlying data.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  ConfiguredTableAssociationSummary& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the configured table association was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreateTime() const { return m_createTime; }
  inline bool CreateTimeHasBeenSet() const { return m_createTimeHasBeenSet; }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  void SetCreateTime(CreateTimeT&& value) {
    m_createTimeHasBeenSet = true;
    m_createTime = std::forward<CreateTimeT>(value);
  }
  template <typename CreateTimeT = Aws::Utils::DateTime>
  ConfiguredTableAssociationSummary& WithCreateTime(CreateTimeT&& value) {
    SetCreateTime(std::forward<CreateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The time the configured table association was last updated.</p>
   */
  inline const Aws::Utils::DateTime& GetUpdateTime() const { return m_updateTime; }
  inline bool UpdateTimeHasBeenSet() const { return m_updateTimeHasBeenSet; }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  void SetUpdateTime(UpdateTimeT&& value) {
    m_updateTimeHasBeenSet = true;
    m_updateTime = std::forward<UpdateTimeT>(value);
  }
  template <typename UpdateTimeT = Aws::Utils::DateTime>
  ConfiguredTableAssociationSummary& WithUpdateTime(UpdateTimeT&& value) {
    SetUpdateTime(std::forward<UpdateTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ID for the configured table association.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  ConfiguredTableAssociationSummary& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique ARN for the configured table association.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  ConfiguredTableAssociationSummary& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The analysis rule types that are associated with the configured table
   * associations in this summary. </p>
   */
  inline const Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>& GetAnalysisRuleTypes() const { return m_analysisRuleTypes; }
  inline bool AnalysisRuleTypesHasBeenSet() const { return m_analysisRuleTypesHasBeenSet; }
  template <typename AnalysisRuleTypesT = Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>>
  void SetAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes = std::forward<AnalysisRuleTypesT>(value);
  }
  template <typename AnalysisRuleTypesT = Aws::Vector<ConfiguredTableAssociationAnalysisRuleType>>
  ConfiguredTableAssociationSummary& WithAnalysisRuleTypes(AnalysisRuleTypesT&& value) {
    SetAnalysisRuleTypes(std::forward<AnalysisRuleTypesT>(value));
    return *this;
  }
  inline ConfiguredTableAssociationSummary& AddAnalysisRuleTypes(ConfiguredTableAssociationAnalysisRuleType value) {
    m_analysisRuleTypesHasBeenSet = true;
    m_analysisRuleTypes.push_back(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_configuredTableId;
  bool m_configuredTableIdHasBeenSet = false;

  Aws::String m_membershipId;
  bool m_membershipIdHasBeenSet = false;

  Aws::String m_membershipArn;
  bool m_membershipArnHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::Utils::DateTime m_createTime{};
  bool m_createTimeHasBeenSet = false;

  Aws::Utils::DateTime m_updateTime{};
  bool m_updateTimeHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::Vector<ConfiguredTableAssociationAnalysisRuleType> m_analysisRuleTypes;
  bool m_analysisRuleTypesHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
