﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/ProtectedJobComputeConfiguration.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CleanRooms {
namespace Model {

ProtectedJobComputeConfiguration::ProtectedJobComputeConfiguration(JsonView jsonValue) { *this = jsonValue; }

ProtectedJobComputeConfiguration& ProtectedJobComputeConfiguration::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("worker")) {
    m_worker = jsonValue.GetObject("worker");
    m_workerHasBeenSet = true;
  }
  return *this;
}

JsonValue ProtectedJobComputeConfiguration::Jsonize() const {
  JsonValue payload;

  if (m_workerHasBeenSet) {
    payload.WithObject("worker", m_worker.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
