﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/clouddirectory/CloudDirectory_EXPORTS.h>
#include <aws/clouddirectory/model/TypedLinkSpecifier.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CloudDirectory {
namespace Model {
class AttachTypedLinkResult {
 public:
  AWS_CLOUDDIRECTORY_API AttachTypedLinkResult() = default;
  AWS_CLOUDDIRECTORY_API AttachTypedLinkResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CLOUDDIRECTORY_API AttachTypedLinkResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Returns a typed link specifier as output.</p>
   */
  inline const TypedLinkSpecifier& GetTypedLinkSpecifier() const { return m_typedLinkSpecifier; }
  template <typename TypedLinkSpecifierT = TypedLinkSpecifier>
  void SetTypedLinkSpecifier(TypedLinkSpecifierT&& value) {
    m_typedLinkSpecifierHasBeenSet = true;
    m_typedLinkSpecifier = std::forward<TypedLinkSpecifierT>(value);
  }
  template <typename TypedLinkSpecifierT = TypedLinkSpecifier>
  AttachTypedLinkResult& WithTypedLinkSpecifier(TypedLinkSpecifierT&& value) {
    SetTypedLinkSpecifier(std::forward<TypedLinkSpecifierT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AttachTypedLinkResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  TypedLinkSpecifier m_typedLinkSpecifier;
  bool m_typedLinkSpecifierHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudDirectory
}  // namespace Aws
