﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cloudformation/CloudFormation_EXPORTS.h>
#include <aws/cloudformation/model/ResponseMetadata.h>
#include <aws/cloudformation/model/TypeSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace CloudFormation {
namespace Model {
class ListTypesResult {
 public:
  AWS_CLOUDFORMATION_API ListTypesResult() = default;
  AWS_CLOUDFORMATION_API ListTypesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_CLOUDFORMATION_API ListTypesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>A list of <code>TypeSummary</code> structures that contain information about
   * the specified extensions.</p>
   */
  inline const Aws::Vector<TypeSummary>& GetTypeSummaries() const { return m_typeSummaries; }
  template <typename TypeSummariesT = Aws::Vector<TypeSummary>>
  void SetTypeSummaries(TypeSummariesT&& value) {
    m_typeSummariesHasBeenSet = true;
    m_typeSummaries = std::forward<TypeSummariesT>(value);
  }
  template <typename TypeSummariesT = Aws::Vector<TypeSummary>>
  ListTypesResult& WithTypeSummaries(TypeSummariesT&& value) {
    SetTypeSummaries(std::forward<TypeSummariesT>(value));
    return *this;
  }
  template <typename TypeSummariesT = TypeSummary>
  ListTypesResult& AddTypeSummaries(TypeSummariesT&& value) {
    m_typeSummariesHasBeenSet = true;
    m_typeSummaries.emplace_back(std::forward<TypeSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If the request doesn't return all the remaining results,
   * <code>NextToken</code> is set to a token. To retrieve the next set of results,
   * call this action again and assign that token to the request object's
   * <code>NextToken</code> parameter. If the request returns all results,
   * <code>NextToken</code> is set to <code>null</code>.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTypesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ListTypesResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TypeSummary> m_typeSummaries;
  bool m_typeSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudFormation
}  // namespace Aws
