﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/comprehend/model/ClassifyDocumentResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Comprehend::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ClassifyDocumentResult::ClassifyDocumentResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ClassifyDocumentResult& ClassifyDocumentResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("Classes")) {
    Aws::Utils::Array<JsonView> classesJsonList = jsonValue.GetArray("Classes");
    for (unsigned classesIndex = 0; classesIndex < classesJsonList.GetLength(); ++classesIndex) {
      m_classes.push_back(classesJsonList[classesIndex].AsObject());
    }
    m_classesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Labels")) {
    Aws::Utils::Array<JsonView> labelsJsonList = jsonValue.GetArray("Labels");
    for (unsigned labelsIndex = 0; labelsIndex < labelsJsonList.GetLength(); ++labelsIndex) {
      m_labels.push_back(labelsJsonList[labelsIndex].AsObject());
    }
    m_labelsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DocumentMetadata")) {
    m_documentMetadata = jsonValue.GetObject("DocumentMetadata");
    m_documentMetadataHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DocumentType")) {
    Aws::Utils::Array<JsonView> documentTypeJsonList = jsonValue.GetArray("DocumentType");
    for (unsigned documentTypeIndex = 0; documentTypeIndex < documentTypeJsonList.GetLength(); ++documentTypeIndex) {
      m_documentType.push_back(documentTypeJsonList[documentTypeIndex].AsObject());
    }
    m_documentTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Errors")) {
    Aws::Utils::Array<JsonView> errorsJsonList = jsonValue.GetArray("Errors");
    for (unsigned errorsIndex = 0; errorsIndex < errorsJsonList.GetLength(); ++errorsIndex) {
      m_errors.push_back(errorsJsonList[errorsIndex].AsObject());
    }
    m_errorsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Warnings")) {
    Aws::Utils::Array<JsonView> warningsJsonList = jsonValue.GetArray("Warnings");
    for (unsigned warningsIndex = 0; warningsIndex < warningsJsonList.GetLength(); ++warningsIndex) {
      m_warnings.push_back(warningsJsonList[warningsIndex].AsObject());
    }
    m_warningsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
