#!/usr/bin/env bash

set -e

ci_dir="$(dirname "$0")"
. "${ci_dir}/ci-common.sh"

WITH_SUBMODULES=1
git_download fiat_crypto_legacy

if [ "$DOWNLOAD_ONLY" ]; then exit 0; fi

targets1=(
    print-old-pipeline-lite-hardcoded
    old-pipeline-lite-hardcoded
    lite-display-hardcoded
)
targets2=(
    print-old-pipeline-nobigmem-hardcoded
    old-pipeline-nobigmem-hardcoded
    nonautogenerated-specific
    nonautogenerated-specific-display
    selected-specific
    selected-specific-display
)

export COQEXTRAFLAGS='-native-compiler no'
( cd "${CI_BUILD_DIR}/fiat_crypto_legacy"
  make "${targets1[@]}"
  make -j 1 "${targets2[@]}"
)
