/*
 * Decompiled with CFR 0.152.
 */
package os;

import geny.ByteData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.TimeUnit;
import os.Internals$;
import os.ProcessLike;
import os.SubProcess$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.util.DynamicVariable;

public class SubProcess
implements ProcessLike {
    private final Process wrapped;
    private final Option inputPumperThread;
    private final Option outputPumperThread;
    private final Option errorPumperThread;
    private final long shutdownGracePeriod;
    private final Option shutdownHookMonitorThread;
    private final InputStream stdin;
    private final OutputStream stdout;
    private final OutputStream stderr;

    public static DynamicVariable<Map<String, String>> env() {
        return SubProcess$.MODULE$.env();
    }

    public SubProcess(Process wrapped, Option<Thread> inputPumperThread, Option<Thread> outputPumperThread, Option<Thread> errorPumperThread, long shutdownGracePeriod, Option<Thread> shutdownHookMonitorThread) {
        this.wrapped = wrapped;
        this.inputPumperThread = inputPumperThread;
        this.outputPumperThread = outputPumperThread;
        this.errorPumperThread = errorPumperThread;
        this.shutdownGracePeriod = shutdownGracePeriod;
        this.shutdownHookMonitorThread = shutdownHookMonitorThread;
        this.stdin = new InputStream(wrapped.getOutputStream());
        this.stdout = new OutputStream(wrapped.getInputStream());
        this.stderr = new OutputStream(wrapped.getErrorStream());
    }

    public Process wrapped() {
        return this.wrapped;
    }

    public Option<Thread> inputPumperThread() {
        return this.inputPumperThread;
    }

    public Option<Thread> outputPumperThread() {
        return this.outputPumperThread;
    }

    public Option<Thread> errorPumperThread() {
        return this.errorPumperThread;
    }

    public long shutdownGracePeriod() {
        return this.shutdownGracePeriod;
    }

    public Option<Thread> shutdownHookMonitorThread() {
        return this.shutdownHookMonitorThread;
    }

    public SubProcess(Process wrapped, Option<Thread> inputPumperThread, Option<Thread> outputPumperThread, Option<Thread> errorPumperThread) {
        this(wrapped, inputPumperThread, outputPumperThread, errorPumperThread, 100L, None$.MODULE$);
    }

    public InputStream stdin() {
        return this.stdin;
    }

    public OutputStream stdout() {
        return this.stdout;
    }

    public OutputStream stderr() {
        return this.stderr;
    }

    @Override
    public int exitCode() {
        return this.wrapped().exitValue();
    }

    @Override
    public boolean isAlive() {
        return this.wrapped().isAlive();
    }

    @Override
    public void destroy() {
        this.destroy(this.shutdownGracePeriod(), false);
    }

    public void destroy(long shutdownGracePeriod, boolean async) {
        this.wrapped().destroy();
        if (!async) {
            long now = System.currentTimeMillis();
            while (this.wrapped().isAlive() && (shutdownGracePeriod == -1L || System.currentTimeMillis() - now < shutdownGracePeriod)) {
                Thread.sleep(1L);
            }
            if (this.wrapped().isAlive()) {
                Predef$.MODULE$.println("wrapped.destroyForcibly()");
                this.wrapped().destroyForcibly();
                return;
            }
            return;
        }
    }

    public long destroy$default$1() {
        return this.shutdownGracePeriod();
    }

    public boolean destroy$default$2() {
        return false;
    }

    @Override
    public void destroyForcibly() {
        this.destroy(0L, this.destroy$default$2());
    }

    @Override
    public void close() {
        this.wrapped().destroy();
    }

    @Override
    public boolean waitFor(long timeout) {
        if (timeout == -1L) {
            this.wrapped().waitFor();
            return true;
        }
        return this.wrapped().waitFor(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public long waitFor$default$1() {
        return -1L;
    }

    @Override
    public void joinPumperThreadsHook() {
        this.outputPumperThread().foreach(_$1 -> _$1.join());
        this.errorPumperThread().foreach(_$2 -> _$2.join());
    }

    public static class InputStream
    extends java.io.OutputStream
    implements DataOutput {
        private final java.io.OutputStream wrapped;
        private final DataOutputStream data;
        private final BufferedWriter buffered;

        public InputStream(java.io.OutputStream wrapped) {
            this.wrapped = wrapped;
            this.data = new DataOutputStream(wrapped);
            this.buffered = new BufferedWriter(new OutputStreamWriter(wrapped));
        }

        public java.io.OutputStream wrapped() {
            return this.wrapped;
        }

        public DataOutputStream data() {
            return this.data;
        }

        public BufferedWriter buffered() {
            return this.buffered;
        }

        @Override
        public void write(int b) {
            this.wrapped().write(b);
        }

        @Override
        public void write(byte[] b) {
            this.wrapped().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.wrapped().write(b, off, len);
        }

        @Override
        public void writeBoolean(boolean v) {
            this.data().writeBoolean(v);
        }

        @Override
        public void writeByte(int v) {
            this.data().writeByte(v);
        }

        @Override
        public void writeShort(int v) {
            this.data().writeShort(v);
        }

        @Override
        public void writeChar(int v) {
            this.data().writeChar(v);
        }

        @Override
        public void writeInt(int v) {
            this.data().writeInt(v);
        }

        @Override
        public void writeLong(long v) {
            this.data().writeLong(v);
        }

        @Override
        public void writeFloat(float v) {
            this.data().writeFloat(v);
        }

        @Override
        public void writeDouble(double v) {
            this.data().writeDouble(v);
        }

        @Override
        public void writeBytes(String s) {
            this.data().writeBytes(s);
        }

        @Override
        public void writeChars(String s) {
            this.data().writeChars(s);
        }

        @Override
        public void writeUTF(String s) {
            this.data().writeUTF(s);
        }

        public void writeLine(String s) {
            this.buffered().write(new StringBuilder(1).append(s).append("\n").toString());
        }

        public void write(String s) {
            this.buffered().write(s);
        }

        public void write(char[] s) {
            this.buffered().write(s);
        }

        @Override
        public void flush() {
            this.data().flush();
            this.buffered().flush();
            this.wrapped().flush();
        }

        @Override
        public void close() {
            this.wrapped().close();
        }
    }

    public static class OutputStream
    extends java.io.InputStream
    implements DataInput,
    ByteData {
        private final java.io.InputStream wrapped;
        private final DataInputStream data;
        private final BufferedReader buffered;

        public OutputStream(java.io.InputStream wrapped) {
            this.wrapped = wrapped;
            this.data = new DataInputStream(wrapped);
            this.buffered = new BufferedReader(new InputStreamReader(wrapped));
        }

        public java.io.InputStream wrapped() {
            return this.wrapped;
        }

        public DataInputStream data() {
            return this.data;
        }

        public BufferedReader buffered() {
            return this.buffered;
        }

        @Override
        public int read() {
            return this.wrapped().read();
        }

        @Override
        public int read(byte[] b) {
            return this.wrapped().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return this.wrapped().read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) {
            this.data().readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) {
            this.data().readFully(b, off, len);
        }

        @Override
        public int skipBytes(int n) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public boolean readBoolean() {
            return this.data().readBoolean();
        }

        @Override
        public byte readByte() {
            return this.data().readByte();
        }

        @Override
        public int readUnsignedByte() {
            return this.data().readUnsignedByte();
        }

        @Override
        public short readShort() {
            return this.data().readShort();
        }

        @Override
        public int readUnsignedShort() {
            return this.data().readUnsignedShort();
        }

        @Override
        public char readChar() {
            return this.data().readChar();
        }

        @Override
        public int readInt() {
            return this.data().readInt();
        }

        @Override
        public long readLong() {
            return this.data().readLong();
        }

        @Override
        public float readFloat() {
            return this.data().readFloat();
        }

        @Override
        public double readDouble() {
            return this.data().readDouble();
        }

        @Override
        public String readUTF() {
            return this.data().readUTF();
        }

        @Override
        public String readLine() {
            return this.buffered().readLine();
        }

        @Override
        public byte[] bytes() {
            byte[] byArray;
            OutputStream outputStream = this;
            synchronized (outputStream) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Internals$.MODULE$.transfer(this.wrapped(), out);
                byArray = out.toByteArray();
            }
            return byArray;
        }

        @Override
        public void close() {
            this.wrapped().close();
        }
    }
}

