/*
 * u2c.h - Create convertion table from GB2312.TXT, GB12345p.TXT or BIG5.TXT.
 *
    Copyright (C) 2001  Yao Zhang

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * yaoz@users.sourceforge.net
 */
#ifndef U2C_H
#define U2C_H 1

#include <stdint.h>

#define GB2312	"GB2312.TXT"
#define GB12345	"GB12345p.TXT"
#define BIG5    "BIG5.TXT"

typedef struct {
    uint32_t u;
    uint32_t c;
} U2CEntry;

typedef struct {
    int length;
    U2CEntry *array;
} U2C;

__BEGIN_DECLS

extern U2C *u2c_open(char *file);
extern void u2c_close(U2C *u2c);
extern uint32_t u2c_convert(U2C *u2c, uint32_t u);

__END_DECLS

#endif /* !U2C_H */
