// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dataplex/v1/tasks.proto

package dataplex

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Determines how often and when the job will run.
type Task_TriggerSpec_Type int32

const (
	// Unspecified trigger type.
	Task_TriggerSpec_TYPE_UNSPECIFIED Task_TriggerSpec_Type = 0
	// The task runs one-time shortly after Task Creation.
	Task_TriggerSpec_ON_DEMAND Task_TriggerSpec_Type = 1
	// The task is scheduled to run periodically.
	Task_TriggerSpec_RECURRING Task_TriggerSpec_Type = 2
)

// Enum value maps for Task_TriggerSpec_Type.
var (
	Task_TriggerSpec_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ON_DEMAND",
		2: "RECURRING",
	}
	Task_TriggerSpec_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ON_DEMAND":        1,
		"RECURRING":        2,
	}
)

func (x Task_TriggerSpec_Type) Enum() *Task_TriggerSpec_Type {
	p := new(Task_TriggerSpec_Type)
	*p = x
	return p
}

func (x Task_TriggerSpec_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Task_TriggerSpec_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_tasks_proto_enumTypes[0].Descriptor()
}

func (Task_TriggerSpec_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_tasks_proto_enumTypes[0]
}

func (x Task_TriggerSpec_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Task_TriggerSpec_Type.Descriptor instead.
func (Task_TriggerSpec_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 1, 0}
}

type Job_Service int32

const (
	// Service used to run the job is unspecified.
	Job_SERVICE_UNSPECIFIED Job_Service = 0
	// Dataproc service is used to run this job.
	Job_DATAPROC Job_Service = 1
)

// Enum value maps for Job_Service.
var (
	Job_Service_name = map[int32]string{
		0: "SERVICE_UNSPECIFIED",
		1: "DATAPROC",
	}
	Job_Service_value = map[string]int32{
		"SERVICE_UNSPECIFIED": 0,
		"DATAPROC":            1,
	}
)

func (x Job_Service) Enum() *Job_Service {
	p := new(Job_Service)
	*p = x
	return p
}

func (x Job_Service) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_Service) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_tasks_proto_enumTypes[1].Descriptor()
}

func (Job_Service) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_tasks_proto_enumTypes[1]
}

func (x Job_Service) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_Service.Descriptor instead.
func (Job_Service) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{1, 0}
}

type Job_State int32

const (
	// The job state is unknown.
	Job_STATE_UNSPECIFIED Job_State = 0
	// The job is running.
	Job_RUNNING Job_State = 1
	// The job is cancelling.
	Job_CANCELLING Job_State = 2
	// The job cancellation was successful.
	Job_CANCELLED Job_State = 3
	// The job completed successfully.
	Job_SUCCEEDED Job_State = 4
	// The job is no longer running due to an error.
	Job_FAILED Job_State = 5
	// The job was cancelled outside of Dataplex.
	Job_ABORTED Job_State = 6
)

// Enum value maps for Job_State.
var (
	Job_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "CANCELLING",
		3: "CANCELLED",
		4: "SUCCEEDED",
		5: "FAILED",
		6: "ABORTED",
	}
	Job_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"CANCELLING":        2,
		"CANCELLED":         3,
		"SUCCEEDED":         4,
		"FAILED":            5,
		"ABORTED":           6,
	}
)

func (x Job_State) Enum() *Job_State {
	p := new(Job_State)
	*p = x
	return p
}

func (x Job_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Job_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_tasks_proto_enumTypes[2].Descriptor()
}

func (Job_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_tasks_proto_enumTypes[2]
}

func (x Job_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Job_State.Descriptor instead.
func (Job_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{1, 1}
}

// A task represents a user-visible job.
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the task, of the form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
	// tasks/{task_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the task. This ID will be
	// different if the task is deleted and re-created with the same name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the task was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the task was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the task.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Current state of the task.
	State State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.dataplex.v1.State" json:"state,omitempty"`
	// Optional. User-defined labels for the task.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Spec related to how often and when a task should be triggered.
	TriggerSpec *Task_TriggerSpec `protobuf:"bytes,100,opt,name=trigger_spec,json=triggerSpec,proto3" json:"trigger_spec,omitempty"`
	// Required. Spec related to how a task is executed.
	ExecutionSpec *Task_ExecutionSpec `protobuf:"bytes,101,opt,name=execution_spec,json=executionSpec,proto3" json:"execution_spec,omitempty"`
	// Output only. Status of the latest task executions.
	ExecutionStatus *Task_ExecutionStatus `protobuf:"bytes,201,opt,name=execution_status,json=executionStatus,proto3" json:"execution_status,omitempty"`
	// Task template specific user-specified config.
	//
	// Types that are assignable to Config:
	//
	//	*Task_Spark
	//	*Task_Notebook
	Config isTask_Config `protobuf_oneof:"config"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0}
}

func (x *Task) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Task) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Task) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Task) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Task) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Task) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Task) GetState() State {
	if x != nil {
		return x.State
	}
	return State_STATE_UNSPECIFIED
}

func (x *Task) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Task) GetTriggerSpec() *Task_TriggerSpec {
	if x != nil {
		return x.TriggerSpec
	}
	return nil
}

func (x *Task) GetExecutionSpec() *Task_ExecutionSpec {
	if x != nil {
		return x.ExecutionSpec
	}
	return nil
}

func (x *Task) GetExecutionStatus() *Task_ExecutionStatus {
	if x != nil {
		return x.ExecutionStatus
	}
	return nil
}

func (m *Task) GetConfig() isTask_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *Task) GetSpark() *Task_SparkTaskConfig {
	if x, ok := x.GetConfig().(*Task_Spark); ok {
		return x.Spark
	}
	return nil
}

func (x *Task) GetNotebook() *Task_NotebookTaskConfig {
	if x, ok := x.GetConfig().(*Task_Notebook); ok {
		return x.Notebook
	}
	return nil
}

type isTask_Config interface {
	isTask_Config()
}

type Task_Spark struct {
	// Config related to running custom Spark tasks.
	Spark *Task_SparkTaskConfig `protobuf:"bytes,300,opt,name=spark,proto3,oneof"`
}

type Task_Notebook struct {
	// Config related to running scheduled Notebooks.
	Notebook *Task_NotebookTaskConfig `protobuf:"bytes,302,opt,name=notebook,proto3,oneof"`
}

func (*Task_Spark) isTask_Config() {}

func (*Task_Notebook) isTask_Config() {}

// A job represents an instance of a task.
type Job struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the job, of the form:
	// `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the job.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the job was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time when the job ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Execution state for the job.
	State Job_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.dataplex.v1.Job_State" json:"state,omitempty"`
	// Output only. The number of times the job has been retried (excluding the
	// initial attempt).
	RetryCount uint32 `protobuf:"varint,6,opt,name=retry_count,json=retryCount,proto3" json:"retry_count,omitempty"`
	// Output only. The underlying service running a job.
	Service Job_Service `protobuf:"varint,7,opt,name=service,proto3,enum=google.cloud.dataplex.v1.Job_Service" json:"service,omitempty"`
	// Output only. The full resource name for the job run under a particular service.
	ServiceJob string `protobuf:"bytes,8,opt,name=service_job,json=serviceJob,proto3" json:"service_job,omitempty"`
	// Output only. Additional information about the current state.
	Message string `protobuf:"bytes,9,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Job) Reset() {
	*x = Job{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Job) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Job) ProtoMessage() {}

func (x *Job) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Job.ProtoReflect.Descriptor instead.
func (*Job) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{1}
}

func (x *Job) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Job) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Job) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Job) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *Job) GetState() Job_State {
	if x != nil {
		return x.State
	}
	return Job_STATE_UNSPECIFIED
}

func (x *Job) GetRetryCount() uint32 {
	if x != nil {
		return x.RetryCount
	}
	return 0
}

func (x *Job) GetService() Job_Service {
	if x != nil {
		return x.Service
	}
	return Job_SERVICE_UNSPECIFIED
}

func (x *Job) GetServiceJob() string {
	if x != nil {
		return x.ServiceJob
	}
	return ""
}

func (x *Job) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Configuration for the underlying infrastructure used to run workloads.
type Task_InfrastructureSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Hardware config.
	//
	// Types that are assignable to Resources:
	//
	//	*Task_InfrastructureSpec_Batch
	Resources isTask_InfrastructureSpec_Resources `protobuf_oneof:"resources"`
	// Software config.
	//
	// Types that are assignable to Runtime:
	//
	//	*Task_InfrastructureSpec_ContainerImage
	Runtime isTask_InfrastructureSpec_Runtime `protobuf_oneof:"runtime"`
	// Networking config.
	//
	// Types that are assignable to Network:
	//
	//	*Task_InfrastructureSpec_VpcNetwork_
	Network isTask_InfrastructureSpec_Network `protobuf_oneof:"network"`
}

func (x *Task_InfrastructureSpec) Reset() {
	*x = Task_InfrastructureSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_InfrastructureSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_InfrastructureSpec) ProtoMessage() {}

func (x *Task_InfrastructureSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_InfrastructureSpec.ProtoReflect.Descriptor instead.
func (*Task_InfrastructureSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 0}
}

func (m *Task_InfrastructureSpec) GetResources() isTask_InfrastructureSpec_Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (x *Task_InfrastructureSpec) GetBatch() *Task_InfrastructureSpec_BatchComputeResources {
	if x, ok := x.GetResources().(*Task_InfrastructureSpec_Batch); ok {
		return x.Batch
	}
	return nil
}

func (m *Task_InfrastructureSpec) GetRuntime() isTask_InfrastructureSpec_Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (x *Task_InfrastructureSpec) GetContainerImage() *Task_InfrastructureSpec_ContainerImageRuntime {
	if x, ok := x.GetRuntime().(*Task_InfrastructureSpec_ContainerImage); ok {
		return x.ContainerImage
	}
	return nil
}

func (m *Task_InfrastructureSpec) GetNetwork() isTask_InfrastructureSpec_Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (x *Task_InfrastructureSpec) GetVpcNetwork() *Task_InfrastructureSpec_VpcNetwork {
	if x, ok := x.GetNetwork().(*Task_InfrastructureSpec_VpcNetwork_); ok {
		return x.VpcNetwork
	}
	return nil
}

type isTask_InfrastructureSpec_Resources interface {
	isTask_InfrastructureSpec_Resources()
}

type Task_InfrastructureSpec_Batch struct {
	// Compute resources needed for a Task when using Dataproc Serverless.
	Batch *Task_InfrastructureSpec_BatchComputeResources `protobuf:"bytes,52,opt,name=batch,proto3,oneof"`
}

func (*Task_InfrastructureSpec_Batch) isTask_InfrastructureSpec_Resources() {}

type isTask_InfrastructureSpec_Runtime interface {
	isTask_InfrastructureSpec_Runtime()
}

type Task_InfrastructureSpec_ContainerImage struct {
	// Container Image Runtime Configuration.
	ContainerImage *Task_InfrastructureSpec_ContainerImageRuntime `protobuf:"bytes,101,opt,name=container_image,json=containerImage,proto3,oneof"`
}

func (*Task_InfrastructureSpec_ContainerImage) isTask_InfrastructureSpec_Runtime() {}

type isTask_InfrastructureSpec_Network interface {
	isTask_InfrastructureSpec_Network()
}

type Task_InfrastructureSpec_VpcNetwork_ struct {
	// Vpc network.
	VpcNetwork *Task_InfrastructureSpec_VpcNetwork `protobuf:"bytes,150,opt,name=vpc_network,json=vpcNetwork,proto3,oneof"`
}

func (*Task_InfrastructureSpec_VpcNetwork_) isTask_InfrastructureSpec_Network() {}

// Task scheduling and trigger settings.
type Task_TriggerSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. Trigger type of the user-specified Task.
	Type Task_TriggerSpec_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.cloud.dataplex.v1.Task_TriggerSpec_Type" json:"type,omitempty"`
	// Optional. The first run of the task will be after this time.
	// If not specified, the task will run shortly after being submitted if
	// ON_DEMAND and based on the schedule if RECURRING.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Optional. Prevent the task from executing.
	// This does not cancel already running tasks. It is intended to temporarily
	// disable RECURRING tasks.
	Disabled bool `protobuf:"varint,4,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// Optional. Number of retry attempts before aborting.
	// Set to zero to never attempt to retry a failed task.
	MaxRetries int32 `protobuf:"varint,7,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
	// Trigger only applies for RECURRING tasks.
	//
	// Types that are assignable to Trigger:
	//
	//	*Task_TriggerSpec_Schedule
	Trigger isTask_TriggerSpec_Trigger `protobuf_oneof:"trigger"`
}

func (x *Task_TriggerSpec) Reset() {
	*x = Task_TriggerSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_TriggerSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_TriggerSpec) ProtoMessage() {}

func (x *Task_TriggerSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_TriggerSpec.ProtoReflect.Descriptor instead.
func (*Task_TriggerSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Task_TriggerSpec) GetType() Task_TriggerSpec_Type {
	if x != nil {
		return x.Type
	}
	return Task_TriggerSpec_TYPE_UNSPECIFIED
}

func (x *Task_TriggerSpec) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Task_TriggerSpec) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

func (x *Task_TriggerSpec) GetMaxRetries() int32 {
	if x != nil {
		return x.MaxRetries
	}
	return 0
}

func (m *Task_TriggerSpec) GetTrigger() isTask_TriggerSpec_Trigger {
	if m != nil {
		return m.Trigger
	}
	return nil
}

func (x *Task_TriggerSpec) GetSchedule() string {
	if x, ok := x.GetTrigger().(*Task_TriggerSpec_Schedule); ok {
		return x.Schedule
	}
	return ""
}

type isTask_TriggerSpec_Trigger interface {
	isTask_TriggerSpec_Trigger()
}

type Task_TriggerSpec_Schedule struct {
	// Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for running
	// tasks periodically.
	// To explicitly set a timezone to the cron tab, apply a prefix in the
	// cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
	// The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
	// database. For example, "CRON_TZ=America/New_York 1 * * * *", or
	// "TZ=America/New_York 1 * * * *".
	// This field is required for RECURRING tasks.
	Schedule string `protobuf:"bytes,100,opt,name=schedule,proto3,oneof"`
}

func (*Task_TriggerSpec_Schedule) isTask_TriggerSpec_Trigger() {}

// Execution related settings, like retry and service_account.
type Task_ExecutionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The arguments to pass to the task.
	// The args can use placeholders of the format ${placeholder} as
	// part of key/value string. These will be interpolated before passing the
	// args to the driver. Currently supported placeholders:
	// - ${task_id}
	// - ${job_time}
	// To pass positional args, set the key as TASK_ARGS. The value should be a
	// comma-separated string of all the positional arguments. To use a
	// delimiter other than comma, refer to
	// https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case of
	// other keys being present in the args, then TASK_ARGS will be passed as
	// the last argument.
	Args map[string]string `protobuf:"bytes,4,rep,name=args,proto3" json:"args,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Service account to use to execute a task.
	// If not provided, the default Compute service account for the project is
	// used.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. The project in which jobs are run. By default, the project containing the
	// Lake is used. If a project is provided, the
	// [ExecutionSpec.service_account][google.cloud.dataplex.v1.Task.ExecutionSpec.service_account] must belong to this project.
	Project string `protobuf:"bytes,7,opt,name=project,proto3" json:"project,omitempty"`
	// Optional. The maximum duration after which the job execution is expired.
	MaxJobExecutionLifetime *durationpb.Duration `protobuf:"bytes,8,opt,name=max_job_execution_lifetime,json=maxJobExecutionLifetime,proto3" json:"max_job_execution_lifetime,omitempty"`
	// Optional. The Cloud KMS key to use for encryption, of the form:
	// `projects/{project_number}/locations/{location_id}/keyRings/{key-ring-name}/cryptoKeys/{key-name}`.
	KmsKey string `protobuf:"bytes,9,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *Task_ExecutionSpec) Reset() {
	*x = Task_ExecutionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_ExecutionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_ExecutionSpec) ProtoMessage() {}

func (x *Task_ExecutionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_ExecutionSpec.ProtoReflect.Descriptor instead.
func (*Task_ExecutionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Task_ExecutionSpec) GetArgs() map[string]string {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *Task_ExecutionSpec) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Task_ExecutionSpec) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *Task_ExecutionSpec) GetMaxJobExecutionLifetime() *durationpb.Duration {
	if x != nil {
		return x.MaxJobExecutionLifetime
	}
	return nil
}

func (x *Task_ExecutionSpec) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// User-specified config for running a Spark task.
type Task_SparkTaskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The specification of the main method to call to drive the
	// job. Specify either the jar file that contains the main class or the
	// main class name.
	//
	// Types that are assignable to Driver:
	//
	//	*Task_SparkTaskConfig_MainJarFileUri
	//	*Task_SparkTaskConfig_MainClass
	//	*Task_SparkTaskConfig_PythonScriptFile
	//	*Task_SparkTaskConfig_SqlScriptFile
	//	*Task_SparkTaskConfig_SqlScript
	Driver isTask_SparkTaskConfig_Driver `protobuf_oneof:"driver"`
	// Optional. Cloud Storage URIs of files to be placed in the working directory of each
	// executor.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. Cloud Storage URIs of archives to be extracted into the working directory
	// of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and
	// .zip.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Optional. Infrastructure specification for the execution.
	InfrastructureSpec *Task_InfrastructureSpec `protobuf:"bytes,6,opt,name=infrastructure_spec,json=infrastructureSpec,proto3" json:"infrastructure_spec,omitempty"`
}

func (x *Task_SparkTaskConfig) Reset() {
	*x = Task_SparkTaskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_SparkTaskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_SparkTaskConfig) ProtoMessage() {}

func (x *Task_SparkTaskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_SparkTaskConfig.ProtoReflect.Descriptor instead.
func (*Task_SparkTaskConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 3}
}

func (m *Task_SparkTaskConfig) GetDriver() isTask_SparkTaskConfig_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (x *Task_SparkTaskConfig) GetMainJarFileUri() string {
	if x, ok := x.GetDriver().(*Task_SparkTaskConfig_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (x *Task_SparkTaskConfig) GetMainClass() string {
	if x, ok := x.GetDriver().(*Task_SparkTaskConfig_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (x *Task_SparkTaskConfig) GetPythonScriptFile() string {
	if x, ok := x.GetDriver().(*Task_SparkTaskConfig_PythonScriptFile); ok {
		return x.PythonScriptFile
	}
	return ""
}

func (x *Task_SparkTaskConfig) GetSqlScriptFile() string {
	if x, ok := x.GetDriver().(*Task_SparkTaskConfig_SqlScriptFile); ok {
		return x.SqlScriptFile
	}
	return ""
}

func (x *Task_SparkTaskConfig) GetSqlScript() string {
	if x, ok := x.GetDriver().(*Task_SparkTaskConfig_SqlScript); ok {
		return x.SqlScript
	}
	return ""
}

func (x *Task_SparkTaskConfig) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *Task_SparkTaskConfig) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

func (x *Task_SparkTaskConfig) GetInfrastructureSpec() *Task_InfrastructureSpec {
	if x != nil {
		return x.InfrastructureSpec
	}
	return nil
}

type isTask_SparkTaskConfig_Driver interface {
	isTask_SparkTaskConfig_Driver()
}

type Task_SparkTaskConfig_MainJarFileUri struct {
	// The Cloud Storage URI of the jar file that contains the main class.
	// The execution args are passed in as a sequence of named process
	// arguments (`--key=value`).
	MainJarFileUri string `protobuf:"bytes,100,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type Task_SparkTaskConfig_MainClass struct {
	// The name of the driver's main class. The jar file that contains the
	// class must be in the default CLASSPATH or specified in
	// `jar_file_uris`.
	// The execution args are passed in as a sequence of named process
	// arguments (`--key=value`).
	MainClass string `protobuf:"bytes,101,opt,name=main_class,json=mainClass,proto3,oneof"`
}

type Task_SparkTaskConfig_PythonScriptFile struct {
	// The Gcloud Storage URI of the main Python file to use as the driver.
	// Must be a .py file. The execution args are passed in as a sequence of
	// named process arguments (`--key=value`).
	PythonScriptFile string `protobuf:"bytes,102,opt,name=python_script_file,json=pythonScriptFile,proto3,oneof"`
}

type Task_SparkTaskConfig_SqlScriptFile struct {
	// A reference to a query file. This can be the Cloud Storage URI of the
	// query file or it can the path to a SqlScript Content. The execution
	// args are used to declare a set of script variables
	// (`set key="value";`).
	SqlScriptFile string `protobuf:"bytes,104,opt,name=sql_script_file,json=sqlScriptFile,proto3,oneof"`
}

type Task_SparkTaskConfig_SqlScript struct {
	// The query text.
	// The execution args are used to declare a set of script variables
	// (`set key="value";`).
	SqlScript string `protobuf:"bytes,105,opt,name=sql_script,json=sqlScript,proto3,oneof"`
}

func (*Task_SparkTaskConfig_MainJarFileUri) isTask_SparkTaskConfig_Driver() {}

func (*Task_SparkTaskConfig_MainClass) isTask_SparkTaskConfig_Driver() {}

func (*Task_SparkTaskConfig_PythonScriptFile) isTask_SparkTaskConfig_Driver() {}

func (*Task_SparkTaskConfig_SqlScriptFile) isTask_SparkTaskConfig_Driver() {}

func (*Task_SparkTaskConfig_SqlScript) isTask_SparkTaskConfig_Driver() {}

// Config for running scheduled notebooks.
type Task_NotebookTaskConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Path to input notebook. This can be the Cloud Storage URI of the notebook
	// file or the path to a Notebook Content. The execution args are accessible
	// as environment variables
	// (`TASK_key=value`).
	Notebook string `protobuf:"bytes,4,opt,name=notebook,proto3" json:"notebook,omitempty"`
	// Optional. Infrastructure specification for the execution.
	InfrastructureSpec *Task_InfrastructureSpec `protobuf:"bytes,3,opt,name=infrastructure_spec,json=infrastructureSpec,proto3" json:"infrastructure_spec,omitempty"`
	// Optional. Cloud Storage URIs of files to be placed in the working directory of each
	// executor.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. Cloud Storage URIs of archives to be extracted into the working directory
	// of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and
	// .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
}

func (x *Task_NotebookTaskConfig) Reset() {
	*x = Task_NotebookTaskConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_NotebookTaskConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_NotebookTaskConfig) ProtoMessage() {}

func (x *Task_NotebookTaskConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_NotebookTaskConfig.ProtoReflect.Descriptor instead.
func (*Task_NotebookTaskConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Task_NotebookTaskConfig) GetNotebook() string {
	if x != nil {
		return x.Notebook
	}
	return ""
}

func (x *Task_NotebookTaskConfig) GetInfrastructureSpec() *Task_InfrastructureSpec {
	if x != nil {
		return x.InfrastructureSpec
	}
	return nil
}

func (x *Task_NotebookTaskConfig) GetFileUris() []string {
	if x != nil {
		return x.FileUris
	}
	return nil
}

func (x *Task_NotebookTaskConfig) GetArchiveUris() []string {
	if x != nil {
		return x.ArchiveUris
	}
	return nil
}

// Status of the task execution (e.g. Jobs).
type Task_ExecutionStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Last update time of the status.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. latest job execution
	LatestJob *Job `protobuf:"bytes,9,opt,name=latest_job,json=latestJob,proto3" json:"latest_job,omitempty"`
}

func (x *Task_ExecutionStatus) Reset() {
	*x = Task_ExecutionStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_ExecutionStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_ExecutionStatus) ProtoMessage() {}

func (x *Task_ExecutionStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_ExecutionStatus.ProtoReflect.Descriptor instead.
func (*Task_ExecutionStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Task_ExecutionStatus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Task_ExecutionStatus) GetLatestJob() *Job {
	if x != nil {
		return x.LatestJob
	}
	return nil
}

// Batch compute resources associated with the task.
type Task_InfrastructureSpec_BatchComputeResources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Total number of job executors.
	// Executor Count should be between 2 and 100. [Default=2]
	ExecutorsCount int32 `protobuf:"varint,1,opt,name=executors_count,json=executorsCount,proto3" json:"executors_count,omitempty"`
	// Optional. Max configurable executors.
	// If max_executors_count > executors_count, then auto-scaling is enabled.
	// Max Executor Count should be between 2 and 1000. [Default=1000]
	MaxExecutorsCount int32 `protobuf:"varint,2,opt,name=max_executors_count,json=maxExecutorsCount,proto3" json:"max_executors_count,omitempty"`
}

func (x *Task_InfrastructureSpec_BatchComputeResources) Reset() {
	*x = Task_InfrastructureSpec_BatchComputeResources{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_InfrastructureSpec_BatchComputeResources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_InfrastructureSpec_BatchComputeResources) ProtoMessage() {}

func (x *Task_InfrastructureSpec_BatchComputeResources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_InfrastructureSpec_BatchComputeResources.ProtoReflect.Descriptor instead.
func (*Task_InfrastructureSpec_BatchComputeResources) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Task_InfrastructureSpec_BatchComputeResources) GetExecutorsCount() int32 {
	if x != nil {
		return x.ExecutorsCount
	}
	return 0
}

func (x *Task_InfrastructureSpec_BatchComputeResources) GetMaxExecutorsCount() int32 {
	if x != nil {
		return x.MaxExecutorsCount
	}
	return 0
}

// Container Image Runtime Configuration used with Batch execution.
type Task_InfrastructureSpec_ContainerImageRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Container image to use.
	Image string `protobuf:"bytes,1,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. A list of Java JARS to add to the classpath.
	// Valid input includes Cloud Storage URIs to Jar binaries.
	// For example, gs://bucket-name/my/path/to/file.jar
	JavaJars []string `protobuf:"bytes,2,rep,name=java_jars,json=javaJars,proto3" json:"java_jars,omitempty"`
	// Optional. A list of python packages to be installed.
	// Valid formats include Cloud Storage URI to a PIP installable library.
	// For example, gs://bucket-name/my/path/to/lib.tar.gz
	PythonPackages []string `protobuf:"bytes,3,rep,name=python_packages,json=pythonPackages,proto3" json:"python_packages,omitempty"`
	// Optional. Override to common configuration of open source components installed on
	// the Dataproc cluster.
	// The properties to set on daemon config files.
	// Property keys are specified in `prefix:property` format, for example
	// `core:hadoop.tmp.dir`.
	// For more information, see [Cluster
	// properties](https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) Reset() {
	*x = Task_InfrastructureSpec_ContainerImageRuntime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_InfrastructureSpec_ContainerImageRuntime) ProtoMessage() {}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_InfrastructureSpec_ContainerImageRuntime.ProtoReflect.Descriptor instead.
func (*Task_InfrastructureSpec_ContainerImageRuntime) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 0, 1}
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) GetImage() string {
	if x != nil {
		return x.Image
	}
	return ""
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) GetJavaJars() []string {
	if x != nil {
		return x.JavaJars
	}
	return nil
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) GetPythonPackages() []string {
	if x != nil {
		return x.PythonPackages
	}
	return nil
}

func (x *Task_InfrastructureSpec_ContainerImageRuntime) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Cloud VPC Network used to run the infrastructure.
type Task_InfrastructureSpec_VpcNetwork struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Cloud VPC network identifier.
	//
	// Types that are assignable to NetworkName:
	//
	//	*Task_InfrastructureSpec_VpcNetwork_Network
	//	*Task_InfrastructureSpec_VpcNetwork_SubNetwork
	NetworkName isTask_InfrastructureSpec_VpcNetwork_NetworkName `protobuf_oneof:"network_name"`
	// Optional. List of network tags to apply to the job.
	NetworkTags []string `protobuf:"bytes,3,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
}

func (x *Task_InfrastructureSpec_VpcNetwork) Reset() {
	*x = Task_InfrastructureSpec_VpcNetwork{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task_InfrastructureSpec_VpcNetwork) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task_InfrastructureSpec_VpcNetwork) ProtoMessage() {}

func (x *Task_InfrastructureSpec_VpcNetwork) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_tasks_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task_InfrastructureSpec_VpcNetwork.ProtoReflect.Descriptor instead.
func (*Task_InfrastructureSpec_VpcNetwork) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP(), []int{0, 0, 2}
}

func (m *Task_InfrastructureSpec_VpcNetwork) GetNetworkName() isTask_InfrastructureSpec_VpcNetwork_NetworkName {
	if m != nil {
		return m.NetworkName
	}
	return nil
}

func (x *Task_InfrastructureSpec_VpcNetwork) GetNetwork() string {
	if x, ok := x.GetNetworkName().(*Task_InfrastructureSpec_VpcNetwork_Network); ok {
		return x.Network
	}
	return ""
}

func (x *Task_InfrastructureSpec_VpcNetwork) GetSubNetwork() string {
	if x, ok := x.GetNetworkName().(*Task_InfrastructureSpec_VpcNetwork_SubNetwork); ok {
		return x.SubNetwork
	}
	return ""
}

func (x *Task_InfrastructureSpec_VpcNetwork) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

type isTask_InfrastructureSpec_VpcNetwork_NetworkName interface {
	isTask_InfrastructureSpec_VpcNetwork_NetworkName()
}

type Task_InfrastructureSpec_VpcNetwork_Network struct {
	// Optional. The Cloud VPC network in which the job is run. By default, the Cloud
	// VPC network named Default within the project is used.
	Network string `protobuf:"bytes,1,opt,name=network,proto3,oneof"`
}

type Task_InfrastructureSpec_VpcNetwork_SubNetwork struct {
	// Optional. The Cloud VPC sub-network in which the job is run.
	SubNetwork string `protobuf:"bytes,2,opt,name=sub_network,json=subNetwork,proto3,oneof"`
}

func (*Task_InfrastructureSpec_VpcNetwork_Network) isTask_InfrastructureSpec_VpcNetwork_NetworkName() {
}

func (*Task_InfrastructureSpec_VpcNetwork_SubNetwork) isTask_InfrastructureSpec_VpcNetwork_NetworkName() {
}

var File_google_cloud_dataplex_v1_tasks_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_tasks_proto_rawDesc = []byte{
	0x0a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x93, 0x1b, 0x0a, 0x04, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x52, 0x0a, 0x0c, 0x74, 0x72, 0x69,
	0x67, 0x67, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x58, 0x0a,
	0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0xc9, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x72,
	0x6b, 0x18, 0xac, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x54, 0x61,
	0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x05, 0x73, 0x70, 0x61, 0x72,
	0x6b, 0x12, 0x50, 0x0a, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x18, 0xae, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x2e, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x61, 0x73,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62,
	0x6f, 0x6f, 0x6b, 0x1a, 0xbc, 0x07, 0x0a, 0x12, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5f, 0x0a, 0x05, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x48, 0x00, 0x52, 0x05, 0x62, 0x61, 0x74, 0x63, 0x68, 0x12, 0x72, 0x0a, 0x0f, 0x63,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x65,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x48, 0x01, 0x52,
	0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x12,
	0x60, 0x0a, 0x0b, 0x76, 0x70, 0x63, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x96,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x48, 0x02, 0x52, 0x0a, 0x76, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x1a, 0x7a, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x6f, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xbf, 0x02,
	0x0a, 0x15, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x6a, 0x61, 0x76, 0x61, 0x5f, 0x6a, 0x61, 0x72, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6a, 0x61, 0x76, 0x61,
	0x4a, 0x61, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x73, 0x12, 0x7c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x2e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x1a, 0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x8d, 0x01, 0x0a, 0x0a, 0x56, 0x70, 0x63, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x1f,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0x26, 0x0a, 0x0b, 0x73, 0x75, 0x62, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x73, 0x75, 0x62,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x42,
	0x0e, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x0b, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07,
	0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x1a, 0xcb, 0x02, 0x0a, 0x0b, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x4b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x2e, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x1f, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x61, 0x78, 0x52,
	0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x08, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x22, 0x3a, 0x0a, 0x04, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4f, 0x4e, 0x5f, 0x44, 0x45,
	0x4d, 0x41, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x43, 0x55, 0x52, 0x52,
	0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x09, 0x0a, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x1a, 0xe1, 0x02, 0x0a, 0x0d, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x4f, 0x0a, 0x04, 0x61, 0x72, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x41,
	0x72, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61,
	0x72, 0x67, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x5b, 0x0a, 0x1a, 0x6d, 0x61, 0x78, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x6d, 0x61, 0x78, 0x4a, 0x6f, 0x62, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x66, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x1a, 0x37, 0x0a, 0x09, 0x41,
	0x72, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x97, 0x03, 0x0a, 0x0f, 0x53, 0x70, 0x61, 0x72, 0x6b, 0x54, 0x61,
	0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x11, 0x6d, 0x61, 0x69, 0x6e,
	0x5f, 0x6a, 0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x61, 0x69, 0x6e, 0x4a, 0x61, 0x72, 0x46, 0x69,
	0x6c, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0a, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x18, 0x65, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x61, 0x69,
	0x6e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x2e, 0x0a, 0x12, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e,
	0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x66, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x10, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x53, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x68, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x0d, 0x73, 0x71, 0x6c, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x1f, 0x0a, 0x0a, 0x73, 0x71, 0x6c, 0x5f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x69,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x73, 0x71, 0x6c, 0x53, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x55,
	0x72, 0x69, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12, 0x67, 0x0a, 0x13, 0x69,
	0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x12, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x1a, 0xe8,
	0x01, 0x0a, 0x12, 0x4e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x61, 0x73, 0x6b, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x62, 0x6f, 0x6f,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6e, 0x6f,
	0x74, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x12, 0x67, 0x0a, 0x13, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x61, 0x73, 0x6b, 0x2e, 0x49, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x6e, 0x66,
	0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x20, 0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x69,
	0x73, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x72,
	0x63, 0x68, 0x69, 0x76, 0x65, 0x55, 0x72, 0x69, 0x73, 0x1a, 0x96, 0x01, 0x0a, 0x0f, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x41, 0x0a, 0x0a, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4a,
	0x6f, 0x62, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x64, 0xea,
	0x41, 0x61, 0x0a, 0x1c, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b,
	0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f,
	0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b, 0x74, 0x61,
	0x73, 0x6b, 0x7d, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xd8, 0x05,
	0x0a, 0x03, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x23, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x24, 0x0a, 0x0b, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x74,
	0x72, 0x79, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x24, 0x0a,
	0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x30, 0x0a, 0x07, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x17, 0x0a,
	0x13, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x50, 0x52,
	0x4f, 0x43, 0x10, 0x01, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x42, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x10, 0x06, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x1b, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4a, 0x6f, 0x62, 0x12, 0x4c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x73, 0x2f, 0x7b, 0x6c, 0x61, 0x6b, 0x65, 0x7d,
	0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b, 0x7d, 0x2f, 0x6a, 0x6f,
	0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x6e, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x3b,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_tasks_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_tasks_proto_rawDescData = file_google_cloud_dataplex_v1_tasks_proto_rawDesc
)

func file_google_cloud_dataplex_v1_tasks_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_tasks_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_tasks_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_tasks_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_tasks_proto_rawDescData
}

var file_google_cloud_dataplex_v1_tasks_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dataplex_v1_tasks_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_google_cloud_dataplex_v1_tasks_proto_goTypes = []interface{}{
	(Task_TriggerSpec_Type)(0),      // 0: google.cloud.dataplex.v1.Task.TriggerSpec.Type
	(Job_Service)(0),                // 1: google.cloud.dataplex.v1.Job.Service
	(Job_State)(0),                  // 2: google.cloud.dataplex.v1.Job.State
	(*Task)(nil),                    // 3: google.cloud.dataplex.v1.Task
	(*Job)(nil),                     // 4: google.cloud.dataplex.v1.Job
	(*Task_InfrastructureSpec)(nil), // 5: google.cloud.dataplex.v1.Task.InfrastructureSpec
	(*Task_TriggerSpec)(nil),        // 6: google.cloud.dataplex.v1.Task.TriggerSpec
	(*Task_ExecutionSpec)(nil),      // 7: google.cloud.dataplex.v1.Task.ExecutionSpec
	(*Task_SparkTaskConfig)(nil),    // 8: google.cloud.dataplex.v1.Task.SparkTaskConfig
	(*Task_NotebookTaskConfig)(nil), // 9: google.cloud.dataplex.v1.Task.NotebookTaskConfig
	(*Task_ExecutionStatus)(nil),    // 10: google.cloud.dataplex.v1.Task.ExecutionStatus
	nil,                             // 11: google.cloud.dataplex.v1.Task.LabelsEntry
	(*Task_InfrastructureSpec_BatchComputeResources)(nil), // 12: google.cloud.dataplex.v1.Task.InfrastructureSpec.BatchComputeResources
	(*Task_InfrastructureSpec_ContainerImageRuntime)(nil), // 13: google.cloud.dataplex.v1.Task.InfrastructureSpec.ContainerImageRuntime
	(*Task_InfrastructureSpec_VpcNetwork)(nil),            // 14: google.cloud.dataplex.v1.Task.InfrastructureSpec.VpcNetwork
	nil,                           // 15: google.cloud.dataplex.v1.Task.InfrastructureSpec.ContainerImageRuntime.PropertiesEntry
	nil,                           // 16: google.cloud.dataplex.v1.Task.ExecutionSpec.ArgsEntry
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
	(State)(0),                    // 18: google.cloud.dataplex.v1.State
	(*durationpb.Duration)(nil),   // 19: google.protobuf.Duration
}
var file_google_cloud_dataplex_v1_tasks_proto_depIdxs = []int32{
	17, // 0: google.cloud.dataplex.v1.Task.create_time:type_name -> google.protobuf.Timestamp
	17, // 1: google.cloud.dataplex.v1.Task.update_time:type_name -> google.protobuf.Timestamp
	18, // 2: google.cloud.dataplex.v1.Task.state:type_name -> google.cloud.dataplex.v1.State
	11, // 3: google.cloud.dataplex.v1.Task.labels:type_name -> google.cloud.dataplex.v1.Task.LabelsEntry
	6,  // 4: google.cloud.dataplex.v1.Task.trigger_spec:type_name -> google.cloud.dataplex.v1.Task.TriggerSpec
	7,  // 5: google.cloud.dataplex.v1.Task.execution_spec:type_name -> google.cloud.dataplex.v1.Task.ExecutionSpec
	10, // 6: google.cloud.dataplex.v1.Task.execution_status:type_name -> google.cloud.dataplex.v1.Task.ExecutionStatus
	8,  // 7: google.cloud.dataplex.v1.Task.spark:type_name -> google.cloud.dataplex.v1.Task.SparkTaskConfig
	9,  // 8: google.cloud.dataplex.v1.Task.notebook:type_name -> google.cloud.dataplex.v1.Task.NotebookTaskConfig
	17, // 9: google.cloud.dataplex.v1.Job.start_time:type_name -> google.protobuf.Timestamp
	17, // 10: google.cloud.dataplex.v1.Job.end_time:type_name -> google.protobuf.Timestamp
	2,  // 11: google.cloud.dataplex.v1.Job.state:type_name -> google.cloud.dataplex.v1.Job.State
	1,  // 12: google.cloud.dataplex.v1.Job.service:type_name -> google.cloud.dataplex.v1.Job.Service
	12, // 13: google.cloud.dataplex.v1.Task.InfrastructureSpec.batch:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec.BatchComputeResources
	13, // 14: google.cloud.dataplex.v1.Task.InfrastructureSpec.container_image:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec.ContainerImageRuntime
	14, // 15: google.cloud.dataplex.v1.Task.InfrastructureSpec.vpc_network:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec.VpcNetwork
	0,  // 16: google.cloud.dataplex.v1.Task.TriggerSpec.type:type_name -> google.cloud.dataplex.v1.Task.TriggerSpec.Type
	17, // 17: google.cloud.dataplex.v1.Task.TriggerSpec.start_time:type_name -> google.protobuf.Timestamp
	16, // 18: google.cloud.dataplex.v1.Task.ExecutionSpec.args:type_name -> google.cloud.dataplex.v1.Task.ExecutionSpec.ArgsEntry
	19, // 19: google.cloud.dataplex.v1.Task.ExecutionSpec.max_job_execution_lifetime:type_name -> google.protobuf.Duration
	5,  // 20: google.cloud.dataplex.v1.Task.SparkTaskConfig.infrastructure_spec:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec
	5,  // 21: google.cloud.dataplex.v1.Task.NotebookTaskConfig.infrastructure_spec:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec
	17, // 22: google.cloud.dataplex.v1.Task.ExecutionStatus.update_time:type_name -> google.protobuf.Timestamp
	4,  // 23: google.cloud.dataplex.v1.Task.ExecutionStatus.latest_job:type_name -> google.cloud.dataplex.v1.Job
	15, // 24: google.cloud.dataplex.v1.Task.InfrastructureSpec.ContainerImageRuntime.properties:type_name -> google.cloud.dataplex.v1.Task.InfrastructureSpec.ContainerImageRuntime.PropertiesEntry
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_tasks_proto_init() }
func file_google_cloud_dataplex_v1_tasks_proto_init() {
	if File_google_cloud_dataplex_v1_tasks_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Job); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_InfrastructureSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_TriggerSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_ExecutionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_SparkTaskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_NotebookTaskConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_ExecutionStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_InfrastructureSpec_BatchComputeResources); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_InfrastructureSpec_ContainerImageRuntime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataplex_v1_tasks_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task_InfrastructureSpec_VpcNetwork); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataplex_v1_tasks_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Task_Spark)(nil),
		(*Task_Notebook)(nil),
	}
	file_google_cloud_dataplex_v1_tasks_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*Task_InfrastructureSpec_Batch)(nil),
		(*Task_InfrastructureSpec_ContainerImage)(nil),
		(*Task_InfrastructureSpec_VpcNetwork_)(nil),
	}
	file_google_cloud_dataplex_v1_tasks_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Task_TriggerSpec_Schedule)(nil),
	}
	file_google_cloud_dataplex_v1_tasks_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*Task_SparkTaskConfig_MainJarFileUri)(nil),
		(*Task_SparkTaskConfig_MainClass)(nil),
		(*Task_SparkTaskConfig_PythonScriptFile)(nil),
		(*Task_SparkTaskConfig_SqlScriptFile)(nil),
		(*Task_SparkTaskConfig_SqlScript)(nil),
	}
	file_google_cloud_dataplex_v1_tasks_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*Task_InfrastructureSpec_VpcNetwork_Network)(nil),
		(*Task_InfrastructureSpec_VpcNetwork_SubNetwork)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_tasks_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataplex_v1_tasks_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_tasks_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_tasks_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_tasks_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_tasks_proto = out.File
	file_google_cloud_dataplex_v1_tasks_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_tasks_proto_goTypes = nil
	file_google_cloud_dataplex_v1_tasks_proto_depIdxs = nil
}
